/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(zx input, zx ingredient, zx output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(zx input, String ingredient, zx output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingOreRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    public static zx getOutput(zx input, zx ingredient) {
        if (input == null || input.c() != 1 || input.b != 1) {
            return null;
        }
        if (ingredient == null || ingredient.b <= 0) {
            return null;
        }
        for (IBrewingRecipe recipe : recipes) {
            zx output = recipe.getOutput(input, ingredient);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    public static boolean hasOuput(zx input, zx ingredient) {
        return BrewingRecipeRegistry.getOutput(input, ingredient) != null;
    }

    public static boolean canBrew(zx[] inputs, zx ingredient, int[] inputIndexes) {
        if (ingredient == null || ingredient.b <= 0) {
            return false;
        }
        for (int i2 : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOuput(inputs[i2], ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(zx[] inputs, zx ingredient, int[] inputIndexes) {
        for (int i2 : inputIndexes) {
            zx output = BrewingRecipeRegistry.getOutput(inputs[i2], ingredient);
            if (output == null) continue;
            inputs[i2] = output;
        }
    }

    public static boolean isValidIngredient(zx stack) {
        if (stack == null || stack.b <= 0) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(zx stack) {
        if (stack == null || stack.c() != 1 || stack.b != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

