/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class FluidContainerRegistry {
    private static Map<ContainerKey, FluidContainerData> containerFluidMap = Maps.newHashMap();
    private static Map<ContainerKey, FluidContainerData> filledContainerMap = Maps.newHashMap();
    private static Set<ContainerKey> emptyContainers = Sets.newHashSet();
    public static final int BUCKET_VOLUME = 1000;
    public static final zx EMPTY_BUCKET = new zx(zy.aw);
    public static final zx EMPTY_BOTTLE = new zx(zy.bA);
    private static final zx NULL_EMPTYCONTAINER = new zx(zy.aw);

    private FluidContainerRegistry() {
    }

    public static boolean registerFluidContainer(FluidStack stack, zx filledContainer, zx emptyContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, emptyContainer));
    }

    public static boolean registerFluidContainer(Fluid fluid, zx filledContainer, zx emptyContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer, emptyContainer);
    }

    public static boolean registerFluidContainer(FluidStack stack, zx filledContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, null, true));
    }

    public static boolean registerFluidContainer(Fluid fluid, zx filledContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer);
    }

    public static boolean registerFluidContainer(FluidContainerData data) {
        if (FluidContainerRegistry.isFilledContainer(data.filledContainer) || data.filledContainer == null) {
            return false;
        }
        if (data.fluid == null || data.fluid.getFluid() == null) {
            FMLLog.bigWarning("Invalid registration attempt for a fluid container item %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", data.filledContainer.b().e_(data.filledContainer));
            return false;
        }
        containerFluidMap.put(new ContainerKey(data.filledContainer), data);
        if (data.emptyContainer != null && data.emptyContainer != NULL_EMPTYCONTAINER) {
            filledContainerMap.put(new ContainerKey(data.emptyContainer, data.fluid), data);
            emptyContainers.add(new ContainerKey(data.emptyContainer));
        }
        MinecraftForge.EVENT_BUS.post(new FluidContainerRegisterEvent(data));
        return true;
    }

    public static FluidStack getFluidForFilledItem(zx container) {
        if (container == null) {
            return null;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data == null ? null : data.fluid.copy();
    }

    public static zx fillFluidContainer(FluidStack fluid, zx container) {
        if (container == null || fluid == null) {
            return null;
        }
        FluidContainerData data = filledContainerMap.get(new ContainerKey(container, fluid));
        if (data != null && fluid.amount >= data.fluid.amount) {
            return data.filledContainer.k();
        }
        return null;
    }

    public static zx drainFluidContainer(zx container) {
        if (container == null) {
            return null;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        if (data != null) {
            return data.emptyContainer.k();
        }
        return null;
    }

    public static int getContainerCapacity(zx container) {
        return FluidContainerRegistry.getContainerCapacity(null, container);
    }

    public static int getContainerCapacity(FluidStack fluid, zx container) {
        if (container == null) {
            return 0;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        if (data != null) {
            return data.fluid.amount;
        }
        if (fluid != null && (data = filledContainerMap.get(new ContainerKey(container, fluid))) != null) {
            return data.fluid.amount;
        }
        return 0;
    }

    public static boolean containsFluid(zx container, FluidStack fluid) {
        if (container == null || fluid == null) {
            return false;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data == null ? false : data.fluid.containsFluid(fluid);
    }

    public static boolean isBucket(zx container) {
        if (container == null) {
            return false;
        }
        if (container.a(EMPTY_BUCKET)) {
            return true;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data != null && data.emptyContainer.a(EMPTY_BUCKET);
    }

    public static boolean isContainer(zx container) {
        return FluidContainerRegistry.isEmptyContainer(container) || FluidContainerRegistry.isFilledContainer(container);
    }

    public static boolean isEmptyContainer(zx container) {
        return container != null && emptyContainers.contains(new ContainerKey(container));
    }

    public static boolean isFilledContainer(zx container) {
        return container != null && FluidContainerRegistry.getFluidForFilledItem(container) != null;
    }

    public static FluidContainerData[] getRegisteredFluidContainerData() {
        return containerFluidMap.values().toArray(new FluidContainerData[containerFluidMap.size()]);
    }

    static {
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new zx(zy.ax), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.LAVA, new zx(zy.ay), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new zx((zw)zy.bz), EMPTY_BOTTLE);
    }

    public static class FluidContainerRegisterEvent
    extends Event {
        public final FluidContainerData data;

        public FluidContainerRegisterEvent(FluidContainerData data) {
            this.data = data.copy();
        }
    }

    public static class FluidContainerData {
        public final FluidStack fluid;
        public final zx filledContainer;
        public final zx emptyContainer;

        public FluidContainerData(FluidStack stack, zx filledContainer, zx emptyContainer) {
            this(stack, filledContainer, emptyContainer, false);
        }

        public FluidContainerData(FluidStack stack, zx filledContainer, zx emptyContainer, boolean nullEmpty) {
            this.fluid = stack;
            this.filledContainer = filledContainer;
            zx zx2 = this.emptyContainer = emptyContainer == null ? NULL_EMPTYCONTAINER : emptyContainer;
            if (stack == null || filledContainer == null || emptyContainer == null && !nullEmpty) {
                throw new RuntimeException("Invalid FluidContainerData - a parameter was null.");
            }
        }

        public FluidContainerData copy() {
            return new FluidContainerData(this.fluid, this.filledContainer, this.emptyContainer, true);
        }
    }

    private static class ContainerKey {
        zx container;
        FluidStack fluid;

        private ContainerKey(zx container) {
            this.container = container;
        }

        private ContainerKey(zx container, FluidStack fluid) {
            this(container);
            this.fluid = fluid;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.container.b().hashCode();
            code = 31 * code + this.container.h();
            if (this.fluid != null) {
                code = 31 * code + this.fluid.getFluid().hashCode();
            }
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ContainerKey)) {
                return false;
            }
            ContainerKey ck = (ContainerKey)o;
            if (this.container.b() != ck.container.b()) {
                return false;
            }
            if (this.container.h() != ck.container.h()) {
                return false;
            }
            if (this.fluid == null && ck.fluid != null) {
                return false;
            }
            if (this.fluid != null && ck.fluid == null) {
                return false;
            }
            if (this.fluid == null && ck.fluid == null) {
                return true;
            }
            return this.fluid.getFluid() == ck.fluid.getFluid();
        }
    }
}

