/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.IRecipeGuiLogic;
import mezz.jei.gui.RecipeLayout;
import mezz.jei.util.Log;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    @Nullable
    private State state = null;
    @Nonnull
    private final Stack<State> history = new Stack();
    @Nonnull
    private List<Object> recipes = Collections.emptyList();
    private int recipesPerPage = 0;

    @Override
    public boolean setFocus(@Nonnull Focus focus) {
        return this.setFocus(focus, true);
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        State state = this.history.pop();
        this.setState(state);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private boolean setFocus(@Nonnull Focus focus, boolean saveHistory) {
        if (this.state != null && this.state.focus.equalsFocus(focus)) {
            return true;
        }
        List<IRecipeCategory> recipeCategories = focus.getCategories();
        if (recipeCategories.isEmpty()) {
            return false;
        }
        int recipeCategoryIndex = RecipeGuiLogic.getRecipeCategoryIndex(recipeCategories);
        if (this.state != null && saveHistory) {
            this.history.push(this.state);
        }
        State state = new State(focus, recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    private void setState(@Nonnull State state) {
        this.state = state;
        this.updateRecipes();
    }

    private static int getRecipeCategoryIndex(@Nonnull List<IRecipeCategory> recipeCategories) {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (container == null) {
            return 0;
        }
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        for (int i = 0; i < recipeCategories.size(); ++i) {
            IRecipeCategory recipeCategory = recipeCategories.get(i);
            if (recipeRegistry.getRecipeTransferHandler(container, recipeCategory) == null) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean setCategoryFocus() {
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return false;
        }
        if (this.state != null) {
            this.history.push(this.state);
        }
        ImmutableList<IRecipeCategory> recipeCategories = Internal.getRuntime().getRecipeRegistry().getRecipeCategories();
        int recipeCategoryIndex = recipeCategories.indexOf(recipeCategory);
        State state = new State(new Focus(), (List<IRecipeCategory>)recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    @Override
    public boolean setCategoryFocus(List<String> recipeCategoryUids) {
        ImmutableList<IRecipeCategory> recipeCategories = Internal.getRuntime().getRecipeRegistry().getRecipeCategories(recipeCategoryUids);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (this.state != null) {
            this.history.push(this.state);
        }
        State state = new State(new Focus(), (List<IRecipeCategory>)recipeCategories, 0, 0);
        this.setState(state);
        return true;
    }

    @Override
    public Focus getFocus() {
        if (this.state == null) {
            return null;
        }
        return this.state.focus;
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state == null) {
            return;
        }
        if (this.recipesPerPage != recipesPerPage) {
            int recipeIndex = this.state.pageIndex * this.recipesPerPage;
            this.state.pageIndex = recipeIndex / recipesPerPage;
            this.recipesPerPage = recipesPerPage;
            this.updateRecipes();
        }
    }

    private void updateRecipes() {
        if (this.state == null) {
            return;
        }
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        this.recipes = recipeCategory == null ? Collections.emptyList() : this.state.focus.getRecipes(recipeCategory);
    }

    @Override
    @Nullable
    public IRecipeCategory getRecipeCategory() {
        if (this.state == null || this.state.recipeCategories.size() == 0) {
            return null;
        }
        return (IRecipeCategory)this.state.recipeCategories.get(this.state.recipeCategoryIndex);
    }

    @Override
    @Nonnull
    public List<RecipeLayout> getRecipeWidgets(int posX, int posY, int spacingY) {
        if (this.state == null) {
            return Collections.emptyList();
        }
        ArrayList<RecipeLayout> recipeWidgets = new ArrayList<RecipeLayout>();
        IRecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return recipeWidgets;
        }
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        int recipeWidgetIndex = 0;
        for (int recipeIndex = this.state.pageIndex * this.recipesPerPage; recipeIndex < this.recipes.size() && recipeWidgets.size() < this.recipesPerPage; ++recipeIndex) {
            Object recipe = this.recipes.get(recipeIndex);
            IRecipeHandler recipeHandler = recipeRegistry.getRecipeHandler(recipe.getClass());
            if (recipeHandler == null) {
                Log.error("Couldn't find recipe handler for recipe: {}", recipe);
                continue;
            }
            IRecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
            RecipeLayout recipeWidget = new RecipeLayout(recipeWidgetIndex++, posX, posY, recipeCategory, recipeWrapper, this.state.focus);
            recipeWidgets.add(recipeWidget);
            posY += spacingY;
        }
        return recipeWidgets;
    }

    @Override
    public void nextRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.state.recipeCategories.size();
        this.state.recipeCategoryIndex = (this.state.recipeCategoryIndex + 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    @Override
    public boolean hasMultiplePages() {
        return this.recipes.size() > this.recipesPerPage;
    }

    @Override
    public void previousRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.state.recipeCategories.size();
        this.state.recipeCategoryIndex = (recipesTypesCount + this.state.recipeCategoryIndex - 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    @Override
    public void nextPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.recipesPerPage);
        this.state.pageIndex = (this.state.pageIndex + 1) % pageCount;
        this.updateRecipes();
    }

    @Override
    public void previousPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.recipesPerPage);
        this.state.pageIndex = (pageCount + this.state.pageIndex - 1) % pageCount;
        this.updateRecipes();
    }

    private int pageCount(int recipesPerPage) {
        if (this.recipes.size() <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(this.recipes.size(), recipesPerPage);
    }

    @Override
    @Nonnull
    public String getPageString() {
        if (this.state == null) {
            return "1/1";
        }
        return this.state.pageIndex + 1 + "/" + this.pageCount(this.recipesPerPage);
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state != null && this.state.recipeCategories.size() > 1;
    }

    private static class State {
        @Nonnull
        public final Focus focus;
        @Nonnull
        public ImmutableList<IRecipeCategory> recipeCategories;
        public int recipeCategoryIndex;
        public int pageIndex;

        public State(@Nonnull Focus focus, @Nonnull List<IRecipeCategory> recipeCategories, int recipeCategoryIndex, int pageIndex) {
            this.focus = focus;
            this.recipeCategories = ImmutableList.copyOf(recipeCategories);
            this.recipeCategoryIndex = recipeCategoryIndex;
            this.pageIndex = pageIndex;
        }
    }
}

