/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;

public class FuelRecipeHandler
implements IRecipeHandler<FuelRecipe> {
    @Override
    @Nonnull
    public Class<FuelRecipe> getRecipeClass() {
        return FuelRecipe.class;
    }

    @Override
    @Nonnull
    public String getRecipeCategoryUid() {
        return "minecraft.fuel";
    }

    @Override
    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull FuelRecipe recipe) {
        return recipe;
    }

    @Override
    public boolean isRecipeValid(@Nonnull FuelRecipe recipe) {
        String recipeInfo;
        if (recipe.getInputs().isEmpty()) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has no inputs. {}", recipeInfo);
        }
        if (!recipe.getOutputs().isEmpty()) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Fuel Recipe should not have outputs. {}", recipeInfo);
        }
        return true;
    }
}

