/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketEntityUpdate;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.network.PacketGuiWidget;
import buildcraft.core.lib.network.PacketNBT;
import buildcraft.core.lib.network.PacketSlotChange;
import buildcraft.core.lib.network.PacketTileState;
import buildcraft.core.lib.network.PacketTileUpdate;
import buildcraft.core.lib.network.PacketUpdate;
import buildcraft.core.lib.network.command.PacketCommand;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.lang.ref.WeakReference;
import java.util.List;
import org.apache.logging.log4j.Level;

@ChannelHandler.Sharable
public final class ChannelHandler
extends MessageToMessageCodec<FMLProxyPacket, Packet> {
    public static final AttributeKey<ThreadLocal<WeakReference<FMLProxyPacket>>> INBOUNDPACKETTRACKER = new AttributeKey("bc:inboundpacket");
    private TByteObjectHashMap<Class<? extends Packet>> discriminators = new TByteObjectHashMap();
    private TObjectByteHashMap<Class<? extends Packet>> types = new TObjectByteHashMap();
    private int maxDiscriminator;

    public ChannelHandler() {
        this.addDiscriminator(0, PacketTileUpdate.class);
        this.addDiscriminator(1, PacketTileState.class);
        this.addDiscriminator(2, PacketNBT.class);
        this.addDiscriminator(3, PacketSlotChange.class);
        this.addDiscriminator(4, PacketGuiReturn.class);
        this.addDiscriminator(5, PacketGuiWidget.class);
        this.addDiscriminator(6, PacketUpdate.class);
        this.addDiscriminator(7, PacketCommand.class);
        this.addDiscriminator(8, PacketEntityUpdate.class);
        this.maxDiscriminator = 9;
    }

    public byte getDiscriminator(Class<? extends Packet> clazz) {
        return this.types.get(clazz);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public ChannelHandler addDiscriminator(int discriminator, Class<? extends Packet> type) {
        this.discriminators.put((byte)discriminator, type);
        this.types.put(type, (byte)discriminator);
        return this;
    }

    protected void encode(ChannelHandlerContext ctx, Packet msg, List<Object> out) throws Exception {
        FMLProxyPacket old;
        ByteBuf buffer = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        byte discriminator = this.types.get(clazz);
        buffer.writeByte((int)discriminator);
        msg.writeData(buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)ref.get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        this.testMessageValidity(msg);
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class clazz = (Class)this.discriminators.get(discriminator);
        if (clazz == null) {
            throw new NullPointerException("Undefined message for discriminator " + discriminator + " in channel " + msg.channel());
        }
        Packet newMsg = (Packet)clazz.newInstance();
        ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
        newMsg.readData(payload.slice());
        out.add(newMsg);
    }

    protected void testMessageValidity(FMLProxyPacket msg) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"BC ChannelHandler exception caught", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }

    public void registerPacketType(Class<? extends Packet> packetType) {
        this.addDiscriminator(this.maxDiscriminator++, packetType);
    }
}

