/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bittank;

import com.google.common.base.Predicate;
import mod.chiselsandbits.bittank.TileEntityBitTank;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBitTank
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(EnumFacing face) {
            return face != EnumFacing.DOWN && face != EnumFacing.UP;
        }
    });

    public BlockBitTank() {
        super(Material.field_151573_f);
        this.func_149672_a(field_149778_k);
        this.field_149785_s = true;
        this.func_149713_g(0);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        try {
            return this.getTileEntity(world, pos).getLightValue();
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return 0;
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean func_149730_j() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public float func_149685_I() {
        return 1.0f;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        throw new RuntimeException("Invalid State.");
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 0: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            case 1: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 2: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 3: {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
        }
        throw new RuntimeException("Invalid State.");
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBitTank();
    }

    public TileEntityBitTank getTileEntity(TileEntity te) throws ExceptionNoTileEntity {
        if (te instanceof TileEntityBitTank) {
            return (TileEntityBitTank)te;
        }
        throw new ExceptionNoTileEntity();
    }

    public TileEntityBitTank getTileEntity(IBlockAccess world, BlockPos pos) throws ExceptionNoTileEntity {
        return this.getTileEntity(world.func_175625_s(pos));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        try {
            TileEntityBitTank tank = this.getTileEntity((IBlockAccess)worldIn, pos);
            ItemStack current = playerIn.field_71071_by.func_70448_g();
            if (current != null) {
                IFluidHandler wrappedTank = tank.getWrappedTank();
                if (FluidUtil.interactWithTank((ItemStack)current, (EntityPlayer)playerIn, (IFluidHandler)wrappedTank, (EnumFacing)side)) {
                    return true;
                }
                if (FluidContainerRegistry.isBucket((ItemStack)current) || FluidContainerRegistry.isFilledContainer((ItemStack)current) || current.func_77973_b() instanceof IFluidContainerItem) {
                    return true;
                }
                if (tank.addHeldBits(current, playerIn)) {
                    return true;
                }
            } else if (tank.addAllPossibleBits(playerIn)) {
                return true;
            }
            if (tank.extractBits(playerIn, hitX, hitY, hitZ, pos)) {
                return true;
            }
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
        return false;
    }
}

