/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Random;
import mod.chiselsandbits.api.IgnoreBlockLogic;
import mod.chiselsandbits.chiseledblock.ReflectionHelperBlock;
import mod.chiselsandbits.chiseledblock.data.VoxelType;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BlockBitInfo {
    private static HashMap<Block, Boolean> ignoreLogicBlocks = new HashMap();
    private static HashMap<IBlockState, BlockBitInfo> stateBitInfo;
    private static HashMap<Block, Boolean> supportedBlocks;
    private static HashMap<Block, Fluid> fluidBlocks;
    private static TIntObjectMap<Fluid> fluidStates;
    private static HashMap<IBlockState, Integer> bitColor;
    public final boolean isCompatiable;
    public final float hardness;
    public final float explosionResistance;

    public static int getColorFor(IBlockState state, int renderPass) {
        Integer out = bitColor.get(state);
        if (out == null) {
            ItemStack target;
            Block blk = state.func_177230_c();
            Fluid fluid = BlockBitInfo.getFluidFromBlock(blk);
            out = fluid != null ? Integer.valueOf(fluid.getColor()) : ((target = ModUtil.getItemFromBlock(state)) == null ? Integer.valueOf(0xFFFFFF) : Integer.valueOf(target.func_77973_b().func_82790_a(target, renderPass)));
            bitColor.put(state, out);
        }
        return out;
    }

    public static void addFluidBlock(Block blk, Fluid fluid) {
        if (blk == null) {
            return;
        }
        fluidBlocks.put(blk, fluid);
        for (IBlockState state : blk.func_176194_O().func_177619_a()) {
            try {
                fluidStates.put(Block.func_176210_f((IBlockState)state), (Object)fluid);
            }
            catch (Throwable t) {
                Log.logError("Error while determining fluid state.", t);
            }
        }
        stateBitInfo.clear();
        supportedBlocks.clear();
    }

    public static Fluid getFluidFromBlock(Block blk) {
        return fluidBlocks.get(blk);
    }

    public static VoxelType getTypeFromStateID(int bit) {
        if (bit == 0) {
            return VoxelType.AIR;
        }
        return fluidStates.containsKey(bit) ? VoxelType.FLUID : VoxelType.SOLID;
    }

    public static void ignoreBlockLogic(Block which) {
        ignoreLogicBlocks.put(which, true);
        stateBitInfo.clear();
        supportedBlocks.clear();
    }

    public static BlockBitInfo getBlockInfo(IBlockState state) {
        BlockBitInfo bit = stateBitInfo.get(state);
        if (bit == null) {
            bit = BlockBitInfo.createFromState(state);
            stateBitInfo.put(state, bit);
        }
        return bit;
    }

    public static boolean supportsBlock(IBlockState state) {
        Block blk = state.func_177230_c();
        if (supportedBlocks.containsKey(blk)) {
            return supportedBlocks.get(blk);
        }
        try {
            ReflectionHelperBlock pb = new ReflectionHelperBlock();
            Class<?> blkClass = blk.getClass();
            pb.func_149745_a(null);
            Class<?> wc = blkClass.getMethod(pb.MethodName, Random.class).getDeclaringClass();
            boolean quantityDroppedTest = wc == Block.class || wc == BlockGlowstone.class || wc == BlockStainedGlass.class || wc == BlockGlass.class || wc == BlockSnowBlock.class;
            pb.func_149679_a(0, null);
            boolean quantityDroppedWithBonusTest = blkClass.getMethod(pb.MethodName, Integer.TYPE, Random.class).getDeclaringClass() == Block.class || wc == BlockGlowstone.class;
            pb.quantityDropped(null, 0, null);
            boolean quantityDropped2Test = blkClass.getMethod(pb.MethodName, IBlockState.class, Integer.TYPE, Random.class).getDeclaringClass() == Block.class;
            boolean isNotSlab = Item.func_150898_a((Block)blk) != null;
            boolean itemExistsOrNotSpecialDrops = quantityDroppedTest && quantityDroppedWithBonusTest && quantityDropped2Test || isNotSlab;
            pb.func_176199_a(null, null, null);
            boolean entityCollisionTest = blkClass.getMethod(pb.MethodName, World.class, BlockPos.class, Entity.class).getDeclaringClass() == Block.class || blkClass == BlockSlime.class;
            pb.func_180634_a(null, null, null, null);
            boolean entityCollision2Test = blkClass.getMethod(pb.MethodName, World.class, BlockPos.class, IBlockState.class, Entity.class).getDeclaringClass() == Block.class || blkClass == BlockSlime.class;
            boolean noCustomCollision = entityCollisionTest && entityCollision2Test;
            boolean isFullBlock = blk.func_149730_j() || blkClass == BlockStainedGlass.class || blkClass == BlockGlass.class || blk == Blocks.field_180399_cE || blk == Blocks.field_150432_aD;
            BlockBitInfo info = BlockBitInfo.createFromState(state);
            boolean hasBehavior = (blk.hasTileEntity(state) || blk.func_149653_t()) && blkClass != BlockGrass.class && blkClass != BlockIce.class;
            boolean supportedMaterial = ChiselsAndBits.getBlocks().getConversion(blk) != null;
            Boolean IgnoredLogic = ignoreLogicBlocks.get(blk);
            if (blkClass.isAnnotationPresent(IgnoreBlockLogic.class) || IgnoredLogic != null && IgnoredLogic.booleanValue()) {
                isFullBlock = true;
                noCustomCollision = true;
                hasBehavior = false;
                itemExistsOrNotSpecialDrops = true;
            }
            if (info.isCompatiable && noCustomCollision && info.hardness >= -0.01f && isFullBlock && supportedMaterial && !hasBehavior && itemExistsOrNotSpecialDrops) {
                boolean result = ChiselsAndBits.getConfig().isEnabled(blkClass.getName());
                supportedBlocks.put(blk, result);
                if (result) {
                    stateBitInfo.put(state, info);
                }
                return result;
            }
            if (fluidBlocks.containsKey(blk)) {
                stateBitInfo.put(state, info);
                supportedBlocks.put(blk, true);
                return true;
            }
            supportedBlocks.put(blk, false);
            return false;
        }
        catch (Throwable t) {
            supportedBlocks.put(blk, false);
            return false;
        }
    }

    private BlockBitInfo(boolean isCompatiable, float hardness, float explosionResistance) {
        this.isCompatiable = isCompatiable;
        this.hardness = hardness;
        this.explosionResistance = explosionResistance;
    }

    public static BlockBitInfo createFromState(IBlockState state) {
        try {
            ReflectionHelperBlock reflectBlock = new ReflectionHelperBlock();
            Block blk = state.func_177230_c();
            Class<?> blkClass = blk.getClass();
            reflectBlock.func_176195_g(null, null);
            Method hardnessMethod = blkClass.getMethod(reflectBlock.MethodName, World.class, BlockPos.class);
            boolean test_a = hardnessMethod.getDeclaringClass() == Block.class;
            reflectBlock.func_180647_a(null, null, null);
            boolean test_b = blkClass.getMethod(reflectBlock.MethodName, EntityPlayer.class, World.class, BlockPos.class).getDeclaringClass() == Block.class;
            reflectBlock.func_149638_a(null);
            Method exploResistance = blkClass.getMethod(reflectBlock.MethodName, Entity.class);
            boolean test_c = exploResistance.getDeclaringClass() == Block.class;
            reflectBlock.getExplosionResistance(null, null, null, null);
            boolean test_d = blkClass.getMethod(reflectBlock.MethodName, World.class, BlockPos.class, Entity.class, Explosion.class).getDeclaringClass() == Block.class;
            boolean isFluid = fluidStates.containsKey(Block.func_176210_f((IBlockState)state));
            if (test_a && test_b && test_c && test_d && !isFluid) {
                float blockHardness = blk.func_176195_g(null, null);
                float resistance = blk.func_149638_a(null);
                return new BlockBitInfo(true, blockHardness, resistance);
            }
            Block stone = Blocks.field_150348_b;
            return new BlockBitInfo(ChiselsAndBits.getConfig().compatabilityMode, stone.func_176195_g(null, null), stone.func_149638_a(null));
        }
        catch (Exception err) {
            return new BlockBitInfo(false, -1.0f, -1.0f);
        }
    }

    static {
        ignoreLogicBlocks.put((Block)Blocks.field_150362_t, true);
        ignoreLogicBlocks.put((Block)Blocks.field_150361_u, true);
        ignoreLogicBlocks.put(Blocks.field_150433_aE, true);
        stateBitInfo = new HashMap();
        supportedBlocks = new HashMap();
        fluidBlocks = new HashMap();
        fluidStates = new TIntObjectHashMap();
        bitColor = new HashMap();
    }
}

