/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BoxType;
import mod.chiselsandbits.chiseledblock.SubMaterial;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitCollisionIterator;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.data.VoxelNeighborRenderTracker;
import mod.chiselsandbits.chiseledblock.properties.UnlistedBlockStateID;
import mod.chiselsandbits.chiseledblock.properties.UnlistedVoxelBlob;
import mod.chiselsandbits.chiseledblock.properties.UnlistedVoxelNeighborState;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChiseled
extends Block
implements ITileEntityProvider {
    private static ThreadLocal<IBlockState> actingAs = new ThreadLocal();
    public static final IUnlistedProperty<VoxelNeighborRenderTracker> UProperty_VoxelNeighborState = new UnlistedVoxelNeighborState();
    public static final IUnlistedProperty<VoxelBlobStateReference> UProperty_VoxelBlob = new UnlistedVoxelBlob();
    public static final IUnlistedProperty<Integer> UProperty_Primary_BlockState = new UnlistedBlockStateID();
    public final String name;
    private final ThreadLocal<Block> testBlock = new ThreadLocal();
    ThreadLocal<Boolean> testingHarvest = new ThreadLocal();

    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB bb, Material materialIn) {
        try {
            return BlockChiseled.sharedIsAABBInsideMaterial(this.getTileEntity((IBlockAccess)world, pos), bb, materialIn);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return null;
        }
    }

    public Boolean isEntityInsideMaterial(World world, BlockPos pos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        try {
            return BlockChiseled.sharedIsEntityInsideMaterial(this.getTileEntity((IBlockAccess)world, pos), pos, entity, yToTest, materialIn, testingHead);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return null;
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!willHarvest && ChiselsAndBits.getConfig().addBrokenBlocksToCreativeClipboard) {
            try {
                TileEntityBlockChiseled tebc = this.getTileEntity((IBlockAccess)world, pos);
                CreativeClipboardTab.addItem(tebc.getItemStack(player));
                UndoTracker.getInstance().add(world, pos, tebc.getBlobStateReference(), new VoxelBlobStateReference(0, 0L));
            }
            catch (ExceptionNoTileEntity e) {
                Log.noTileError(e);
            }
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(world, pos);
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return this.isNormalCube(world, pos) ? 255 : 0;
    }

    public boolean isNormalCube(IBlockAccess world, BlockPos pos) {
        try {
            return this.getTileEntity(world, pos).isNormalCube();
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return false;
        }
    }

    public boolean func_176200_f(World worldIn, BlockPos pos) {
        try {
            return this.getTileEntity((IBlockAccess)worldIn, pos).getBlob().filled() == 0;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return super.func_176200_f(worldIn, pos);
        }
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        try {
            return this.getTileEntity(world, pos).isSideOpaque(face.func_176734_d());
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return false;
        }
    }

    public BlockChiseled(Material mat, String BlockName) {
        super((Material)new SubMaterial(mat));
        this.configureSound(mat);
        if (mat == Material.field_151588_w || mat == Material.field_151598_x) {
            this.field_149765_K = 0.98f;
        }
        this.func_149713_g(0);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.name = BlockName;
    }

    private void configureSound(Material mat) {
        if (mat == Material.field_151575_d) {
            this.func_149672_a(field_149766_f);
        } else if (mat == Material.field_151576_e) {
            this.func_149672_a(field_149769_e);
        } else if (mat == Material.field_151573_f) {
            this.func_149672_a(field_149777_j);
        } else if (mat == Material.field_151580_n) {
            this.func_149672_a(field_149777_j);
        } else if (mat == Material.field_151588_w) {
            this.func_149672_a(field_149778_k);
        } else if (mat == Material.field_151598_x) {
            this.func_149672_a(field_149778_k);
        } else if (mat == Material.field_151571_B) {
            this.func_149672_a(field_149767_g);
        } else if (mat == Material.field_151592_s) {
            this.func_149672_a(field_149778_k);
        }
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    public TileEntityBlockChiseled getTileEntity(TileEntity te) throws ExceptionNoTileEntity {
        if (te instanceof TileEntityBlockChiseled) {
            return (TileEntityBlockChiseled)te;
        }
        throw new ExceptionNoTileEntity();
    }

    public TileEntityBlockChiseled getTileEntity(IBlockAccess world, BlockPos pos) throws ExceptionNoTileEntity {
        return this.getTileEntity(world.func_175625_s(pos));
    }

    public float func_149685_I() {
        return 1.0f;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int tint) {
        Block blk = Block.func_176220_d((int)tint).func_177230_c();
        return blk.func_180662_a(worldIn, pos, 0);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        try {
            return this.getTileEntity(world, pos).getRenderState();
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return state;
        }
        catch (Throwable err) {
            Log.logError("Unable to get extended state...", err);
            return state;
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        try {
            BlockChiseled.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getTileEntity((IBlockAccess)worldIn, pos).getItemStack(null));
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        try {
            BlockChiseled.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getTileEntity(te).getItemStack(player));
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        try {
            return Collections.singletonList(this.getTileEntity(world, pos).getItemStack(null));
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return Collections.emptyList();
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        try {
            if (stack == null || placer == null || !stack.func_77942_o()) {
                return;
            }
            TileEntityBlockChiseled bc = this.getTileEntity((IBlockAccess)worldIn, pos);
            int rotations = ModUtil.getRotations(placer, ModUtil.getItemRotation(stack));
            VoxelBlob blob = bc.getBlob();
            while (rotations-- > 0) {
                blob = blob.spin(EnumFacing.Axis.Y);
            }
            bc.setBlob(blob);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        try {
            return this.getPickBlock(target, pos, this.getTileEntity((IBlockAccess)world, pos));
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return null;
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, BlockPos pos, TileEntityBlockChiseled te) {
        if (ClientSide.instance.getHeldToolType() != null) {
            VoxelBlob vb = te.getBlob();
            BitLocation bitLoc = new BitLocation(target, true, ChiselToolType.CHISEL);
            int itemBlock = vb.get(bitLoc.bitX, bitLoc.bitY, bitLoc.bitZ);
            if (itemBlock == 0) {
                return null;
            }
            return ItemChiseledBit.createStack(itemBlock, 1, false);
        }
        return te.getItemStack(ClientSide.instance.getPlayer());
    }

    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{UProperty_VoxelBlob, UProperty_Primary_BlockState, UProperty_VoxelNeighborState});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBlockChiseled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        try {
            TileEntityBlockChiseled tebc = this.getTileEntity((IBlockAccess)worldIn, pos);
            tebc.setNormalCube(false);
            worldIn.func_175664_x(pos);
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
        }
        finally {
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public boolean addLandingEffects(WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        try {
            IBlockState texture = this.getTileEntity((IBlockAccess)worldObj, blockPosition).getBlockState(Blocks.field_150348_b);
            worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)texture)});
            return true;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return false;
        }
    }

    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        try {
            IBlockState state = this.getTileEntity((IBlockAccess)world, pos).getBlockState(this);
            return ClientSide.instance.addBlockDestroyEffects(world, pos, state, effectRenderer);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return true;
        }
    }

    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        try {
            BlockPos pos = target.func_178782_a();
            IBlockState state = this.getTileEntity((IBlockAccess)world, pos).getBlockState(this);
            return ClientSide.instance.addHitEffects(world, target, state, effectRenderer);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return true;
        }
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        AxisAlignedBB r = null;
        try {
            for (AxisAlignedBB bb : this.getTileEntity((IBlockAccess)worldIn, pos).getBoxes(BoxType.COLLISION)) {
                if (r == null) {
                    r = bb;
                    continue;
                }
                r = r.func_111270_a(bb);
            }
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
        if (r == null) {
            return null;
        }
        return r.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        try {
            this.addCollisionBoxesToList(this.getTileEntity((IBlockAccess)worldIn, pos), pos, mask, list, collidingEntity);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
    }

    public void addCollisionBoxesToList(TileEntityBlockChiseled te, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB localMask = mask.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        for (AxisAlignedBB bb : te.getBoxes(BoxType.COLLISION)) {
            if (!bb.func_72326_a(localMask)) continue;
            list.add(bb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        }
    }

    private Block setBounds(TileEntityBlockChiseled tec, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list) {
        boolean started = false;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        Block b = this.getTestBlock();
        VoxelBlob vb = tec.getBlob();
        BitCollisionIterator bi = new BitCollisionIterator();
        while (bi.hasNext()) {
            if (bi.getNext(vb) != 0) {
                if (started) {
                    minX = Math.min(minX, bi.physicalX);
                    minY = Math.min(minY, bi.physicalY);
                    minZ = Math.min(minZ, bi.physicalZ);
                    maxX = Math.max(maxX, bi.physicalX + 0.0625f);
                    maxY = Math.max(maxY, bi.physicalYp1);
                    maxZ = Math.max(maxZ, bi.physicalZp1);
                } else {
                    started = true;
                    minX = bi.physicalX;
                    minY = bi.physicalY;
                    minZ = bi.physicalZ;
                    maxX = bi.physicalX + 0.0625f;
                    maxY = bi.physicalYp1;
                    maxZ = bi.physicalZp1;
                }
            }
            if (list == null || !started || bi.y != 8 && bi.y != 15) continue;
            AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)((double)minX + (double)pos.func_177958_n()), (double)((double)minY + (double)pos.func_177956_o()), (double)((double)minZ + (double)pos.func_177952_p()), (double)((double)maxX + (double)pos.func_177958_n()), (double)((double)maxY + (double)pos.func_177956_o()), (double)((double)maxZ + (double)pos.func_177952_p()));
            if (mask.func_72326_a(bb)) {
                list.add(bb);
            }
            started = false;
            minX = 0.0f;
            minY = 0.0f;
            minZ = 0.0f;
            maxX = 1.0f;
            maxY = 1.0f;
            maxZ = 1.0f;
        }
        b.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        return b;
    }

    private Block getTestBlock() {
        Block b = this.testBlock.get();
        if (b == null) {
            b = new Block(Material.field_151576_e);
            this.testBlock.set(b);
        }
        return b;
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        try {
            return this.getSelectedBoundingBox(this.getTileEntity((IBlockAccess)worldIn, pos), pos);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return super.func_180646_a(worldIn, pos);
        }
    }

    public AxisAlignedBB getSelectedBoundingBox(TileEntityBlockChiseled tec, BlockPos pos) {
        return this.getBoundingBox(this.setBounds(tec, pos, null, null), pos);
    }

    private AxisAlignedBB getBoundingBox(Block target, BlockPos pos) {
        return new AxisAlignedBB((double)pos.func_177958_n() + target.func_149704_x(), (double)pos.func_177956_o() + target.func_149665_z(), (double)pos.func_177952_p() + target.func_149706_B(), (double)pos.func_177958_n() + target.func_149753_y(), (double)pos.func_177956_o() + target.func_149669_A(), (double)pos.func_177952_p() + target.func_149693_C());
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 a, Vec3 b) {
        try {
            return this.collisionRayTrace(this.getTileEntity((IBlockAccess)worldIn, pos), pos, a, b, worldIn.field_72995_K);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return super.func_180636_a(worldIn, pos, a, b);
        }
    }

    public MovingObjectPosition collisionRayTrace(TileEntityBlockChiseled tec, BlockPos pos, Vec3 a, Vec3 b, boolean realTest) {
        Block boundsToTest = this.getTestBlock();
        MovingObjectPosition br = null;
        double lastDist = 0.0;
        boolean occlusion = true;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && tec.func_145831_w() != null && tec.func_145831_w().field_72995_K) {
            occlusion = !ChiselsAndBits.getConfig().fluidBitsAreClickThough || ClientSide.instance.getHeldToolType() != null;
        }
        for (AxisAlignedBB box : tec.getBoxes(occlusion ? BoxType.OCCLUSION : BoxType.COLLISION)) {
            boundsToTest.func_149676_a((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72337_e, (float)box.field_72334_f);
            MovingObjectPosition r = boundsToTest.func_180636_a(null, pos, a, b);
            if (r == null) continue;
            double xLen = a.field_72450_a - r.field_72307_f.field_72450_a;
            double yLen = a.field_72448_b - r.field_72307_f.field_72448_b;
            double zLen = a.field_72449_c - r.field_72307_f.field_72449_c;
            double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
            if (br != null && (!(lastDist > thisDist) || r == null)) continue;
            lastDist = thisDist;
            br = r;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return br;
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        try {
            return this.getTileEntity((IBlockAccess)worldIn, (BlockPos)pos).getBlockInfo((Block)this).hardness;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return super.func_176195_g(worldIn, pos);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        try {
            return this.getTileEntity((IBlockAccess)world, (BlockPos)pos).getBlockInfo((Block)this).explosionResistance;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return super.getExplosionResistance(world, pos, exploder, explosion);
        }
    }

    public static boolean replaceWithChisled(World world, BlockPos pos, IBlockState originalState, boolean triggerUpdate) {
        return BlockChiseled.replaceWithChisled(world, pos, originalState, 0, triggerUpdate);
    }

    public boolean canPlaceTorchOnTop(IBlockAccess world, BlockPos pos) {
        return this.isSideSolid(world, pos, EnumFacing.UP);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        try {
            return this.getTileEntity(world, pos).isSideSolid(side);
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return false;
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        try {
            this.getTileEntity((IBlockAccess)world, pos).rotateBlock(axis);
            return true;
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
            return false;
        }
    }

    public static boolean replaceWithChisled(World world, BlockPos pos, IBlockState originalState, int fragmentBlockStateID, boolean triggerUpdate) {
        IBlockState actingState = originalState;
        Block target = originalState.func_177230_c();
        boolean isAir = world.func_175623_d(pos);
        if (BlockBitInfo.supportsBlock(actingState) || isAir) {
            BlockChiseled blk = ChiselsAndBits.getBlocks().getConversion(target);
            int BlockID = Block.func_176210_f((IBlockState)actingState);
            if (isAir) {
                actingState = Block.func_176220_d((int)fragmentBlockStateID);
                target = actingState.func_177230_c();
                BlockID = Block.func_176210_f((IBlockState)actingState);
                blk = ChiselsAndBits.getBlocks().getConversion(target);
                actingState = Blocks.field_150350_a.func_176223_P();
            }
            if (BlockID == 0) {
                return false;
            }
            if (blk != null && blk != target) {
                TileEntityBlockChiseled tec;
                world.func_180501_a(pos, blk.func_176223_P(), triggerUpdate ? 3 : 0);
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof TileEntityBlockChiseled)) {
                    tec = (TileEntityBlockChiseled)blk.createTileEntity(world, blk.func_176223_P());
                    world.func_175690_a(pos, (TileEntity)tec);
                } else {
                    tec = (TileEntityBlockChiseled)te;
                }
                tec.fillWith(actingState);
                tec.setState(tec.getBasicState().withProperty(UProperty_Primary_BlockState, (Object)BlockID));
                return true;
            }
        }
        return false;
    }

    public IBlockState getCommonState(IExtendedBlockState myState) {
        VoxelBlob vb;
        VoxelBlobStateReference data = (VoxelBlobStateReference)myState.getValue(UProperty_VoxelBlob);
        if (data != null && (vb = data.getVoxelBlob()) != null) {
            return Block.func_176220_d((int)vb.getVoxelStats().mostCommonState);
        }
        return null;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != this) {
            return block.getLightValue(world, pos);
        }
        if (ChiselsAndBits.getConfig().enableBitLightSource) {
            try {
                return this.getTileEntity(world, pos).getLightValue();
            }
            catch (ExceptionNoTileEntity e) {
                Log.noTileError(e);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        try {
            this.testingHarvest.set(true);
            boolean bl = super.canHarvestBlock(world, pos, player);
            return bl;
        }
        finally {
            this.testingHarvest.remove();
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (ChiselsAndBits.getConfig().enableToolHarvestLevels) {
            try {
                if (state instanceof IExtendedBlockState && worldIn instanceof World) {
                    String cname;
                    Exception e;
                    StackTraceElement[] elements;
                    Boolean isTesting = this.testingHarvest.get();
                    if (isTesting == null && (elements = (e = new Exception()).getStackTrace()) != null && elements.length > 2 && (cname = elements[1].getClassName()).contains("minecraftforge")) {
                        isTesting = true;
                    }
                    if (isTesting != null) {
                        TileEntityBlockChiseled tebc = this.getTileEntity(worldIn, pos);
                        return tebc.getBasicState();
                    }
                }
            }
            catch (ExceptionNoTileEntity e) {
                Log.noTileError(e);
            }
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public static void setActingAs(IBlockState state) {
        actingAs.set(state);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState blockRef;
        IBlockState actingAsState = actingAs.get();
        if (actingAsState != null && actingAsState.func_177230_c() != this) {
            return actingAsState.func_177230_c().getHarvestTool(actingAsState);
        }
        if (ChiselsAndBits.getConfig().enableToolHarvestLevels && state instanceof IExtendedBlockState && (blockRef = this.getCommonState((IExtendedBlockState)state)) != null) {
            String tool = blockRef.func_177230_c().getHarvestTool(blockRef);
            if (tool == null) {
                tool = "pickaxe";
            }
            return tool;
        }
        return super.getHarvestTool(state);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState blockRef;
        IBlockState actingAsState = actingAs.get();
        if (actingAsState != null && actingAsState.func_177230_c() != this) {
            return actingAsState.func_177230_c().getHarvestLevel(actingAsState);
        }
        if (ChiselsAndBits.getConfig().enableToolHarvestLevels && state instanceof IExtendedBlockState && (blockRef = this.getCommonState((IExtendedBlockState)state)) != null) {
            return blockRef.func_177230_c().getHarvestLevel(blockRef);
        }
        return super.getHarvestLevel(state);
    }

    public String getModel() {
        return "chiselsandbits:" + this.name;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    }

    public static Boolean sharedIsAABBInsideMaterial(TileEntityBlockChiseled tebc, AxisAlignedBB bx, Material materialIn) {
        if (materialIn == Material.field_151586_h) {
            for (AxisAlignedBB b : tebc.getBoxes(BoxType.SWIMMING)) {
                if (!b.func_72326_a(bx)) continue;
                return true;
            }
        }
        return false;
    }

    public static Boolean sharedIsEntityInsideMaterial(TileEntityBlockChiseled tebc, BlockPos pos, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        block5: {
            block4: {
                if (!testingHead || materialIn != Material.field_151586_h) break block4;
                Vec3 head = entity.func_174791_d();
                head = new Vec3(head.field_72450_a - (double)pos.func_177958_n(), yToTest - (double)pos.func_177956_o(), head.field_72449_c - (double)pos.func_177952_p());
                for (AxisAlignedBB b : tebc.getBoxes(BoxType.SWIMMING)) {
                    if (!b.func_72318_a(head)) continue;
                    return true;
                }
                break block5;
            }
            if (testingHead || materialIn != Material.field_151586_h) break block5;
            AxisAlignedBB what = entity.func_70046_E();
            if (what == null) {
                what = entity.func_174813_aQ();
            }
            if (what != null) {
                what = what.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                for (AxisAlignedBB b : tebc.getBoxes(BoxType.SWIMMING)) {
                    if (!b.func_72326_a(what)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

