/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelNeighborRenderTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.render.chiseledblock.tesr.TileRenderCache;
import mod.chiselsandbits.render.chiseledblock.tesr.TileRenderChunk;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;

public class TileEntityBlockChiseledTESR
extends TileEntityBlockChiseled {
    private TileRenderChunk renderChunk;
    private TileRenderCache singleCache;

    public boolean canRenderBreaking() {
        return true;
    }

    public TileRenderChunk getRenderChunk() {
        return this.renderChunk;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    protected void tesrUpdate(VoxelNeighborRenderTracker vns) {
        if (this.renderChunk == null) {
            this.renderChunk = this.findRenderChunk();
            this.renderChunk.register(this);
        }
        this.renderChunk.update(null, 1);
        if (vns.isShouldUpdate()) {
            this.renderChunk.rebuild(false);
        }
    }

    private TileRenderChunk findRenderChunk() {
        int chunkPosX = this.func_174877_v().func_177958_n();
        int chunkPosY = this.func_174877_v().func_177956_o();
        int chunkPosZ = this.func_174877_v().func_177952_p();
        int mask = -16;
        chunkPosX &= 0xFFFFFFF0;
        chunkPosY &= 0xFFFFFFF0;
        chunkPosZ &= 0xFFFFFFF0;
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    TileRenderChunk trc;
                    TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(this.field_145850_b, new BlockPos(chunkPosX + x, chunkPosY + y, chunkPosZ + z), false);
                    if (!(te instanceof TileEntityBlockChiseledTESR) || (trc = ((TileEntityBlockChiseledTESR)te).renderChunk) == null) continue;
                    return trc;
                }
            }
        }
        return new TileRenderChunk();
    }

    public TileRenderCache getCache() {
        final TileEntityBlockChiseledTESR self = this;
        if (this.singleCache == null) {
            this.singleCache = new TileRenderCache(){

                @Override
                public List<TileEntityBlockChiseledTESR> getTiles() {
                    return Collections.singletonList(self);
                }
            };
        }
        return this.singleCache;
    }

    public void func_145843_s() {
        if (this.renderChunk != null) {
            this.renderChunk.unregister(this);
        }
    }

    public IExtendedBlockState getTileRenderState() {
        return this.getState(true, 0);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.getRenderChunk() != null) {
            return this.getRenderChunk().getBounds();
        }
        BlockPos p = this.func_174877_v();
        return new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 1), (double)(p.func_177956_o() + 1), (double)(p.func_177952_p() + 1));
    }

    @Override
    public boolean isSideOpaque(EnumFacing side) {
        return false;
    }

    public double func_145833_n() {
        return ChiselsAndBits.getConfig().dynamicModelRange * ChiselsAndBits.getConfig().dynamicModelRange;
    }

    @Override
    public void completeEditOperation(VoxelBlob vb) {
        super.completeEditOperation(vb);
        if (this.renderChunk != null) {
            if (this.renderChunk.singleInstanceMode) {
                this.getCache().rebuild(true);
            } else {
                this.renderChunk.rebuild(true);
            }
        }
    }
}

