/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.IContinuousInventory;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChisel;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

public class ContinousChisels
implements IContinuousInventory {
    private final ActingPlayer who;
    private final List<ModUtil.ItemStackSlot> options = new ArrayList<ModUtil.ItemStackSlot>();
    private final HashMap<Integer, List<ModUtil.ItemStackSlot>> actionCache = new HashMap();
    private final boolean canEdit;

    public ContinousChisels(ActingPlayer who, BlockPos pos, EnumFacing side) {
        this.who = who;
        ItemStack inHand = who.getCurrentEquippedItem();
        IInventory inv = who.getInventory();
        this.canEdit = who.canPlayerManipulate(pos, side, new ItemStack((Item)ChiselsAndBits.getItems().itemChiselDiamond, 1));
        if (inHand != null && inHand.field_77994_a > 0 && inHand.func_77973_b() instanceof ItemChisel) {
            if (who.canPlayerManipulate(pos, side, inHand)) {
                this.options.add(new ModUtil.ItemStackSlot(inv, who.getCurrentItem(), inHand, who, this.canEdit));
            }
        } else {
            ArrayListMultimap discovered = ArrayListMultimap.create();
            for (int x = 0; x < inv.func_70302_i_(); ++x) {
                ItemStack is = inv.func_70301_a(x);
                if (is == inHand || !who.canPlayerManipulate(pos, side, is) || is == null || is.field_77994_a <= 0 || !(is.func_77973_b() instanceof ItemChisel)) continue;
                Item.ToolMaterial newMat = ((ItemChisel)is.func_77973_b()).whatMaterial();
                discovered.put((Object)newMat.func_77996_d(), (Object)new ModUtil.ItemStackSlot(inv, x, is, who, this.canEdit));
            }
            ArrayList allValues = Lists.newArrayList((Iterable)discovered.values());
            for (ModUtil.ItemStackSlot f : Lists.reverse((List)allValues)) {
                this.options.add(f);
            }
        }
    }

    @Override
    public ModUtil.ItemStackSlot getItem(int BlockID) {
        List<ModUtil.ItemStackSlot> choices;
        if (!this.actionCache.containsKey(BlockID)) {
            this.actionCache.put(BlockID, new ArrayList<ModUtil.ItemStackSlot>(this.options));
        }
        if ((choices = this.actionCache.get(BlockID)).isEmpty()) {
            return new ModUtil.ItemStackSlot(null, -1, null, this.who, this.canEdit);
        }
        ModUtil.ItemStackSlot slot = choices.get(choices.size() - 1);
        if (slot.isValid()) {
            return slot;
        }
        this.fail(BlockID);
        return this.getItem(BlockID);
    }

    @Override
    public void fail(int BlockID) {
        List<ModUtil.ItemStackSlot> choices = this.actionCache.get(BlockID);
        if (!choices.isEmpty()) {
            choices.remove(choices.size() - 1);
        }
    }

    @Override
    public boolean isValid() {
        return !this.options.isEmpty() || this.who.isCreative();
    }

    @Override
    public void useItem(int blk) {
        this.getItem(blk).damage(this.who);
    }
}

