/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import com.google.common.base.Stopwatch;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselMode;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.ChiselModeManager;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.IContinuousInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketChisel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class ItemChisel
extends ItemTool
implements IItemScrollWheel,
IChiselModeItem {
    private static final float one_16th = 0.0625f;
    private static Stopwatch timer;
    private static boolean testingChisel;
    private static final String DAMAGE_KEY = "damage";

    public ItemChisel(Item.ToolMaterial material) {
        super(0.1f, material, new HashSet());
        long uses = 1L;
        switch (material) {
            case EMERALD: {
                uses = ChiselsAndBits.getConfig().diamondChiselUses;
                break;
            }
            case GOLD: {
                uses = ChiselsAndBits.getConfig().goldChiselUses;
                break;
            }
            case IRON: {
                uses = ChiselsAndBits.getConfig().ironChiselUses;
                break;
            }
            case STONE: {
                uses = ChiselsAndBits.getConfig().stoneChiselUses;
                break;
            }
        }
        this.func_77656_e(ChiselsAndBits.getConfig().damageTools ? (int)Math.max(0L, uses) : 0);
    }

    public Item.ToolMaterial whatMaterial() {
        return this.field_77862_b;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpChisel, tooltip, ClientSide.instance.getModeKey());
    }

    public static void resetDelay() {
        timer = null;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return ItemChisel.fromBreakToChisel(ChiselModeManager.getChiselMode(player, ChiselToolType.CHISEL), itemstack, pos, player);
    }

    public static boolean fromBreakToChisel(ChiselMode mode, ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (itemstack != null && (timer == null || timer.elapsed(TimeUnit.MILLISECONDS) > 100L)) {
            timer = Stopwatch.createStarted();
            if (mode == ChiselMode.DRAWN_REGION) {
                Pair<Vec3, Vec3> PlayerRay = ModUtil.getPlayerRay(player);
                Vec3 ray_from = (Vec3)PlayerRay.getLeft();
                Vec3 ray_to = (Vec3)PlayerRay.getRight();
                MovingObjectPosition mop = player.field_70170_p.func_180495_p(pos).func_177230_c().func_180636_a(player.field_70170_p, pos, ray_from, ray_to);
                if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    BitLocation loc = new BitLocation(mop, true, ChiselToolType.CHISEL);
                    ClientSide.instance.pointAt(ChiselToolType.CHISEL, loc);
                    return true;
                }
                return true;
            }
            if (!player.field_70170_p.field_72995_K) {
                return true;
            }
            Pair<Vec3, Vec3> PlayerRay = ModUtil.getPlayerRay(player);
            Vec3 ray_from = (Vec3)PlayerRay.getLeft();
            Vec3 ray_to = (Vec3)PlayerRay.getRight();
            MovingObjectPosition mop = player.field_70170_p.func_180495_p(pos).func_177230_c().func_180636_a(player.field_70170_p, pos, ray_from, ray_to);
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                ItemChisel.useChisel(mode, player, player.field_70170_p, pos, mop.field_178784_b, (float)(mop.field_72307_f.field_72450_a - (double)pos.func_177958_n()), (float)(mop.field_72307_f.field_72448_b - (double)pos.func_177956_o()), (float)(mop.field_72307_f.field_72449_c - (double)pos.func_177952_p()));
            }
        }
        return true;
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        if (ChiselsAndBits.getConfig().itemNameModeDisplay) {
            if (ChiselsAndBits.getConfig().perChiselMode || FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                return displayName + " - " + ChiselMode.getMode((ItemStack)item).string.getLocal();
            }
            return displayName + " - " + ChiselModeManager.getChiselMode((EntityPlayer)ClientSide.instance.getPlayer(), (ChiselToolType)ChiselToolType.CHISEL).string.getLocal();
        }
        return displayName;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K && ChiselsAndBits.getConfig().enableRightClickModeChange) {
            ChiselMode mode = ChiselModeManager.getChiselMode(playerIn, ChiselToolType.CHISEL);
            ChiselModeManager.scrollOption(ChiselToolType.CHISEL, mode, mode, playerIn.func_70093_af() ? -1 : 1);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && ChiselsAndBits.getConfig().enableRightClickModeChange) {
            this.func_77659_a(stack, world, player);
            return true;
        }
        return false;
    }

    static void useChisel(ChiselMode mode, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        BitLocation location = new BitLocation(new MovingObjectPosition(MovingObjectPosition.MovingObjectType.BLOCK, new Vec3((double)hitX, (double)hitY, (double)hitZ), side, pos), false, ChiselToolType.CHISEL);
        PacketChisel pc = new PacketChisel(false, location, side, mode);
        int extractedState = pc.doAction(player);
        if (extractedState != 0) {
            ClientSide.breakSound(world, pos, extractedState);
            NetworkRouter.instance.sendToServer(pc);
        }
    }

    public static ItemStack chiselBlock(IContinuousInventory selected, ActingPlayer player, VoxelBlob vb, World world, BlockPos pos, EnumFacing side, int x, int y, int z, ItemStack output, List<EntityItem> spawnlist) {
        boolean spawnBit;
        boolean isCreative = player.isCreative();
        int blk = vb.get(x, y, z);
        if (blk == 0) {
            return output;
        }
        if (!ItemChisel.canMine(selected, Block.func_176220_d((int)blk), player.getPlayer(), world, pos)) {
            return output;
        }
        selected.useItem(blk);
        boolean bl = spawnBit = ChiselsAndBits.getItems().itemBlockBit != null;
        if (!world.field_72995_K && !isCreative) {
            double hitX = (float)x * 0.0625f;
            double hitY = (float)y * 0.0625f;
            double hitZ = (float)z * 0.0625f;
            double offset = 0.5;
            hitX += (double)side.func_82601_c() * 0.5;
            hitY += (double)side.func_96559_d() * 0.5;
            hitZ += (double)side.func_82599_e() * 0.5;
            if (output == null || !ItemChiseledBit.sameBit(output, blk) || output.field_77994_a == 64) {
                output = ItemChiseledBit.createStack(blk, 1, true);
                if (spawnBit) {
                    spawnlist.add(new EntityItem(world, (double)pos.func_177958_n() + hitX, (double)pos.func_177956_o() + hitY, (double)pos.func_177952_p() + hitZ, output));
                }
            } else {
                ++output.field_77994_a;
            }
        } else {
            output = ItemChiseledBit.createStack(blk, 1, true);
        }
        vb.clear(x, y, z);
        return output;
    }

    public static boolean canMine(IContinuousInventory chiselInv, IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        int targetState = Block.func_176210_f((IBlockState)state);
        ModUtil.ItemStackSlot chiselSlot = chiselInv.getItem(targetState);
        ItemStack chisel = chiselSlot.getStack();
        if (player.field_71075_bZ.field_75098_d) {
            return world.func_175660_a(player, pos);
        }
        if (chisel == null) {
            return false;
        }
        if (ChiselsAndBits.getConfig().enableChiselToolHarvestCheck) {
            if (state.func_177230_c() instanceof BlockChiseled) {
                return true;
            }
            do {
                Block blk = world.func_180495_p(pos).func_177230_c();
                BlockChiseled.setActingAs(state);
                testingChisel = true;
                chiselSlot.swapWithWeapon();
                boolean canHarvest = blk.canHarvestBlock((IBlockAccess)world, pos, player);
                chiselSlot.swapWithWeapon();
                testingChisel = false;
                BlockChiseled.setActingAs(null);
                if (canHarvest) {
                    return true;
                }
                chiselInv.fail(targetState);
            } while ((chisel = (chiselSlot = chiselInv.getItem(targetState)).getStack()) != null);
            return false;
        }
        return true;
    }

    public int getDamage(ItemStack stack) {
        return Math.max(this.getMetadata(stack), this.getNBT(stack).func_74762_e(DAMAGE_KEY));
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage < 0) {
            damage = 0;
        }
        this.getNBT(stack).func_74768_a(DAMAGE_KEY, damage);
    }

    private NBTTagCompound getNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public boolean func_150897_b(Block blk) {
        Item it;
        switch (this.func_150913_i()) {
            case EMERALD: {
                it = Items.field_151046_w;
                break;
            }
            case GOLD: {
                it = Items.field_151005_D;
                break;
            }
            case IRON: {
                it = Items.field_151035_b;
                break;
            }
            default: {
                it = Items.field_151050_s;
                break;
            }
            case WOOD: {
                it = Items.field_151039_o;
            }
        }
        return blk instanceof BlockChiseled || it.func_150897_b(blk);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        String pattern;
        Pattern p;
        Matcher m;
        if (testingChisel && stack.func_77973_b() instanceof ItemChisel && (m = (p = Pattern.compile(pattern = "(^|,)" + Pattern.quote(toolClass) + "(,|$)")).matcher(ChiselsAndBits.getConfig().enableChiselToolHarvestCheckTools)).find()) {
            ItemChisel ic = (ItemChisel)stack.func_77973_b();
            return ic.field_77862_b.func_77996_d();
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    @Override
    public void scroll(EntityPlayer player, ItemStack stack, int dwheel) {
        ChiselMode mode = ChiselModeManager.getChiselMode(player, ChiselToolType.CHISEL);
        ChiselModeManager.scrollOption(ChiselToolType.CHISEL, mode, mode, dwheel);
    }

    static {
        testingChisel = false;
    }
}

