/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mod.chiselsandbits.bittank.BlockBitTank;
import mod.chiselsandbits.bittank.ItemBlockBitTank;
import mod.chiselsandbits.bittank.TileEntityBitTank;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.MaterialType;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.config.ModConfig;
import mod.chiselsandbits.registry.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class ModBlocks
extends ModRegistry {
    private static String TE_BIT_TANK = "mod.chiselsandbits.TileEntityBitTank";
    private static String TE_CHISELEDBLOCK = "mod.chiselsandbits.TileEntityChiseled";
    private static String TE_CHISELEDBLOCK_TESR = "mod.chiselsandbits.TileEntityChiseled.tesr";
    private final HashMap<Material, BlockChiseled> conversions = new HashMap();
    public final BlockBitTank blockBitTank;
    public static final MaterialType[] validMaterials = new MaterialType[]{new MaterialType("wood", Material.field_151575_d), new MaterialType("rock", Material.field_151576_e), new MaterialType("iron", Material.field_151573_f), new MaterialType("cloth", Material.field_151580_n), new MaterialType("ice", Material.field_151588_w), new MaterialType("packedIce", Material.field_151598_x), new MaterialType("clay", Material.field_151571_B), new MaterialType("glass", Material.field_151592_s), new MaterialType("sand", Material.field_151595_p), new MaterialType("ground", Material.field_151578_c), new MaterialType("grass", Material.field_151577_b), new MaterialType("snow", Material.field_151596_z), new MaterialType("fluid", Material.field_151586_h), new MaterialType("leaves", Material.field_151584_j)};

    public ModBlocks(ModConfig config, Side side) {
        GameRegistry.registerTileEntity(TileEntityBlockChiseled.class, (String)TE_CHISELEDBLOCK);
        if (side == Side.CLIENT) {
            GameRegistry.registerTileEntity(TileEntityBlockChiseledTESR.class, (String)TE_CHISELEDBLOCK_TESR);
        } else {
            GameRegistry.registerTileEntity(TileEntityBlockChiseled.class, (String)TE_CHISELEDBLOCK_TESR);
        }
        if (config.enableBitTank) {
            this.blockBitTank = new BlockBitTank();
            this.registerBlock(this.blockBitTank, ItemBlockBitTank.class, "bittank");
            GameRegistry.registerTileEntity(TileEntityBitTank.class, (String)TE_BIT_TANK);
        } else {
            this.blockBitTank = null;
        }
        for (MaterialType mat : validMaterials) {
            BlockChiseled blk = new BlockChiseled(mat.type, "chiseled_" + mat.name);
            this.getConversions().put(mat.type, blk);
            this.registerBlock(blk, ItemBlockChiseled.class, blk.name);
        }
    }

    public void addRecipes() {
        this.ShapedOreRecipe(this.blockBitTank, " G ", "GOG", " I ", Character.valueOf('G'), "blockGlass", Character.valueOf('O'), "logWood", Character.valueOf('I'), "ingotIron");
    }

    public IBlockState getChiseledDefaultState() {
        Iterator<BlockChiseled> iterator = this.getConversions().values().iterator();
        if (iterator.hasNext()) {
            BlockChiseled bc = iterator.next();
            return bc.func_176223_P();
        }
        return null;
    }

    public BlockChiseled getConversion(Block material) {
        Fluid f = BlockBitInfo.getFluidFromBlock(material);
        if (f != null) {
            return this.getConversions().get(Material.field_151586_h);
        }
        return this.getConversions().get(material.func_149688_o());
    }

    public BlockChiseled getConversionWithDefault(Block material) {
        Iterator<BlockChiseled> iterator;
        BlockChiseled bcX = this.getConversion(material);
        if (bcX == null && (iterator = this.getConversions().values().iterator()).hasNext()) {
            BlockChiseled bc = iterator.next();
            return bc;
        }
        return bcX;
    }

    public Map<Material, BlockChiseled> getConversions() {
        return this.conversions;
    }
}

