/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.cache;

import java.lang.ref.WeakReference;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.render.cache.CacheMap;

public class InMemoryQuadCompressor
implements Runnable {
    protected static final float EPSILON = 1.0E-4f;
    private static CacheMap<float[][], WeakReference<float[][]>> cachelvl2 = new CacheMap(new CacheMap.EqTest(){

        @Override
        public boolean doTest(Object a, Object b) {
            float[][] aa = (float[][])a;
            float[][] bb = (float[][])b;
            if (aa.length != bb.length) {
                return false;
            }
            for (int x = 0; x < aa.length; ++x) {
                if (aa[x] == bb[x]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getHash(Object referent) {
            float[][] a = (float[][])referent;
            int out = 0;
            for (int x = 0; x < a.length; ++x) {
                out ^= System.identityHashCode(a[x]) << x;
            }
            return out;
        }
    });
    private static CacheMap<float[], WeakReference<float[]>> cache = new CacheMap(new CacheMap.EqTest(){

        @Override
        public boolean doTest(Object a, Object b) {
            float[] aa = (float[])a;
            float[] bb = (float[])b;
            if (aa.length != bb.length) {
                return false;
            }
            for (int x = 0; x < aa.length; ++x) {
                if (!(Math.abs(aa[x] - bb[x]) > 1.0E-4f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getHash(Object referent) {
            float[] a = (float[])referent;
            int out = 0;
            for (int x = 0; x < a.length; ++x) {
                out ^= (int)(a[x] * 100.0f) << x;
            }
            return out;
        }
    });
    BlockingQueue<WeakReference<float[][][]>> submissions = new LinkedBlockingQueue<WeakReference<float[][][]>>();
    float[] junk;

    private float[] combineLevel1(float[] fs) {
        float[] f;
        WeakReference<float[]> o = cache.get(fs);
        if (o != null && (f = (float[])o.get()) != null) {
            return f;
        }
        cache.put(fs, new WeakReference<float[]>(fs));
        return fs;
    }

    private float[][] combineLevel2(float[][] fs) {
        float[][] f;
        WeakReference<float[][]> o = cachelvl2.get(fs);
        if (o != null && (f = (float[][])o.get()) != null) {
            return f;
        }
        cachelvl2.put(fs, new WeakReference<float[][]>(fs));
        return fs;
    }

    public InMemoryQuadCompressor() {
        Thread t = new Thread(this);
        t.setName("C&B In Memory Compression");
        t.setPriority(1);
        t.start();
    }

    public float[][][] compress(float[][][] unpackedData) {
        try {
            this.submissions.put(new WeakReference<float[][][]>(unpackedData));
        }
        catch (InterruptedException e) {
            Log.logError("Error in compresssor", e);
        }
        return unpackedData;
    }

    @Override
    public void run() {
        while (true) {
            try {
                WeakReference<float[][][]> l;
                while ((l = this.submissions.take()) != null) {
                    float[][][] active = (float[][][])l.get();
                    if (active == null) continue;
                    for (int x = 0; x < active.length; ++x) {
                        for (int y = 0; y < active[x].length; ++y) {
                            active[x][y] = this.combineLevel1(active[x][y]);
                        }
                        active[x] = this.combineLevel2(active[x]);
                    }
                }
            }
            catch (InterruptedException e) {
                Log.logError("Error in compresssor", e);
                continue;
            }
            break;
        }
    }
}

