/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.field;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.common.field.IField;

public class CheckBox
implements IField<CheckBox> {
    private final String fieldName;
    private final boolean defaultChecked;
    private boolean checked;

    public CheckBox(@Nonnull String fieldName) {
        this(fieldName, false);
    }

    public CheckBox(@Nonnull String fieldName, boolean defaultChecked) {
        this.fieldName = fieldName;
        this.defaultChecked = this.checked = defaultChecked;
    }

    public final CheckBox toggle() {
        this.checked ^= true;
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    @Nonnull
    public CheckBox copy() {
        return new CheckBox(this.fieldName, this.checked);
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound fieldNBT = new NBTTagCompound();
        fieldNBT.func_74778_a("fieldName", this.fieldName);
        fieldNBT.func_74757_a("checked", this.checked);
        return fieldNBT;
    }

    @Override
    public void receiveNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.readNBT(nbtTagCompound);
    }

    @Override
    public String getHoveringText(@Nonnull WInteraction wInteraction) {
        return I18n.func_135052_a((String)this.fieldName, (Object[])new Object[0]);
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound smartNBT) {
        this.checked = smartNBT.func_74764_b("checked") ? smartNBT.func_74767_n("checked") : this.defaultChecked;
    }

    @Override
    @Nonnull
    public String getFieldName() {
        return this.fieldName;
    }

    public boolean equals(Object obj) {
        return obj instanceof CheckBox && this.fieldName.equals(((CheckBox)obj).fieldName) && this.checked == ((CheckBox)obj).checked;
    }
}

