/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.defaults;

import com.possibletriangle.skygrid.Skygrid;
import com.possibletriangle.skygrid.defaults.DefaultsAetherI;
import com.possibletriangle.skygrid.defaults.DefaultsCave;
import com.possibletriangle.skygrid.defaults.DefaultsEnd;
import com.possibletriangle.skygrid.defaults.DefaultsErebus;
import com.possibletriangle.skygrid.defaults.DefaultsLimbo;
import com.possibletriangle.skygrid.defaults.DefaultsNether;
import com.possibletriangle.skygrid.defaults.DefaultsOcean;
import com.possibletriangle.skygrid.defaults.DefaultsOverworld;
import com.possibletriangle.skygrid.defaults.DefaultsTeletory;
import com.possibletriangle.skygrid.defaults.DefaultsTropics;
import com.possibletriangle.skygrid.defaults.DefaultsTwilight;
import com.possibletriangle.skygrid.generation.WorldProviderSkygrid;
import com.possibletriangle.skygrid.generation.WorldProviderSkygridOverwritten;
import com.possibletriangle.skygrid.random.BlockInfo;
import com.possibletriangle.skygrid.random.RandomCollection;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber
public abstract class Defaults
implements IForgeRegistryEntry<Defaults> {
    private ResourceLocation name;

    public Class<? extends WorldProvider> providerClass(boolean overwriting) {
        return overwriting ? WorldProviderSkygridOverwritten.class : WorldProviderSkygrid.class;
    }

    public int getHeight() {
        return Math.min(150, Skygrid.WORLD_HEIGHT);
    }

    public boolean onlyOverwrite() {
        return true;
    }

    public IBlockState getFillState(int floor) {
        return Blocks.field_150350_a.func_176223_P();
    }

    public int getOffset(EnumFacing.Axis axis) {
        return 4;
    }

    public final BlockPos getOffset() {
        return new BlockPos(this.getOffset(EnumFacing.Axis.X), this.getOffset(EnumFacing.Axis.Y), this.getOffset(EnumFacing.Axis.Z));
    }

    @SubscribeEvent
    public static void registerAll(RegistryEvent.Register<Defaults> event) {
        Skygrid.LOGGER.info("Registering Defaults");
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsLimbo().setRegistryName(new ResourceLocation("skygrid", "limbo")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsCave().setRegistryName(new ResourceLocation("skygrid", "cave")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsOcean().setRegistryName(new ResourceLocation("skygrid", "ocean")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsOverworld().setRegistryName(new ResourceLocation("overworld")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsNether().setRegistryName(new ResourceLocation("the_nether")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsEnd().setRegistryName(new ResourceLocation("the_end")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsAetherI().setRegistryName(new ResourceLocation("AetherI")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsErebus().setRegistryName(new ResourceLocation("EREBUS")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsTeletory().setRegistryName(new ResourceLocation("teletory")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsTwilight().setRegistryName(new ResourceLocation("twilight_forest")));
        event.getRegistry().register((IForgeRegistryEntry)new DefaultsTropics().setRegistryName(new ResourceLocation("Tropics")));
    }

    @SubscribeEvent
    public static void registerRegistries(RegistryEvent.NewRegistry event) {
        RegistryBuilder builder = new RegistryBuilder();
        builder.setType(Defaults.class);
        ResourceLocation key = new ResourceLocation("skygrid", "defaults");
        builder.setName(key);
        builder.setDefaultKey(key);
        builder.create();
    }

    public abstract void registerBlocks(RandomCollection<BlockInfo> var1, int var2);

    public abstract void registerLoot(RandomCollection<ResourceLocation> var1);

    public abstract void registerMobs(RandomCollection<ResourceLocation> var1);

    public Defaults setRegistryName(ResourceLocation name) {
        this.name = new ResourceLocation("minecraft", name.func_110623_a());
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<Defaults> getRegistryType() {
        return Defaults.class;
    }

    public int[] floors() {
        return new int[]{0};
    }
}

