/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.generation;

import com.possibletriangle.skygrid.defaults.DefaultsEnd;
import com.possibletriangle.skygrid.random.RandomCollection;
import com.possibletriangle.skygrid.random.SkygridOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;

public class ChunkGeneratorSkygrid
implements IChunkGenerator {
    private final World world;
    private final ResourceLocation dimension;
    private final Random random;
    private final BlockPos offset;
    private final BlockPos spawnBlock;
    private final BlockPos endPortal;
    private final int gridHeight;

    public ChunkGeneratorSkygrid(World world, ResourceLocation dimension, Random random, BlockPos offset, BlockPos spawnBlock, BlockPos endPortal, int gridHeight) {
        this.world = world;
        this.dimension = dimension;
        this.random = random;
        this.offset = offset;
        this.spawnBlock = spawnBlock;
        this.endPortal = endPortal;
        this.gridHeight = gridHeight;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = false;
        ChunkPrimer primer = new ChunkPrimer();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.gridHeight; ++y) {
                    BlockPos p = new BlockPos((x + 1) % 16, y + 1, (z + 1) % 16);
                    IBlockState fillBlock = SkygridOptions.getFillBlock(this.dimension, y);
                    if (primer.func_177856_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()).func_177230_c() != Blocks.field_150350_a) continue;
                    if (y % this.offset.func_177956_o() == 0 && (z + chunkZ * 16) % this.offset.func_177952_p() == 0 && (x + chunkX * 16) % this.offset.func_177958_n() == 0) {
                        if (p.func_177984_a().equals((Object)this.spawnBlock)) {
                            primer.func_177855_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), Blocks.field_150357_h.func_176223_P());
                            continue;
                        }
                        if (this.endPortal != null && new BlockPos(x + chunkX * 16, y, z + chunkZ * 16).equals((Object)this.endPortal)) {
                            DefaultsEnd.PORTAL.generateAt(primer, p.func_177958_n(), p.func_177952_p(), p.func_177956_o(), this.random, fillBlock);
                            continue;
                        }
                        if (y == 0) {
                            primer.func_177855_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), Blocks.field_150357_h.func_176223_P());
                            continue;
                        }
                        SkygridOptions.next(this.dimension, this.random, y).generateAt(primer, p.func_177958_n(), p.func_177952_p(), p.func_177956_o(), this.random, fillBlock);
                        continue;
                    }
                    if (primer.func_177856_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()).func_177230_c() != Blocks.field_150350_a) continue;
                    primer.func_177855_a(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), fillBlock);
                }
            }
        }
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 1; y < this.gridHeight; ++y) {
                    TileEntity te;
                    BlockPos pos = new BlockPos(x, y, z).func_177982_a(chunkX * 16, 0, chunkZ * 16);
                    IBlockState state = this.world.func_180495_p(pos);
                    if (!state.func_177230_c().hasTileEntity(state) || (te = this.world.func_175625_s(pos)) == null) continue;
                    NBTTagCompound nbt = new NBTTagCompound();
                    te.func_189515_b(nbt);
                    if (new ResourceLocation("quark", "custom_chest").equals((Object)state.func_177230_c().getRegistryName())) {
                        String[] type = new String[]{"spruce", "birch", "jungle", "dark_oak", "acacia"};
                        nbt.func_74778_a("type", type[this.random.nextInt(type.length)]);
                    }
                    nbt.func_74768_a("x", pos.func_177958_n());
                    nbt.func_74768_a("y", pos.func_177956_o());
                    nbt.func_74768_a("z", pos.func_177952_p());
                    te.func_145839_a(nbt);
                    RandomCollection<ResourceLocation> loot = SkygridOptions.getLoot(this.dimension);
                    RandomCollection<ResourceLocation> mobs = SkygridOptions.getMobs(this.dimension);
                    if (te instanceof TileEntityLockableLoot && loot.size() != 0) {
                        ResourceLocation l = loot.next(this.random);
                        ((TileEntityLockableLoot)te).func_189404_a(l, this.random.nextLong());
                    } else if (te instanceof TileEntityMobSpawner && mobs.size() != 0) {
                        ResourceLocation mob = mobs.next(this.random);
                        te.func_189515_b(nbt);
                        nbt.func_82580_o("SpawnPotentials");
                        te.func_145839_a(nbt);
                        ((TileEntityMobSpawner)te).func_145881_a().func_190894_a(mob);
                    }
                    Rotation rotation = Rotation.values()[this.random.nextInt(Rotation.values().length)];
                    te.func_189667_a(rotation);
                    te.func_70296_d();
                }
            }
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        return new ArrayList<Biome.SpawnListEntry>();
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World world, @Nonnull String name, @Nonnull BlockPos position, boolean findUnexplored) {
        if ("Stronghold".equals(name) && this.endPortal != null) {
            return this.endPortal.func_177982_a(1, findUnexplored ? 1 : position.func_177956_o(), 1);
        }
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_193414_a(World world, String name, BlockPos pos) {
        BlockPos nearest = this.func_180513_a(world, name, pos, true);
        if (nearest == null) return false;
        Vec3d vec3d = new Vec3d((Vec3i)nearest);
        Vec3d vec3d2 = new Vec3d((Vec3i)pos);
        if (!(vec3d.func_72438_d(vec3d2) <= 2.0)) return false;
        return true;
    }
}

