/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.generation;

import com.possibletriangle.skygrid.Skygrid;
import com.possibletriangle.skygrid.defaults.Defaults;
import com.possibletriangle.skygrid.generation.WorldProviderSkygrid;
import com.possibletriangle.skygrid.random.SkygridOptions;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class DimensionHelper {
    static final HashMap<ResourceLocation, WorldProvider> OLD = new HashMap();

    public static void overwriteDimensions() {
        for (ResourceLocation dim : SkygridOptions.dimensions()) {
            DimensionHelper.register(dim);
        }
    }

    private static void register(ResourceLocation dim) {
        Defaults defaults = (Defaults)GameRegistry.findRegistry(Defaults.class).getValue(dim);
        int ID = DimensionHelper.getIDFor(dim);
        if (ID != DimensionManager.getNextFreeDimId()) {
            Skygrid.LOGGER.info("Overwriting dimension {}", (Object)dim.func_110623_a());
            WorldProvider old = DimensionManager.getProviderType((int)ID).func_186070_d();
            OLD.put(dim, old);
            DimensionManager.unregisterDimension((int)ID);
            Class clazz = defaults == null ? WorldProviderSkygrid.class : defaults.providerClass(true);
            DimensionManager.registerDimension((int)ID, (DimensionType)DimensionType.register((String)dim.func_110623_a(), (String)("_" + dim.func_110623_a()), (int)ID, clazz, (boolean)false));
        } else if (!SkygridOptions.onlyOverride(dim)) {
            Skygrid.LOGGER.info("Creating dimension {}", (Object)dim.func_110623_a());
            Class clazz = defaults == null ? WorldProviderSkygrid.class : defaults.providerClass(false);
            DimensionManager.registerDimension((int)ID, (DimensionType)DimensionType.register((String)dim.func_110623_a(), (String)("_" + dim.func_110623_a()), (int)ID, clazz, (boolean)false));
        } else {
            Skygrid.LOGGER.info("There is no dimension with the name {}", (Object)dim.func_110623_a());
        }
    }

    public static int getIDFor(ResourceLocation dimensionID) {
        if (dimensionID.func_110623_a().toLowerCase().equals("nether") || dimensionID.func_110623_a().toLowerCase().equals("the_nether")) {
            return -1;
        }
        for (DimensionType type : DimensionManager.getRegisteredDimensions().keySet()) {
            if (!type.func_186065_b().toLowerCase().equals(dimensionID.func_110623_a().toLowerCase())) continue;
            return type.func_186068_a();
        }
        return DimensionManager.getNextFreeDimId();
    }
}

