/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.random;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.possibletriangle.skygrid.ConfigSkygrid;
import com.possibletriangle.skygrid.IJsonAble;
import com.possibletriangle.skygrid.Skygrid;
import com.possibletriangle.skygrid.blocks.BlockFrame;
import com.possibletriangle.skygrid.random.RandomCollectionBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.logging.log4j.util.Supplier;

public class BlockInfo
implements IJsonAble {
    private final RandomCollectionBlocks block = new RandomCollectionBlocks();
    private final HashMap<BlockPos, RandomCollectionBlocks> at = new HashMap();
    private Condition condition;
    private boolean valid = false;
    private boolean ignoreValidation = false;

    @Override
    public String key() {
        return "blockinfo";
    }

    @Override
    public boolean isValid() {
        return this.valid || this.ignoreValidation;
    }

    public BlockInfo ignoreValidation() {
        this.ignoreValidation = true;
        return this;
    }

    public BlockInfo cond(Condition condition) {
        this.condition = condition;
        return this;
    }

    public BlockInfo add(Object result, double weight) {
        this.block.add(weight, result);
        return this;
    }

    public BlockInfo add(Object result) {
        return this.add(result, 1.0);
    }

    public BlockInfo addAt(BlockPos pos, Object result, double weight) {
        RandomCollectionBlocks r = this.at.containsKey(pos) ? this.at.get(pos) : new RandomCollectionBlocks();
        r.add(weight, result);
        this.at.put(pos, r);
        return this;
    }

    public BlockInfo addAt(BlockPos pos, Object result) {
        return this.addAt(pos, result, 1.0);
    }

    public BlockInfo addAt(EnumFacing face, Object result, double weight) {
        return this.addAt(new BlockPos(0, 0, 0).func_177972_a(face), result, weight);
    }

    public BlockInfo addAt(EnumFacing face, Object result) {
        return this.addAt(face, result, 1.0);
    }

    public void generateAt(ChunkPrimer primer, int x, int z, int y, Random random, IBlockState fillblock) {
        if (x < 0 || x > 15 || y < 0 || y > 255 || z < 0 || z > 15) {
            Skygrid.LOGGER.error("Illegal block generation at {}/{}/{}", (Object)x, (Object)y, (Object)z);
            return;
        }
        IBlockState block = this.block.next(random);
        if (block != null) {
            primer.func_177855_a(x, y, z, BlockInfo.randomizeState(block, random));
            for (BlockPos p : this.at.keySet()) {
                IBlockState blockAt;
                if (p.func_177958_n() + x < 0 || p.func_177958_n() + x > 15 || p.func_177956_o() + y < 0 || p.func_177956_o() + y > 255 || p.func_177952_p() + z < 0 || p.func_177952_p() + z > 15 || (blockAt = this.at.get(p).next(random)) == null) continue;
                primer.func_177855_a(p.func_177958_n() + x, p.func_177956_o() + y, p.func_177952_p() + z, BlockInfo.randomizeState(blockAt, random));
            }
            if (random.nextDouble() <= (double)ConfigSkygrid.FRAME_CHANCE && (block.func_177230_c() instanceof BlockLiquid || block.func_177230_c() instanceof IFluidBlock)) {
                for (EnumFacing face : EnumFacing.values()) {
                    BlockPos p = new BlockPos(0, 0, 0).func_177972_a(face);
                    if (primer.func_177856_a(p.func_177958_n() + x, p.func_177956_o() + y, p.func_177952_p() + z).func_177230_c() != fillblock.func_177230_c()) continue;
                    primer.func_177855_a(p.func_177958_n() + x, p.func_177956_o() + y, p.func_177952_p() + z, BlockFrame.FRAME.func_176223_P());
                }
            }
        } else {
            Skygrid.LOGGER.error("BlockInfo is empty or does not contain any existing blocks: {}", new Supplier[]{this::toJSON});
        }
    }

    private static IBlockState randomizeState(IBlockState block, Random random) {
        if (block.func_177230_c() instanceof BlockLiquid || block.func_177230_c() instanceof IFluidBlock) {
            return block.func_177230_c().func_176223_P();
        }
        Rotation rot = Rotation.values()[random.nextInt(Rotation.values().length)];
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.values()[random.nextInt(BlockLog.EnumAxis.values().length)];
        for (IProperty prop : block.func_177228_b().keySet()) {
            Object[] values;
            if (prop.func_177699_b().isInstance(BlockLog.EnumAxis.Y)) {
                block = block.func_177226_a(prop, (Comparable)axis);
                continue;
            }
            if (prop.func_177699_b().isInstance(EnumDyeColor.ORANGE)) {
                values = prop.func_177700_c().toArray();
                block = block.func_177226_a(prop, (Comparable)((EnumDyeColor)values[random.nextInt(values.length)]));
                continue;
            }
            if ("age".equals(prop.func_177701_a()) && prop instanceof PropertyInteger) {
                values = ((PropertyInteger)prop).func_177700_c().toArray(new Integer[0]);
                int age = (Integer)values[random.nextInt(values.length)];
                block = block.func_177226_a(prop, (Comparable)Integer.valueOf(age));
                continue;
            }
            if (!BlockLeaves.field_176237_a.equals((Object)prop)) continue;
            block = block.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        }
        return block.func_185907_a(rot);
    }

    public double factorAt(int y) {
        return this.condition == null ? 1.0 : this.condition.factorAt(y);
    }

    @Override
    public void fromJSON(JsonElement json) {
        this.block.clear();
        this.at.clear();
        this.block.fromJSON(json.getAsJsonObject().get("blocks"));
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (!((String)entry.getKey()).startsWith("at")) continue;
            String[] i = ((String)entry.getKey()).replace("at[", "").replace("]", "").split(",");
            BlockPos p = new BlockPos(Integer.parseInt(i[0]), Integer.parseInt(i[1]), Integer.parseInt(i[2]));
            RandomCollectionBlocks r = new RandomCollectionBlocks();
            r.fromJSON((JsonElement)entry.getValue());
            this.at.put(p, r);
        }
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        json.add("blocks", this.block.toJSON());
        for (BlockPos pos : this.at.keySet()) {
            String key = "at[" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "]";
            json.add(key, this.at.get(pos).toJSON());
        }
        return json;
    }

    @Override
    public void validate() {
        this.valid = this.block.next(new Random()) != null;
    }

    public static interface Condition {
        public double factorAt(int var1);
    }
}

