/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.random;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class RandomCollection<E>
implements Iterable<E> {
    protected final NavigableMap<Double, Object> map = new TreeMap<Double, Object>();
    private double total = 0.0;

    @Override
    public Iterator<E> iterator() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : this.map.values()) {
            if (o instanceof RandomCollection) {
                for (E e : (RandomCollection)o) {
                    list.add(e);
                }
                continue;
            }
            list.add(o);
        }
        return list.iterator();
    }

    RandomCollection() {
    }

    public RandomCollection<E> add(double weight, E result) {
        if (weight <= 0.0) {
            return this;
        }
        this.total += weight;
        this.map.put(this.total, result);
        return this;
    }

    public RandomCollection<E> add(double weight, RandomCollection<E> sub) {
        if (weight <= 0.0 || sub.total == 0.0) {
            return this;
        }
        this.total += weight;
        this.map.put(this.total, sub);
        return this;
    }

    public E next(Random random) {
        if (this.total == 0.0) {
            return null;
        }
        double value = random.nextDouble() * this.total;
        Object o = this.map.higherEntry(value).getValue();
        if (o instanceof RandomCollection) {
            return ((RandomCollection)o).next(random);
        }
        return (E)o;
    }

    public void clear() {
        this.map.clear();
        this.total = 0.0;
    }

    public int size() {
        return this.map.size();
    }
}

