/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.random;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.possibletriangle.skygrid.IJsonAble;
import com.possibletriangle.skygrid.Skygrid;
import com.possibletriangle.skygrid.random.RandomCollection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class RandomCollectionBlocks
extends RandomCollection<Object>
implements IJsonAble {
    @Override
    public boolean isValid() {
        return this.size() > 0;
    }

    @Override
    public void validate() {
    }

    @Override
    public String key() {
        return "values";
    }

    public RandomCollectionBlocks add(double weight, Object result) {
        return (RandomCollectionBlocks)super.add(weight, result);
    }

    @Override
    public IBlockState next(Random random) {
        for (int i = 0; i < 100; ++i) {
            Object o = super.next(random);
            IBlockState rs = null;
            if (o instanceof ResourceLocation) {
                rs = RandomCollectionBlocks.stateFrom((ResourceLocation)o, random);
            }
            if (o instanceof IBlockState) {
                rs = (IBlockState)o;
            } else if (o instanceof Block) {
                rs = RandomCollectionBlocks.stateFrom(((Block)o).getRegistryName(), random);
            } else if (o instanceof String) {
                String ore = (String)o;
                boolean r = false;
                if (ore.contains(":")) {
                    if ("random".equals(ore.substring(0, ore.indexOf(58)))) {
                        r = true;
                    }
                    ore = ore.substring(ore.lastIndexOf(58) + 1);
                }
                ArrayList<IBlockState> ores = new ArrayList<IBlockState>();
                for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                    if (!(stack.func_77973_b() instanceof ItemBlock)) continue;
                    ores.add(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()));
                }
                if (!ores.isEmpty()) {
                    int index = r ? random.nextInt(ores.size()) : 0;
                    rs = (IBlockState)ores.get(index);
                }
            }
            if (rs == null) continue;
            return rs;
        }
        return null;
    }

    @Nullable
    private static IBlockState stateFrom(@Nullable ResourceLocation r, Random random) {
        int meta;
        if (r == null) {
            return null;
        }
        ResourceLocation name = r.func_110623_a().contains(":") ? new ResourceLocation(r.func_110624_b(), r.func_110623_a().substring(0, r.func_110623_a().indexOf(58))) : r;
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)name);
        if (!Block.field_149771_c.func_148741_d((Object)name)) {
            return null;
        }
        if (block == Blocks.field_150350_a) {
            return block.func_176223_P();
        }
        ArrayList<Integer> metas = new ArrayList<Integer>();
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            metas.add(block.func_176201_c(state));
        }
        int n = meta = metas.isEmpty() ? 0 : (Integer)metas.get(random.nextInt(metas.size()));
        if (r.func_110623_a().contains(":")) {
            String m = r.func_110623_a().substring(r.func_110623_a().indexOf(58) + 1);
            try {
                meta = Integer.parseInt(m);
            }
            catch (NumberFormatException ex) {
                Skygrid.LOGGER.error("{} is not a valid metadata (\"{}\")", (Object)m, (Object)r);
            }
        }
        return block.func_176203_a(meta);
    }

    @Override
    public void fromJSON(JsonElement json) {
        for (JsonElement e : json.getAsJsonArray()) {
            ResourceLocation block;
            JsonObject o = e.getAsJsonObject();
            double weight = o.get("weight").getAsDouble();
            if (o.has("values")) {
                RandomCollectionBlocks sub = new RandomCollectionBlocks();
                sub.fromJSON(o.get("values"));
                this.add(weight, sub);
                continue;
            }
            int meta = o.has("meta") ? o.get("meta").getAsInt() : -1;
            String ore = o.has("ore") ? o.get("ore").getAsString() : null;
            ResourceLocation resourceLocation = block = o.has("block") ? new ResourceLocation(o.get("block").getAsString()) : null;
            if (meta != -1 && block != null) {
                block = new ResourceLocation(block.func_110624_b(), block.func_110623_a() + ":" + meta);
            }
            if (ore != null) {
                this.add(weight, ore);
                continue;
            }
            if (block == null) continue;
            this.add(weight, block);
        }
    }

    @Override
    public JsonElement toJSON() {
        JsonArray array = new JsonArray();
        double total = 0.0;
        for (Map.Entry entry : this.map.entrySet()) {
            JsonObject o = new JsonObject();
            o.addProperty("weight", (Number)((Double)entry.getKey() - total));
            total = (Double)entry.getKey();
            if (entry.getValue() instanceof RandomCollectionBlocks) {
                o.add("values", ((RandomCollectionBlocks)entry.getValue()).toJSON());
            } else {
                String s = null;
                ResourceLocation r = null;
                int meta = -1;
                if (entry.getValue() instanceof Block) {
                    r = ((Block)entry.getValue()).getRegistryName();
                } else if (entry.getValue() instanceof IBlockState) {
                    r = ((IBlockState)entry.getValue()).func_177230_c().getRegistryName();
                    meta = ((IBlockState)entry.getValue()).func_177230_c().func_176201_c((IBlockState)entry.getValue());
                } else if (entry.getValue() instanceof ResourceLocation) {
                    r = (ResourceLocation)entry.getValue();
                    if (r.func_110623_a().contains(":")) {
                        try {
                            meta = Integer.parseInt(r.func_110623_a().substring(r.func_110623_a().indexOf(58) + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    r = r.func_110623_a().contains(":") ? new ResourceLocation(r.func_110624_b(), r.func_110623_a().substring(0, r.func_110623_a().indexOf(58))) : r;
                } else if (entry.getValue() instanceof String) {
                    s = (String)entry.getValue();
                }
                if (r != null) {
                    o.addProperty("block", r.toString());
                } else if (s != null) {
                    o.addProperty("ore", s);
                }
                if (meta != -1) {
                    o.addProperty("meta", (Number)meta);
                }
            }
            array.add((JsonElement)o);
        }
        return array;
    }
}

