/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.random;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.possibletriangle.skygrid.IJsonAble;
import com.possibletriangle.skygrid.random.RandomCollection;
import java.util.Map;
import java.util.Random;

public class RandomCollectionJson<E extends IJsonAble>
extends RandomCollection<E>
implements IJsonAble {
    private final Class<? extends E> clazz;
    private String key = "value";

    @Override
    public boolean isValid() {
        return this.size() > 0;
    }

    @Override
    public void validate() {
        for (IJsonAble e : this) {
            e.validate();
        }
    }

    @Override
    public String key() {
        return "values";
    }

    public RandomCollectionJson(Class<? extends E> clazz) {
        this.clazz = clazz;
        try {
            this.key = ((IJsonAble)clazz.newInstance()).key();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public E next(Random random) {
        IJsonAble e;
        int i = 0;
        do {
            e = (IJsonAble)super.next(random);
        } while (i++ < 100 && (e == null || !e.isValid()));
        return (E)(e.isValid() ? e : null);
    }

    @Override
    public void fromJSON(JsonElement json) {
        this.clear();
        for (JsonElement e : json.getAsJsonArray()) {
            double weight = e.getAsJsonObject().get("weight").getAsDouble();
            if (e.getAsJsonObject().has(this.key)) {
                try {
                    IJsonAble value = (IJsonAble)this.clazz.newInstance();
                    value.fromJSON(e.getAsJsonObject().get(this.key));
                    this.add(weight, value);
                }
                catch (Exception value) {}
                continue;
            }
            if (!e.getAsJsonObject().has(this.key())) continue;
            RandomCollectionJson<E> sub = new RandomCollectionJson<E>(this.clazz);
            sub.fromJSON(e.getAsJsonObject().get(this.key()));
            this.add(weight, sub);
        }
    }

    @Override
    public JsonElement toJSON() {
        JsonArray array = new JsonArray();
        double total = 0.0;
        for (Map.Entry entry : this.map.entrySet()) {
            JsonObject o = new JsonObject();
            o.addProperty("weight", (Number)((Double)entry.getKey() - total));
            total = (Double)entry.getKey();
            if (entry.getValue() instanceof IJsonAble) {
                o.add(((IJsonAble)entry.getValue()).key(), ((IJsonAble)entry.getValue()).toJSON());
            } else {
                o.addProperty(this.key, entry.getValue().toString());
            }
            array.add((JsonElement)o);
        }
        return array;
    }
}

