/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.random;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.possibletriangle.skygrid.IJsonAble;
import com.possibletriangle.skygrid.random.BlockInfo;
import com.possibletriangle.skygrid.random.RandomCollection;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class RandomCollectionRL
extends RandomCollection<ResourceLocation>
implements IJsonAble {
    @Override
    public boolean isValid() {
        return this.size() > 0;
    }

    @Override
    public void validate() {
    }

    @Override
    public String key() {
        return "values";
    }

    @Override
    public void fromJSON(JsonElement json) {
        this.clear();
        for (JsonElement e : json.getAsJsonArray()) {
            double weight = e.getAsJsonObject().get("weight").getAsDouble();
            if (e.getAsJsonObject().has("value")) {
                this.add(weight, new ResourceLocation(e.getAsJsonObject().get("value").getAsString()));
                continue;
            }
            if (!e.getAsJsonObject().has("values")) continue;
            RandomCollectionRL sub = new RandomCollectionRL();
            sub.fromJSON(e.getAsJsonObject().get("values"));
            this.add(weight, sub);
        }
    }

    @Override
    public JsonElement toJSON() {
        JsonArray array = new JsonArray();
        double total = 0.0;
        for (Map.Entry entry : this.map.entrySet()) {
            JsonObject o = new JsonObject();
            o.addProperty("weight", (Number)((Double)entry.getKey() - total));
            total = (Double)entry.getKey();
            if (entry.getValue() instanceof RandomCollectionRL) {
                o.add("values", ((RandomCollectionRL)entry.getValue()).toJSON());
            } else if (entry.getValue() instanceof BlockInfo) {
                o.add("value", ((BlockInfo)entry.getValue()).toJSON());
            } else {
                o.addProperty("value", entry.getValue().toString());
            }
            array.add((JsonElement)o);
        }
        return array;
    }
}

