/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.random;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.possibletriangle.skygrid.ConfigSkygrid;
import com.possibletriangle.skygrid.Skygrid;
import com.possibletriangle.skygrid.random.BlockInfo;
import com.possibletriangle.skygrid.random.RandomCollectionJson;
import com.possibletriangle.skygrid.random.SkygridOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class SkygridJSONConverter {
    private static final String DIR = "/dimensions/";

    public static String[] getConfigs() {
        File[] files = new File(ConfigSkygrid.DIR + DIR).listFiles();
        if (files == null) {
            return new String[0];
        }
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName().replaceAll(".json", "");
        }
        return names;
    }

    public static boolean existsConfig(ResourceLocation name) {
        return new File(ConfigSkygrid.DIR + DIR + name.func_110623_a() + ".json").exists();
    }

    private static void readFromJson(SkygridOptions options, JsonObject json) {
        Object r;
        int i;
        options.onlyOverride = !json.has("only_override") || json.get("only_override").getAsBoolean();
        options.HEIGHT = json.get("height").getAsInt();
        JsonArray offset = json.getAsJsonArray("offset");
        options.OFFSET = new BlockPos(offset.get(0).getAsInt(), offset.get(1).getAsInt(), offset.get(2).getAsInt());
        for (JsonElement e : json.getAsJsonArray("mobs")) {
            options.MOBS.add(e.getAsJsonObject().get("weight").getAsDouble(), new ResourceLocation(e.getAsJsonObject().get("value").getAsString()));
        }
        for (JsonElement e : json.getAsJsonArray("loot")) {
            options.LOOT.add(e.getAsJsonObject().get("weight").getAsDouble(), new ResourceLocation(e.getAsJsonObject().get("value").getAsString()));
        }
        for (Map.Entry entry : json.get("fill_blocks").getAsJsonObject().entrySet()) {
            i = Integer.parseInt(((String)entry.getKey()).replace("at[", "").replace("]", ""));
            r = new ResourceLocation(((JsonElement)entry.getValue()).getAsJsonObject().get("block").getAsString());
            int meta = ((JsonElement)entry.getValue()).getAsJsonObject().get("meta").getAsInt();
            IBlockState b = Block.field_149771_c.func_148741_d(r) ? ((Block)Block.field_149771_c.func_82594_a(r)).func_176203_a(meta) : Blocks.field_150350_a.func_176223_P();
            options.FILL_BLOCK.put(i, b);
        }
        for (Map.Entry entry : json.get("blocks").getAsJsonObject().entrySet()) {
            i = Integer.parseInt(((String)entry.getKey()).replace("at[", "").replace("]", ""));
            r = new RandomCollectionJson<BlockInfo>(BlockInfo.class);
            ((RandomCollectionJson)r).fromJSON((JsonElement)entry.getValue());
            options.BLOCKS.put(i, (RandomCollectionJson<BlockInfo>)r);
        }
    }

    public static void readFromConfig(SkygridOptions options, ResourceLocation name) {
        File file = new File(ConfigSkygrid.DIR + DIR + name.func_110623_a() + ".json");
        if (!file.exists()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String s = "";
            String line = null;
            while ((line = reader.readLine()) != null) {
                s = s + line;
            }
            reader.close();
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse(s).getAsJsonObject();
            SkygridJSONConverter.readFromJson(options, json);
            Skygrid.LOGGER.info("Read config for \"{}\"", (Object)name.func_110623_a());
        }
        catch (IOException e) {
            Skygrid.LOGGER.error("Error reading config for \"{}\"", (Object)name.func_110623_a());
        }
    }

    public static void createDefaultFile(SkygridOptions options, ResourceLocation name) {
        File file = new File(ConfigSkygrid.DIR + DIR + name.func_110623_a() + ".json");
        JsonObject json = SkygridJSONConverter.toJSON(options);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileWriter writer = new FileWriter(file);
            Gson gs = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            writer.write(gs.toJson((JsonElement)json));
            writer.close();
            Skygrid.LOGGER.info("Created default config for \"{}\"", (Object)name.func_110623_a());
        }
        catch (IOException e) {
            Skygrid.LOGGER.error("Error creating default config for \"{}\"", (Object)name.func_110623_a());
        }
    }

    public static JsonObject toJSON(SkygridOptions options) {
        JsonObject json = new JsonObject();
        json.addProperty("height", (Number)options.HEIGHT);
        json.addProperty("only_override", Boolean.valueOf(options.onlyOverride));
        JsonArray offset = new JsonArray();
        offset.add((Number)options.OFFSET.func_177958_n());
        offset.add((Number)options.OFFSET.func_177956_o());
        offset.add((Number)options.OFFSET.func_177952_p());
        json.add("offset", (JsonElement)offset);
        json.add("mobs", options.MOBS.toJSON());
        json.add("loot", options.LOOT.toJSON());
        JsonObject fill_blocks = new JsonObject();
        for (int floor : options.FILL_BLOCK.keySet()) {
            JsonObject o = new JsonObject();
            o.addProperty("block", options.FILL_BLOCK.get(floor).func_177230_c().getRegistryName().toString());
            o.addProperty("meta", (Number)options.FILL_BLOCK.get(floor).func_177230_c().func_176201_c(options.FILL_BLOCK.get(floor)));
            fill_blocks.add("at[" + floor + "]", (JsonElement)o);
        }
        json.add("fill_blocks", (JsonElement)fill_blocks);
        JsonObject blocks = new JsonObject();
        for (int floor : options.BLOCKS.keySet()) {
            blocks.add("at[" + floor + "]", options.BLOCKS.get(floor).toJSON());
        }
        json.add("blocks", (JsonElement)blocks);
        return json;
    }
}

