/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.random;

import com.possibletriangle.skygrid.ConfigSkygrid;
import com.possibletriangle.skygrid.Skygrid;
import com.possibletriangle.skygrid.defaults.Defaults;
import com.possibletriangle.skygrid.random.BlockInfo;
import com.possibletriangle.skygrid.random.RandomCollection;
import com.possibletriangle.skygrid.random.RandomCollectionJson;
import com.possibletriangle.skygrid.random.RandomCollectionRL;
import com.possibletriangle.skygrid.random.SkygridJSONConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class SkygridOptions {
    int HEIGHT;
    BlockPos OFFSET;
    final RandomCollectionRL MOBS = new RandomCollectionRL();
    final RandomCollectionRL LOOT = new RandomCollectionRL();
    final HashMap<Integer, IBlockState> FILL_BLOCK = new HashMap();
    final HashMap<Integer, RandomCollectionJson<BlockInfo>> BLOCKS = new HashMap();
    boolean onlyOverride;
    private static final HashMap<ResourceLocation, SkygridOptions> OPTIONS = new HashMap();

    private SkygridOptions() {
    }

    public static boolean onlyOverride(ResourceLocation name) {
        return !OPTIONS.containsKey(name) || SkygridOptions.OPTIONS.get((Object)name).onlyOverride;
    }

    private static RandomCollection<BlockInfo> forDimension(ResourceLocation dimensionID, int atY) {
        if (dimensionID.func_110623_a().toLowerCase().equals("nether")) {
            dimensionID = new ResourceLocation(dimensionID.func_110624_b(), "the_nether");
        }
        SkygridOptions options = OPTIONS.get(dimensionID);
        for (int i = options.BLOCKS.size() - 1; i >= 0; --i) {
            if (options.BLOCKS.keySet().toArray(new Integer[0])[i] > atY) continue;
            return options.BLOCKS.get(options.BLOCKS.keySet().toArray(new Integer[0])[i]);
        }
        return null;
    }

    public static BlockPos getOffset(ResourceLocation dimensionID) {
        BlockPos offset;
        if (dimensionID.func_110623_a().toLowerCase().equals("nether")) {
            dimensionID = new ResourceLocation(dimensionID.func_110624_b(), "the_nether");
        }
        if ((offset = SkygridOptions.OPTIONS.get((Object)dimensionID).OFFSET) == null) {
            Skygrid.LOGGER.error("No offset defined for dimension \"{}\"", (Object)dimensionID);
            offset = new BlockPos(4, 4, 4);
        }
        return offset;
    }

    public static int getHeight(ResourceLocation dimensionID) {
        if (dimensionID.func_110623_a().toLowerCase().equals("nether")) {
            dimensionID = new ResourceLocation(dimensionID.func_110624_b(), "the_nether");
        }
        return Math.max(SkygridOptions.OPTIONS.get((Object)dimensionID).HEIGHT, 4);
    }

    public static RandomCollection<ResourceLocation> getLoot(ResourceLocation dimensionID) {
        if (dimensionID.func_110623_a().toLowerCase().equals("nether")) {
            dimensionID = new ResourceLocation(dimensionID.func_110624_b(), "the_nether");
        }
        return SkygridOptions.OPTIONS.get((Object)dimensionID).LOOT;
    }

    public static RandomCollection<ResourceLocation> getMobs(ResourceLocation dimensionID) {
        if (dimensionID.func_110623_a().toLowerCase().equals("nether")) {
            dimensionID = new ResourceLocation(dimensionID.func_110624_b(), "the_nether");
        }
        return SkygridOptions.OPTIONS.get((Object)dimensionID).MOBS;
    }

    public static IBlockState getFillBlock(ResourceLocation dimensionID, int atY) {
        if (dimensionID.func_110623_a().toLowerCase().equals("nether")) {
            dimensionID = new ResourceLocation(dimensionID.func_110624_b(), "the_nether");
        }
        IBlockState fillBlock = null;
        for (int floor : SkygridOptions.OPTIONS.get((Object)dimensionID).FILL_BLOCK.keySet()) {
            if (floor > atY) continue;
            fillBlock = SkygridOptions.OPTIONS.get((Object)dimensionID).FILL_BLOCK.get(floor);
        }
        if (fillBlock == null) {
            Skygrid.LOGGER.error("No fill block defined for dimension \"{}\"", (Object)dimensionID);
            fillBlock = Blocks.field_150350_a.func_176223_P();
        }
        return fillBlock;
    }

    public static BlockInfo next(ResourceLocation dimensionType, Random random, int atY) {
        RandomCollection<BlockInfo> blocks = SkygridOptions.forDimension(dimensionType, atY);
        if (blocks == null) {
            return new BlockInfo().add(Blocks.field_150350_a);
        }
        BlockInfo info = blocks.next(random);
        if (info == null) {
            throw new NullPointerException("No blocks defined for \"" + dimensionType.toString() + "\"");
        }
        return info;
    }

    public static void validate() {
        for (ResourceLocation name : OPTIONS.keySet()) {
            for (RandomCollectionJson<BlockInfo> blocks : SkygridOptions.OPTIONS.get((Object)name).BLOCKS.values()) {
                blocks.validate();
            }
        }
    }

    public static void reload(boolean reset) {
        IForgeRegistry REGISTRY = GameRegistry.findRegistry(Defaults.class);
        ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>();
        for (Defaults defaults : REGISTRY) {
            if (defaults.getRegistryName() == null) continue;
            names.add(defaults.getRegistryName());
        }
        for (String name : SkygridJSONConverter.getConfigs()) {
            if (names.contains(new ResourceLocation(name))) continue;
            names.add(new ResourceLocation(name));
        }
        for (ResourceLocation name : names) {
            Defaults defaults = (Defaults)REGISTRY.getValue(name);
            SkygridOptions options = OPTIONS.containsKey(name) ? OPTIONS.get(name) : new SkygridOptions();
            options.BLOCKS.clear();
            options.LOOT.clear();
            options.MOBS.clear();
            options.FILL_BLOCK.clear();
            if (Arrays.asList(ConfigSkygrid.BLACKLISTED).contains(name.func_110623_a())) continue;
            if (!reset && SkygridJSONConverter.existsConfig(name)) {
                SkygridJSONConverter.readFromConfig(options, name);
                SkygridJSONConverter.createDefaultFile(options, name);
            } else if (defaults != null) {
                options.onlyOverride = defaults.onlyOverwrite();
                options.HEIGHT = defaults.getHeight();
                options.OFFSET = defaults.getOffset();
                for (int floor : defaults.floors()) {
                    RandomCollectionJson<BlockInfo> info = new RandomCollectionJson<BlockInfo>(BlockInfo.class);
                    defaults.registerBlocks(info, floor);
                    options.BLOCKS.put(floor, info);
                    options.FILL_BLOCK.put(floor, defaults.getFillState(floor));
                }
                defaults.registerLoot(options.LOOT);
                defaults.registerMobs(options.MOBS);
                SkygridJSONConverter.createDefaultFile(options, name);
            }
            OPTIONS.put(name, options);
        }
    }

    public static ResourceLocation[] dimensions() {
        return OPTIONS.keySet().toArray(new ResourceLocation[0]);
    }
}

