/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.skygrid.travel;

import com.possibletriangle.skygrid.ConfigSkygrid;
import com.possibletriangle.skygrid.Skygrid;
import com.possibletriangle.skygrid.generation.DimensionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class TravelManager {
    private static final HashMap<ResourceLocation, ArrayList<ResourceLocation>> FROM_TO = new HashMap();
    public static final DataParameter<Boolean> FALL_TO_DEATH = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> LIMBO_COUNT = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> LIMBO_COUNTDOWN = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);

    public static boolean registerFall(ResourceLocation from, ResourceLocation to, boolean overwrite) {
        boolean exists;
        if (!FROM_TO.containsKey(from)) {
            FROM_TO.put(from, new ArrayList());
        }
        Skygrid.LOGGER.info("Registering fall from {} to {}", (Object)from, (Object)to);
        boolean bl = exists = !FROM_TO.get(from).isEmpty();
        if (exists && overwrite) {
            FROM_TO.get(from).clear();
        }
        FROM_TO.get(from).add(to);
        return exists;
    }

    public static ResourceLocation fallDimension(ResourceLocation from, Random random) {
        if (from.func_110623_a().toLowerCase().equals("nether")) {
            from = new ResourceLocation(from.func_110624_b(), "the_nether");
        }
        return !FROM_TO.containsKey(from) || FROM_TO.get(from).isEmpty() ? null : FROM_TO.get(from).get(random.nextInt(FROM_TO.get(from).size()));
    }

    public static ResourceLocation climbDimension(ResourceLocation from) {
        if (from.func_110623_a().toLowerCase().equals("nether")) {
            from = new ResourceLocation(from.func_110624_b(), "the_nether");
        }
        for (ResourceLocation r : FROM_TO.keySet()) {
            if (!FROM_TO.get(r).contains(from)) continue;
            return r;
        }
        return null;
    }

    @SubscribeEvent
    public static void playerConstruction(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.getEntity().func_184212_Q().func_187214_a(FALL_TO_DEATH, (Object)false);
            event.getEntity().func_184212_Q().func_187214_a(LIMBO_COUNT, (Object)0);
            event.getEntity().func_184212_Q().func_187214_a(LIMBO_COUNTDOWN, (Object)0);
        }
    }

    @SubscribeEvent
    public static void crossDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        String to;
        String from = DimensionManager.getProviderType((int)event.fromDim).func_186065_b();
        if (from.equals(to = DimensionManager.getProviderType((int)event.toDim).func_186065_b())) {
            return;
        }
        if ("limbo".equals(from)) {
            Potion weakness = Potion.func_180142_b((String)"minecraft:weakness");
            if (weakness != null) {
                event.player.func_70690_d(new PotionEffect(weakness, 6000, 2, true, false));
            }
        } else if ("limbo".equals(to)) {
            event.player.func_184212_Q().func_187227_b(LIMBO_COUNT, (Object)((Integer)event.player.func_184212_Q().func_187225_a(LIMBO_COUNT) + 1));
            event.player.func_145747_a((ITextComponent)new TextComponentString("Limbo Count: " + event.player.func_184212_Q().func_187225_a(LIMBO_COUNT)));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if ((Integer)event.player.func_184212_Q().func_187225_a(LIMBO_COUNT) > 0) {
            if ((Integer)event.player.func_184212_Q().func_187225_a(LIMBO_COUNTDOWN) > 0) {
                if ((Integer)event.player.func_184212_Q().func_187225_a(LIMBO_COUNTDOWN) == 1) {
                    // empty if block
                }
                event.player.func_184212_Q().func_187227_b(LIMBO_COUNTDOWN, (Object)((Integer)event.player.func_184212_Q().func_187225_a(LIMBO_COUNTDOWN) - 1));
            } else {
                int min = 10 + 40 / (Integer)event.player.func_184212_Q().func_187225_a(LIMBO_COUNT);
                int dis = 15;
                int c = (int)((Math.random() + (double)min) * 20.0 * 60.0 * 60.0 * (double)dis);
                event.player.func_184212_Q().func_187227_b(LIMBO_COUNTDOWN, (Object)c);
            }
        }
        if (event.player.field_70163_u <= (double)ConfigSkygrid.LOWER && !((Boolean)event.player.func_184212_Q().func_187225_a(FALL_TO_DEATH)).booleanValue()) {
            boolean die;
            Skygrid.LOGGER.info("{} fell", (Object)event.player.func_145748_c_().func_150254_d());
            ResourceLocation from = new ResourceLocation(DimensionManager.getProviderType((int)event.player.field_71093_bK).func_186065_b());
            Random r = new Random();
            ResourceLocation to = new ResourceLocation("skygrid", "limbo");
            if (r.nextFloat() >= ConfigSkygrid.LIMBO_CHANCE_FALL) {
                to = TravelManager.fallDimension(from, r);
            }
            boolean bl = die = to == null || r.nextDouble() < (double)ConfigSkygrid.VOID_CHANCE;
            if (from.func_110623_a().equals("limbo")) {
                die = false;
                to = from;
            }
            event.player.func_184212_Q().func_187227_b(FALL_TO_DEATH, (Object)true);
            if (!die) {
                event.player.changeDimension(DimensionHelper.getIDFor(to), (ITeleporter)new FallTeleporter(new BlockPos(event.player.field_70165_t, (double)(Skygrid.WORLD_HEIGHT + ConfigSkygrid.UPPER), event.player.field_70161_v)));
            }
        }
        if (event.player.field_70163_u >= 0.0 && event.player.field_70163_u <= (double)Skygrid.WORLD_HEIGHT && ((Boolean)event.player.func_184212_Q().func_187225_a(FALL_TO_DEATH)).booleanValue()) {
            Skygrid.LOGGER.info("{} returned to a safe space", (Object)event.player.func_145748_c_().func_150254_d());
            event.player.func_184212_Q().func_187227_b(FALL_TO_DEATH, (Object)false);
        }
        if (event.player.field_70163_u >= (double)(Skygrid.WORLD_HEIGHT + ConfigSkygrid.UPPER) && !((Boolean)event.player.func_184212_Q().func_187225_a(FALL_TO_DEATH)).booleanValue()) {
            Skygrid.LOGGER.info("{} climbed", (Object)event.player.func_145748_c_().func_150254_d());
            ResourceLocation from = new ResourceLocation(DimensionManager.getProviderType((int)event.player.field_71093_bK).func_186065_b());
            ResourceLocation to = new ResourceLocation("skygrid", "limbo");
            Random random = new Random();
            if (random.nextFloat() >= ConfigSkygrid.LIMBO_CHANCE_CLIMB) {
                to = TravelManager.climbDimension(from);
            }
            if (from.func_110623_a().equals("limbo")) {
                to = from;
            }
            event.player.func_184212_Q().func_187227_b(FALL_TO_DEATH, (Object)true);
            if (to != null) {
                event.player.changeDimension(DimensionHelper.getIDFor(to), (ITeleporter)new FallTeleporter(new BlockPos(event.player.field_70165_t, -10.0, event.player.field_70161_v)));
                event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:levitation"), 200, 3, true, true));
            }
        }
    }

    public static void registerDefaults() {
    }

    public static void validate() {
        ArrayList<ResourceLocation> remove_from = new ArrayList<ResourceLocation>();
        for (ResourceLocation from : FROM_TO.keySet()) {
            if (DimensionHelper.getIDFor(from) == DimensionManager.getNextFreeDimId()) {
                remove_from.add(from);
                continue;
            }
            ArrayList<ResourceLocation> remove = new ArrayList<ResourceLocation>();
            for (ResourceLocation to : FROM_TO.get(from)) {
                if (DimensionHelper.getIDFor(to) != DimensionManager.getNextFreeDimId()) continue;
                remove.add(to);
            }
            FROM_TO.get(from).removeAll(remove);
        }
        FROM_TO.keySet().removeAll(remove_from);
    }

    private static class FallTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        private FallTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_174828_a(this.targetPos, yaw, entity.field_70125_A);
        }
    }
}

