/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.shapes.GuideShape;
import openmods.item.ItemOpenBlock;
import openmods.utils.TranslationUtils;

public class ItemGuide
extends ItemOpenBlock {
    public static final String TAG_POS_X = "PosX";
    public static final String TAG_NEG_X = "NegX";
    public static final String TAG_POS_Y = "PosY";
    public static final String TAG_NEG_Y = "NegY";
    public static final String TAG_POS_Z = "PosZ";
    public static final String TAG_NEG_Z = "NegZ";
    public static final String TAG_COLOR = "Color";
    public static final String TAG_SHAPE = "Mode";
    public static final String TAG_WIDTH = "Width";
    public static final String TAG_HEIGHT = "Height";
    public static final String TAG_DEPTH = "Depth";

    public ItemGuide(Block block) {
        super(block);
    }

    private static void addIntInfo(NBTTagCompound tag, String name, String format, List<String> result) {
        if (tag.func_74764_b(name)) {
            result.add(TranslationUtils.translateToLocalFormatted((String)format, (Object[])new Object[]{tag.func_74762_e(name)}));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> result, ITooltipFlag flag) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74764_b(TAG_NEG_X) && tag.func_74764_b(TAG_NEG_Y) || tag.func_74764_b(TAG_NEG_Z) || tag.func_74764_b(TAG_POS_X) && tag.func_74764_b(TAG_POS_Y) || tag.func_74764_b(TAG_POS_Z)) {
                int posX = tag.func_74762_e(TAG_POS_X);
                int posY = tag.func_74762_e(TAG_POS_Y);
                int posZ = tag.func_74762_e(TAG_POS_Z);
                int negX = -tag.func_74762_e(TAG_NEG_X);
                int negY = -tag.func_74762_e(TAG_NEG_Y);
                int negZ = -tag.func_74762_e(TAG_NEG_Z);
                result.add(TranslationUtils.translateToLocalFormatted((String)"openblocks.misc.box", (Object[])new Object[]{negX, negY, negZ, posX, posY, posZ}));
            } else {
                ItemGuide.addIntInfo(tag, TAG_WIDTH, "openblocks.misc.width", result);
                ItemGuide.addIntInfo(tag, TAG_HEIGHT, "openblocks.misc.height", result);
            }
            ItemGuide.addIntInfo(tag, TAG_DEPTH, "openblocks.misc.depth", result);
            ItemGuide.addIntInfo(tag, TAG_COLOR, "openblocks.misc.color", result);
            if (tag.func_74764_b(TAG_SHAPE)) {
                int mode = tag.func_74762_e(TAG_SHAPE);
                try {
                    GuideShape shape = GuideShape.VALUES[mode];
                    result.add(TranslationUtils.translateToLocalFormatted((String)"openblocks.misc.shape", (Object[])new Object[]{shape.getLocalizedName()}));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }
}

