/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.BOPGeneratorBase;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class GeneratorLakes
extends BOPGeneratorBase {
    protected IBlockState liquid;
    protected IBlockState frozenLiquid;
    protected IBlockState grassBorderWith;
    protected IBlockPosQuery grassReplace;
    protected IBlockState lineWith;
    protected GeneratorUtils.ScatterYMethod scatterYMethod;

    public GeneratorLakes(float amountPerChunk, IBlockState liquid, IBlockState frozenLiquid, IBlockState grassBorderWith, IBlockPosQuery grassReplace, IBlockState lineWith, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk);
        this.liquid = liquid;
        this.frozenLiquid = frozenLiquid;
        this.grassBorderWith = grassBorderWith;
        this.grassReplace = grassReplace;
        this.lineWith = lineWith;
        this.scatterYMethod = scatterYMethod;
    }

    @Override
    public BlockPos getScatterY(World world, Random random, int x, int z) {
        return this.scatterYMethod.getBlockPos(world, random, x, z);
    }

    public boolean[] getCavityShape(Random rand) {
        boolean[] cavityShape = new boolean[2048];
        int numPasses = rand.nextInt(4) + 4;
        for (int pass = 0; pass < numPasses; ++pass) {
            double scaleX = rand.nextDouble() * 6.0 + 3.0;
            double scaleY = rand.nextDouble() * 4.0 + 2.0;
            double scaleZ = rand.nextDouble() * 6.0 + 3.0;
            double pointX = rand.nextDouble() * (16.0 - scaleX - 2.0) + 1.0 + scaleX / 2.0;
            double pointY = rand.nextDouble() * (8.0 - scaleY - 4.0) + 2.0 + scaleY / 2.0;
            double pointZ = rand.nextDouble() * (16.0 - scaleZ - 2.0) + 1.0 + scaleZ / 2.0;
            for (int x = 1; x < 15; ++x) {
                for (int z = 1; z < 15; ++z) {
                    for (int y = 1; y < 7; ++y) {
                        double dx = ((double)x - pointX) / (scaleX / 2.0);
                        double dy = ((double)y - pointY) / (scaleY / 2.0);
                        double dz = ((double)z - pointZ) / (scaleZ / 2.0);
                        double r = dx * dx + dy * dy + dz * dz;
                        if (!(r < 1.0)) continue;
                        cavityShape[(x * 16 + z) * 8 + y] = true;
                    }
                }
            }
        }
        return cavityShape;
    }

    public boolean isCavityEdge(int x, int y, int z, boolean[] cavityShape) {
        if (cavityShape[(x * 16 + z) * 8 + y]) {
            return false;
        }
        return x < 15 && cavityShape[((x + 1) * 16 + z) * 8 + y] || x > 0 && cavityShape[((x - 1) * 16 + z) * 8 + y] || z < 15 && cavityShape[(x * 16 + z + 1) * 8 + y] || z > 0 && cavityShape[(x * 16 + (z - 1)) * 8 + y] || y < 7 && cavityShape[(x * 16 + z) * 8 + y + 1] || y > 0 && cavityShape[(x * 16 + z) * 8 + (y - 1)];
    }

    public boolean isCavityViable(World world, BlockPos startPos, boolean[] cavityShape) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 8; ++y) {
                    if (!this.isCavityEdge(x, y, z, cavityShape)) continue;
                    Material material = world.func_180495_p(startPos.func_177982_a(x, y, z)).func_185904_a();
                    if (y >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (y >= 4 || material.func_76220_a() || world.func_180495_p(startPos.func_177982_a(x, y, z)).func_177230_c() == this.liquid) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int y;
        int z;
        int x;
        boolean[] cavityShape;
        pos = pos.func_177982_a(-8, 0, -8);
        while (pos.func_177956_o() > 5 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 4) {
            return false;
        }
        if (!this.isCavityViable(world, pos = pos.func_177979_c(4), cavityShape = this.getCavityShape(rand))) {
            return false;
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 0; y < 8; ++y) {
                    if (!cavityShape[(x * 16 + z) * 8 + y]) continue;
                    world.func_180501_a(pos.func_177982_a(x, y, z), y >= 4 ? Blocks.field_150350_a.func_176223_P() : this.liquid, 2);
                }
            }
        }
        if (this.grassBorderWith != null) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 4; y < 8; ++y) {
                        BlockPos blockBelow;
                        if (!cavityShape[(x * 16 + z) * 8 + y] || !this.grassReplace.matches(world, blockBelow = pos.func_177982_a(x, y - 1, z)) || world.func_175642_b(EnumSkyBlock.SKY, pos.func_177982_a(x, y, z)) <= 0) continue;
                        world.func_180501_a(blockBelow, this.grassBorderWith, 2);
                    }
                }
            }
        }
        if (this.lineWith != null) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 0; y < 8; ++y) {
                        if (!this.isCavityEdge(x, y, z, cavityShape) || y >= 4 && rand.nextInt(2) == 0 || !world.func_180495_p(pos.func_177982_a(x, y, z)).func_185904_a().func_76220_a()) continue;
                        world.func_180501_a(pos.func_177982_a(x, y, z), this.lineWith, 2);
                    }
                }
            }
        }
        if (this.frozenLiquid != null) {
            y = 4;
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    if (!world.func_175675_v(pos.func_177982_a(x, y, z))) continue;
                    world.func_180501_a(pos.func_177982_a(x, y, z), this.frozenLiquid, 2);
                }
            }
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.liquid = conf.getBlockState("liquid", this.liquid);
        this.lineWith = conf.getBlockState("lineWith", this.lineWith);
        this.grassBorderWith = conf.getBlockState("grassBorderWith", this.grassBorderWith);
        this.frozenLiquid = conf.getBlockState("frozenLiquid", this.frozenLiquid);
        this.grassReplace = conf.getBlockPosQuery("grassReplace", this.grassReplace);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
    }

    public static class Builder
    extends BOPGeneratorBase.InnerBuilder<Builder, GeneratorLakes>
    implements IGenerator.IGeneratorBuilder<GeneratorLakes> {
        protected IBlockState liquid;
        protected IBlockState frozenLiquid;
        protected IBlockState grassBorderWith;
        protected IBlockPosQuery grassReplace;
        protected IBlockState lineWith;
        protected GeneratorUtils.ScatterYMethod scatterYMethod;

        public Builder liquid(IBlockState a) {
            this.liquid = a;
            return (Builder)this.self();
        }

        public Builder liquid(Block a) {
            this.liquid = a.func_176223_P();
            return (Builder)this.self();
        }

        public Builder frozenLiquid(IBlockState a) {
            this.frozenLiquid = a;
            return (Builder)this.self();
        }

        public Builder frozenLiquid(Block a) {
            this.frozenLiquid = a.func_176223_P();
            return (Builder)this.self();
        }

        public Builder grassBorderWith(IBlockState a) {
            this.grassBorderWith = a;
            return (Builder)this.self();
        }

        public Builder grassBorderWith(Block a) {
            this.grassBorderWith = a.func_176223_P();
            return (Builder)this.self();
        }

        public Builder grassReplace(IBlockPosQuery a) {
            this.grassReplace = a;
            return (Builder)this.self();
        }

        public Builder grassReplace(String a) throws BlockQuery.BlockQueryParseException {
            this.grassReplace = BlockQuery.parseQueryString(a);
            return (Builder)this.self();
        }

        public Builder grassReplace(Block a) {
            this.grassReplace = new BlockQuery.BlockQueryBlock(a);
            return (Builder)this.self();
        }

        public Builder grassReplace(IBlockState a) {
            this.grassReplace = new BlockQuery.BlockQueryState(a);
            return (Builder)this.self();
        }

        public Builder lineWith(IBlockState a) {
            this.lineWith = a;
            return (Builder)this.self();
        }

        public Builder lineWith(Block a) {
            this.lineWith = a.func_176223_P();
            return (Builder)this.self();
        }

        public Builder scatterYMethod(GeneratorUtils.ScatterYMethod a) {
            this.scatterYMethod = a;
            return (Builder)this.self();
        }

        public Builder waterLakeForBiome(Biome a) {
            this.liquid = Blocks.field_150355_j.func_176223_P();
            this.frozenLiquid = Blocks.field_150432_aD.func_176223_P();
            this.grassBorderWith = a.field_76752_A;
            this.grassReplace = new BlockQuery.BlockQueryBlock(a.field_76753_B.func_177230_c());
            this.lineWith = null;
            return this;
        }

        public Builder lavaLake() {
            this.liquid = Blocks.field_150353_l.func_176223_P();
            this.frozenLiquid = null;
            this.grassBorderWith = null;
            this.grassReplace = null;
            this.lineWith = Blocks.field_150348_b.func_176223_P();
            return this;
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.liquid = Blocks.field_150355_j.func_176223_P();
            this.frozenLiquid = Blocks.field_150432_aD.func_176223_P();
            this.grassBorderWith = Blocks.field_150349_c.func_176223_P();
            this.grassReplace = new BlockQuery.BlockQueryBlock(Blocks.field_150346_d);
            this.lineWith = null;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
        }

        @Override
        public GeneratorLakes create() {
            return new GeneratorLakes(this.amountPerChunk, this.liquid, this.frozenLiquid, this.grassBorderWith, this.grassReplace, this.lineWith, this.scatterYMethod);
        }
    }
}

