/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft;

import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tropicraft.ColorHelper;
import net.tropicraft.client.gui.TropicraftGuiHandler;
import net.tropicraft.core.common.BuildEvents;
import net.tropicraft.core.common.biome.BiomeTropicraft;
import net.tropicraft.core.common.capability.ExtendedPlayerStorage;
import net.tropicraft.core.common.capability.ExtendedWorldStorage;
import net.tropicraft.core.common.capability.PlayerDataInstance;
import net.tropicraft.core.common.capability.WorldDataInstance;
import net.tropicraft.core.common.command.CommandTropicsMiscClient;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.dimension.TropicraftWorldUtils;
import net.tropicraft.core.common.donations.ThreadWorkerDonations;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.event.AchievementEvents;
import net.tropicraft.core.common.event.BlockEvents;
import net.tropicraft.core.common.event.ItemEvents;
import net.tropicraft.core.common.event.MiscEvents;
import net.tropicraft.core.common.event.ScubaHandlerCommon;
import net.tropicraft.core.common.event.SpawnEvents;
import net.tropicraft.core.common.item.scuba.ScubaCapabilities;
import net.tropicraft.core.common.network.TCPacketHandler;
import net.tropicraft.core.common.worldgen.overworld.TCWorldGenerator;
import net.tropicraft.core.encyclopedia.TropicalBook;
import net.tropicraft.core.proxy.CommonProxy;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.CommandRegistry;
import net.tropicraft.core.registry.FluidRegistry;
import net.tropicraft.core.registry.LootRegistry;
import net.tropicraft.core.registry.OreDict;
import net.tropicraft.core.registry.SmeltingRegistry;
import net.tropicraft.core.registry.SoundRegistry;
import net.tropicraft.core.registry.TileEntityRegistry;

@Mod(modid="tropicraft", version="7.1.9.115", dependencies="after:forge@[14.23.0.2544,)", guiFactory="net.tropicraft.client.gui.TropicraftGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Tropicraft {
    @SidedProxy(clientSide="net.tropicraft.core.proxy.ClientProxy", serverSide="net.tropicraft.core.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="tropicraft")
    public static Tropicraft instance;
    public static TropicalBook encyclopedia;
    @CapabilityInject(value=PlayerDataInstance.class)
    public static final Capability<PlayerDataInstance> PLAYER_DATA_INSTANCE;
    @CapabilityInject(value=WorldDataInstance.class)
    public static final Capability<WorldDataInstance> WORLD_DATA_INSTANCE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        TropicsConfigs.init(event.getSuggestedConfigurationFile());
        ColorHelper.init();
        SoundRegistry.init();
        proxy.preInit();
        TileEntityRegistry.init();
        ScubaCapabilities.register();
        CapabilityManager.INSTANCE.register(PlayerDataInstance.class, (Capability.IStorage)new ExtendedPlayerStorage(), PlayerDataInstance.class);
        CapabilityManager.INSTANCE.register(WorldDataInstance.class, (Capability.IStorage)new ExtendedWorldStorage(), WorldDataInstance.class);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new TropicraftGuiHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        TCPacketHandler.init();
        proxy.init();
        MixerRecipes.addMixerRecipes();
        proxy.registerBooks();
        SmeltingRegistry.init();
        OreDict.registerVanilla();
        MinecraftForge.EVENT_BUS.register((Object)new ItemEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)new AchievementEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BuildEvents());
        MinecraftForge.EVENT_BUS.register((Object)new MiscEvents());
        MinecraftForge.EVENT_BUS.register((Object)new SpawnEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ScubaHandlerCommon());
        BiomeTropicraft.registerBiomes();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TCWorldGenerator(), (int)10);
        TropicraftWorldUtils.initializeDimension();
        BlockRegistry.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FluidRegistry.postInit();
        LootRegistry.postInit();
        if (event.getSide().isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTropicsMiscClient());
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        CommandRegistry.init(event);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppingEvent event) {
        ThreadWorkerDonations.getInstance().stopThread();
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        event.applyModContainer((ModContainer)ForgeModContainer.getInstance());
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (imcMessage.getSender().equals("tropicraft") || !imcMessage.key.equalsIgnoreCase("loaderFarewellSkip")) {
                return;
            }
            if (!imcMessage.isNBTMessage()) continue;
            NBTTagCompound n = imcMessage.getNBTValue();
            int id = n.func_74762_e("dim_id");
            String name = n.func_74779_i("dim_name");
            System.out.println("Received IMC request to add dimension \"" + name + ":" + id + "\" to farewellSkipDimensions from modid:" + imcMessage.getSender());
        }
    }

    @SubscribeEvent
    public void fixMissingItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110623_a().equals("bamboo_shoots")) continue;
            mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)BlockRegistry.bambooShoot));
        }
    }

    static {
        PLAYER_DATA_INSTANCE = null;
        WORLD_DATA_INSTANCE = null;
    }
}

