/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.entity.placeable.EntityBeachFloat;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicraftWaterBase;
import net.tropicraft.core.common.network.MessagePlayerSwimData;
import net.tropicraft.core.common.network.TCPacketHandler;
import net.tropicraft.core.registry.ItemRegistry;

public class ScubaHandler {
    public final float SWIM_SPEED_ACCEL = 0.008f;
    public final float SWIM_SPEED_ROTATE_YAW = 2.0f;
    public final float SWIM_SPEED_ROTATE_PITCH = 1.0f;
    public final float SWIM_SPEED_ROTATE_ROLL = 0.5f;
    public static HashMap<UUID, MessagePlayerSwimData.PlayerSwimData> rotationMap = new HashMap();
    private HashMap<Item, Float> flipperSpeedMap = new HashMap();
    private boolean inGUI = false;

    public ScubaHandler() {
        this.flipperSpeedMap.put(ItemRegistry.pinkFlippers, Float.valueOf(1.5f));
        this.flipperSpeedMap.put(ItemRegistry.yellowFlippers, Float.valueOf(1.5f));
    }

    @SubscribeEvent
    public void onRenderViewTick(EntityViewRenderEvent.CameraSetup event) {
        if (!TropicsConfigs.enableSwimAnimation) {
            return;
        }
        if (event.getEntity().equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g != null && !Minecraft.func_71410_x().field_71439_g.field_70128_L) {
            EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
            MessagePlayerSwimData.PlayerSwimData d = this.getData((EntityPlayer)p);
            event.setRoll(-d.currentRotationRoll * 0.25f);
        }
    }

    @SubscribeEvent
    public void onRenderTick(RenderWorldLastEvent event) {
        if (!TropicsConfigs.enableSwimAnimation) {
            return;
        }
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (!(p == null || p.field_70128_L || Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 && Minecraft.func_71410_x().field_71462_r == null)) {
            if (!this.isInWater((EntityPlayer)p)) {
                this.updateSwimDataAngles((EntityPlayer)p);
            }
            this.updateSwimRenderAngles((EntityPlayer)p);
        }
    }

    @SubscribeEvent
    public void onTickPlayer(TickEvent.PlayerTickEvent event) {
        if (!TropicsConfigs.enableSwimAnimation) {
            return;
        }
        if (!event.type.equals((Object)TickEvent.Type.PLAYER)) {
            return;
        }
        if (event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        EntityPlayer p = event.player;
        if (!p.field_71075_bZ.field_75100_b) {
            boolean inLiquid;
            MessagePlayerSwimData.PlayerSwimData d = this.getData(p);
            double above = 1.5;
            if (d.currentRotationPitch != 0.0f) {
                above = 2.0;
            }
            boolean liquidAbove = this.isInWater(p, 0.0, above, 0.0);
            boolean bl = inLiquid = this.isInWater(p) && this.isInWater(p, 0.0, -0.5, 0.0);
            if (inLiquid && !liquidAbove && d.currentRotationPitch < 45.0f && d.currentRotationPitch > -15.0f && p.field_70163_u - (double)((int)p.field_70163_u) < 0.5 && this.isPlayerWearingFlippers(p)) {
                d.targetRotationPitch = 0.0f;
                if (!inLiquid) {
                    p.field_70181_x -= 4.0;
                }
            }
            if (inLiquid && liquidAbove && this.isPlayerWearingFlippers(p)) {
                p.func_189654_d(true);
                d.targetSwimSpeed = 0.0f;
                if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74351_w)) {
                    d.targetSwimSpeed = this.getFlipperSpeed(p);
                }
                if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74368_y)) {
                    d.targetSwimSpeed = -this.getFlipperSpeed(p);
                }
                if (p.field_70702_br != 0.0f) {
                    d.targetSwimSpeed = this.getFlipperSpeed(p) / 2.0f;
                }
                if (d.currentSwimSpeed < d.targetSwimSpeed) {
                    d.currentSwimSpeed += 0.008f;
                    if (d.currentSwimSpeed > d.targetSwimSpeed) {
                        d.currentSwimSpeed = d.targetSwimSpeed;
                    }
                } else if (d.currentSwimSpeed > d.targetSwimSpeed) {
                    d.currentSwimSpeed -= 0.008f;
                    if (d.currentSwimSpeed < d.targetSwimSpeed) {
                        d.currentSwimSpeed = d.targetSwimSpeed;
                    }
                }
                float currentSpeed = d.currentSwimSpeed * 0.1f;
                float offset = 0.0f;
                p.field_70159_w = (double)currentSpeed * Math.sin((double)(-(d.currentRotationYaw + offset)) * (Math.PI / 180));
                p.field_70179_y = (double)currentSpeed * Math.cos((double)(-(d.currentRotationYaw + offset)) * (Math.PI / 180));
                p.field_70181_x = (double)currentSpeed * Math.sin((double)(d.currentRotationPitch + d.currentHeadPitchOffset) * (Math.PI / 180));
                if (p.func_70093_af()) {
                    p.func_70095_a(false);
                    p.field_70181_x = p.field_70181_x > (double)-0.2f ? (p.field_70181_x -= (double)0.02f) : (double)-0.2f;
                }
            } else {
                d.targetSwimSpeed = 0.0f;
                p.func_189654_d(false);
            }
        }
        TCPacketHandler.sendToServer(new MessagePlayerSwimData(this.getData(p)));
    }

    @SubscribeEvent
    public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        this.inGUI = true;
    }

    @SubscribeEvent
    public void onDrawScreenPos(GuiScreenEvent.DrawScreenEvent.Post event) {
        this.inGUI = false;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        boolean inLiquid;
        if (!TropicsConfigs.enableSwimAnimation) {
            return;
        }
        if (this.inGUI) {
            return;
        }
        EntityPlayer p = event.getEntityPlayer();
        MessagePlayerSwimData.PlayerSwimData d = this.getData(p);
        if (p.func_184613_cA() || p.func_184187_bx() instanceof EntityBeachFloat) {
            return;
        }
        this.updateSwimRenderAngles(p);
        boolean bl = inLiquid = this.isInWater(p) && this.isInWater(p, 0.0, 0.4, 0.0);
        if (inLiquid) {
            if (!p.field_70122_E && this.isPlayerWearingFlippers(p)) {
                p.field_70721_aZ = 0.2f + d.currentSwimSpeed / 20.0f;
            }
        } else if (d.currentRotationPitch == 0.0f && d.currentRotationRoll == 0.0f) {
            return;
        }
        GlStateManager.func_179094_E();
        boolean isSelf = d.playerUUID.equals(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        if (p.func_184218_aH() && p.func_184187_bx() instanceof EntityTropicraftWaterBase) {
            d.currentRotationYaw = 0.0f;
            d.currentRotationRoll = 0.0f;
            d.currentHeadPitchOffset = 0.0f;
            d.currentRotationPitch = 0.0f;
            d.rotationYawHead = 90.0f;
        }
        if (isSelf) {
            GlStateManager.func_179114_b((float)d.currentRotationYaw, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)d.currentRotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)d.currentRotationRoll, (float)0.0f, (float)0.0f, (float)-1.0f);
        } else {
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.func_179114_b((float)d.currentRotationYaw, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)d.currentRotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)d.currentRotationRoll, (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
        this.updateSwimDataAngles(p);
        this.clearPlayerRenderAngles(p);
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        boolean inLiquid;
        if (!TropicsConfigs.enableSwimAnimation) {
            return;
        }
        if (this.inGUI) {
            return;
        }
        if (event.getEntityPlayer().func_184613_cA() || event.getEntityPlayer().func_184187_bx() instanceof EntityBeachFloat) {
            return;
        }
        EntityPlayer p = event.getEntityPlayer();
        boolean bl = inLiquid = this.isInWater(p) && this.isInWater(p, 0.0, 0.4, 0.0);
        if (!inLiquid && this.getData((EntityPlayer)p).currentRotationPitch == 0.0f && this.getData((EntityPlayer)p).currentRotationRoll == 0.0f) {
            return;
        }
        this.restorePlayerRenderAngles(p);
        GlStateManager.func_179121_F();
    }

    public boolean isPlayerWearingFlippers(EntityPlayer p) {
        ItemStack bootSlot = p.field_71071_by.func_70440_f(0);
        if (bootSlot != null) {
            return bootSlot.func_77973_b().equals(ItemRegistry.pinkFlippers) || bootSlot.func_77973_b().equals(ItemRegistry.yellowFlippers);
        }
        return false;
    }

    public float getFlipperSpeed(EntityPlayer p) {
        ItemStack bootSlot = p.field_71071_by.func_70440_f(0);
        if (bootSlot != null && this.flipperSpeedMap.containsKey(bootSlot.func_77973_b())) {
            return this.flipperSpeedMap.get(bootSlot.func_77973_b()).floatValue();
        }
        return 0.0f;
    }

    public void updateSwimRenderAngles(EntityPlayer p) {
        MessagePlayerSwimData.PlayerSwimData d = this.getData(p);
        float ps = 1.0f;
        float ys = 2.0f;
        float rs = 0.5f;
        boolean liquidAbove = this.isInWater(p, 0.0, 1.4, 0.0);
        boolean inLiquid = this.isInWater(p);
        if (inLiquid && liquidAbove) {
            d.targetRotationYaw = p.field_70177_z;
            d.targetHeadPitchOffset = 45.0f;
            float t = p.field_70702_br * 90.0f;
            if (p.field_70702_br != 0.0f) {
                if (p.field_191988_bg != 0.0f) {
                    t = p.field_70702_br * 45.0f;
                }
                d.targetRotationYaw -= t;
            }
            if (!this.isPlayerWearingFlippers(p) && p.field_191988_bg == 0.0f && d.targetSwimSpeed == 0.0f) {
                d.targetHeadPitchOffset = d.targetRotationPitch = p.field_70125_A + 90.0f;
                if (d.targetHeadPitchOffset > 55.0f) {
                    d.targetHeadPitchOffset = 55.0f;
                }
            }
            if (d.targetRotationRoll != 0.0f) {
                d.targetRotationPitch -= 180.0f;
            }
            if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74314_A) && p.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                d.targetSwimSpeed = this.getFlipperSpeed(p);
                d.targetRotationPitch = 0.0f;
                d.targetHeadPitchOffset = 45.0f;
            }
            if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E) && p.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                d.targetSwimSpeed = this.getFlipperSpeed(p);
                d.targetRotationPitch = 180.0f;
                d.targetHeadPitchOffset = 45.0f;
            }
            d.targetRotationPitch += d.targetRotationRoll * 2.0f;
            if (p.field_191988_bg < 0.0f) {
                d.targetRotationPitch = p.field_70125_A - 65.0f;
                d.targetHeadPitchOffset = p.field_70125_A - 45.0f;
            }
            if (p.field_191988_bg > 0.0f) {
                d.targetRotationPitch = p.field_70125_A + 90.0f;
                d.targetHeadPitchOffset = p.field_70125_A + 90.0f;
                if (d.targetHeadPitchOffset > 90.0f) {
                    d.targetHeadPitchOffset = 90.0f;
                }
            }
            if (p.field_70702_br != 0.0f) {
                d.targetHeadPitchOffset = p.field_191988_bg == 0.0f ? p.field_70125_A + 55.0f : p.field_70125_A + 55.0f;
            }
            if (!this.isInWater(p, 0.0, -1.8, 0.0) && d.targetSwimSpeed == 0.0f && !this.isPlayerWearingFlippers(p)) {
                d.targetRotationPitch = 0.0f;
                d.targetHeadPitchOffset = 0.0f;
                d.targetRotationRoll = 0.0f;
                ps *= 4.0f;
                rs *= 4.0f;
                ys *= 4.0f;
            }
        } else {
            d.targetRotationPitch = 0.0f;
            d.targetRotationRoll = 0.0f;
            d.targetHeadPitchOffset *= 0.8f;
            d.targetRotationYaw = p.field_70177_z;
            ps *= 4.0f;
            rs *= 4.0f;
            ys *= 4.0f;
        }
        d.currentRotationPitch = this.lerp(MathHelper.func_76142_g((float)d.currentRotationPitch), MathHelper.func_76142_g((float)d.targetRotationPitch), ps);
        d.currentHeadPitchOffset = this.lerp(MathHelper.func_76142_g((float)d.currentHeadPitchOffset), MathHelper.func_76142_g((float)d.targetHeadPitchOffset), ps);
        d.currentRotationYaw = this.lerp(d.currentRotationYaw, d.targetRotationYaw, ys);
        d.currentRotationRoll = this.lerp(d.currentRotationRoll, d.targetRotationRoll, rs);
    }

    public void updateSwimDataAngles(EntityPlayer p) {
        MessagePlayerSwimData.PlayerSwimData d = this.getData(p);
        d.rotationYawHead = p.field_70759_as;
        d.prevRotationYawHead = p.field_70758_at;
        d.rotationYaw = p.field_70177_z;
        d.prevRotationYaw = p.field_70126_B;
        d.renderYawOffset = p.field_70761_aq;
        d.prevRenderYawOffset = p.field_70760_ar;
        d.rotationPitch = p.field_70125_A;
        d.prevRotationPitch = p.field_70127_C;
    }

    public void clearPlayerRenderAngles(EntityPlayer p) {
        MessagePlayerSwimData.PlayerSwimData d = this.getData(p);
        if (p.func_184218_aH() && p.func_184187_bx() instanceof EntityTropicraftWaterBase) {
            EntityTropicraftWaterBase fish = (EntityTropicraftWaterBase)p.func_184187_bx();
            p.field_70759_as = fish.field_70759_as;
            p.field_70758_at = fish.field_70758_at;
        } else {
            p.field_70759_as = 0.0f;
            p.field_70758_at = 0.0f;
            p.field_70177_z = 0.0f;
            p.field_70126_B = 0.0f;
        }
        p.field_70761_aq = 0.0f;
        p.field_70760_ar = 0.0f;
        p.field_70125_A = -MathHelper.func_76142_g((float)d.currentHeadPitchOffset);
        p.field_70127_C = -MathHelper.func_76142_g((float)d.currentHeadPitchOffset);
    }

    public void restorePlayerRenderAngles(EntityPlayer p) {
        MessagePlayerSwimData.PlayerSwimData d = this.getData(p);
        p.field_70759_as = d.rotationYawHead;
        p.field_70758_at = d.prevRotationYawHead;
        p.field_70177_z = d.rotationYaw;
        p.field_70126_B = d.prevRotationYaw;
        p.field_70761_aq = d.renderYawOffset;
        p.field_70760_ar = d.prevRenderYawOffset;
        p.field_70125_A = d.rotationPitch;
        p.field_70127_C = d.prevRotationPitch;
    }

    public boolean isInWater(EntityPlayer p, double offsetX, double offsetY, double offsetZ) {
        return p.field_70170_p.func_72875_a(p.func_174813_aQ().func_72317_d(offsetX, offsetY, offsetZ), Material.field_151586_h);
    }

    public boolean isInWater(EntityPlayer p) {
        return this.isInWater(p, 0.0, 0.0, 0.0);
    }

    public float lerp(float x1, float x2, float t) {
        float f = MathHelper.func_76142_g((float)(x2 - x1));
        if (f > t) {
            f = t;
        }
        if (f < -t) {
            f = -t;
        }
        return x1 + f;
    }

    public float rangeMap(float input, float inpMin, float inpMax, float outMin, float outMax) {
        if ((double)Math.abs(inpMax - inpMin) < 1.0E-12) {
            return 0.0f;
        }
        double ratio = (outMax - outMin) / (inpMax - inpMin);
        return (float)(ratio * (double)(input - inpMin) + (double)outMin);
    }

    private MessagePlayerSwimData.PlayerSwimData getData(EntityPlayer p) {
        if (!rotationMap.containsKey(p.func_110124_au())) {
            rotationMap.put(p.func_110124_au(), new MessagePlayerSwimData.PlayerSwimData(p.func_110124_au()));
        }
        return rotationMap.get(p.func_110124_au());
    }
}

