/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.biome.decorators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.tropicraft.core.common.biome.decorators.BiomeDecoratorTropicraft;
import net.tropicraft.core.common.block.BlockCoral;
import net.tropicraft.core.common.block.BlockTropicraftSands;
import net.tropicraft.core.common.enums.TropicraftCorals;
import net.tropicraft.core.common.enums.TropicraftOres;
import net.tropicraft.core.common.enums.TropicraftSands;
import net.tropicraft.core.common.worldgen.TCNoiseGen;
import net.tropicraft.core.common.worldgen.WorldGenCoral;
import net.tropicraft.core.common.worldgen.WorldGenSunkenShip;
import net.tropicraft.core.common.worldgen.WorldGenSurfaceClump;
import net.tropicraft.core.common.worldgen.WorldGenTropicsTreasure;
import net.tropicraft.core.registry.BlockRegistry;

public class BiomeDecoratorTropicsOcean
extends BiomeDecoratorTropicraft {
    public static final int TREASURE_CHANCE = 100;
    private static final IBlockState coralSand = BlockRegistry.sands.func_176223_P().func_177226_a(BlockTropicraftSands.VARIANT, (Comparable)((Object)TropicraftSands.CORAL));
    private static final TCNoiseGen coralGen = new WorldGenCoral(new Random(38745L));
    private static final WorldGenSurfaceClump coralReefGen = new WorldGenSurfaceClump(0.03f, 6, state -> ((BlockCoral)BlockRegistry.coral).canThisPlantGrowOnThisBlock(state.func_177230_c()), state -> true, rand -> BlockRegistry.coral.defaultForVariant(TropicraftCorals.VALUES[rand.nextInt(TropicraftCorals.VALUES.length)]), false){

        @Override
        protected boolean canPlaceBlock(World world, BlockPos pos) {
            return super.canPlaceBlock(world, pos) && ((BlockCoral)BlockRegistry.coral).canBlockStay(world, pos);
        }

        protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
            super.func_175903_a(worldIn, pos, state);
            for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177977_b().func_177974_f().func_177978_c(), (BlockPos)pos.func_177977_b().func_177976_e().func_177968_d())) {
                if (worldIn.func_180495_p(p).func_177230_c() != BlockRegistry.sands) continue;
                super.func_175903_a(worldIn, p, coralSand);
            }
        }
    };
    private static final IBlockState foamySand = BlockRegistry.sands.func_176223_P().func_177226_a(BlockTropicraftSands.VARIANT, (Comparable)((Object)TropicraftSands.FOAMY));
    private static final WorldGenSurfaceClump seaweedGen = new WorldGenSurfaceClump(0.025f, 8, state -> state.func_177230_c() == BlockRegistry.sands, state -> state.func_185904_a().func_76224_d(), rand -> BlockRegistry.seaweed.func_176223_P(), true){

        protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
            super.func_175903_a(worldIn, pos, state);
            for (BlockPos p : BlockPos.func_177980_a((BlockPos)pos.func_177974_f().func_177978_c(), (BlockPos)pos.func_177976_e().func_177968_d())) {
                if (worldIn.func_180495_p(p).func_177230_c() != BlockRegistry.sands) continue;
                super.func_175903_a(worldIn, p, foamySand);
            }
        }
    };
    private static final WorldGenSurfaceClump manganeseGen = new WorldGenSurfaceClump(0.025f, 8, state -> state.func_177230_c() == BlockRegistry.sands, state -> state.func_185904_a().func_76224_d(), rand -> BlockRegistry.ore.defaultForVariant(TropicraftOres.MANGANESE), true);
    private static final WorldGenSurfaceClump shakaGen = new WorldGenSurfaceClump(0.025f, 8, state -> state.func_177230_c() == BlockRegistry.sands, state -> state.func_185904_a().func_76224_d(), rand -> BlockRegistry.ore.defaultForVariant(TropicraftOres.SHAKA), true);

    @Override
    public void func_150513_a(Biome biome, World world, Random rand) {
        int k;
        int i;
        super.func_150513_a(biome, world, rand);
        coralGen.func_180709_b(world, rand, this.field_180294_c);
        coralReefGen.func_180709_b(world, rand, this.field_180294_c);
        seaweedGen.func_180709_b(world, rand, this.field_180294_c);
        manganeseGen.func_180709_b(world, rand, this.field_180294_c);
        shakaGen.func_180709_b(world, rand, this.field_180294_c);
        if (rand.nextInt(350) == 0) {
            i = this.randDecorationCoord(rand, this.field_180294_c.func_177958_n(), 16);
            k = this.randDecorationCoord(rand, this.field_180294_c.func_177952_p(), 16);
            new WorldGenSunkenShip(world, rand).generate(new BlockPos(i, this.getTerrainHeightAt(world, i, k), k));
        }
        if (rand.nextInt(100) == 0) {
            i = this.randDecorationCoord(rand, this.field_180294_c.func_177958_n(), 12);
            k = this.randDecorationCoord(rand, this.field_180294_c.func_177952_p(), 12);
            new WorldGenTropicsTreasure(world, rand).func_180709_b(world, rand, new BlockPos(i, this.getTerrainHeightAt(world, i, k), k));
        }
    }
}

