/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.BlockTropicraft;
import net.tropicraft.core.common.block.tileentity.TileEntityDrinkMixer;
import net.tropicraft.core.common.block.tileentity.TileEntityFactory;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.enums.BlockHardnessValues;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class BlockDrinkMixer
extends BlockTropicraft
implements ITileEntityProvider {
    @Nonnull
    public static final PropertyEnum<EnumFacing> FACING = BlockHorizontal.field_185512_D;

    public BlockDrinkMixer() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(BlockHardnessValues.CHUNK.resistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_190948_a(stack, world, tooltip, flag);
        tooltip.add(I18n.func_135052_a((String)"tropicraft.tooltip.drink_mixer", (Object[])new Object[0]));
    }

    public boolean func_185481_k(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return TileEntityFactory.getDrinkMixerTE();
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = entityPlayer.func_184614_ca();
        TileEntityDrinkMixer mixer = (TileEntityDrinkMixer)world.func_175625_s(pos);
        if (mixer == null) {
            return false;
        }
        if (mixer.isDoneMixing()) {
            mixer.retrieveResult(entityPlayer);
            return true;
        }
        if (stack.func_190926_b()) {
            mixer.emptyMixer(entityPlayer);
            return true;
        }
        ItemStack ingredientStack = stack.func_77946_l();
        ingredientStack.func_190920_e(1);
        if (mixer.addToMixer(ingredientStack)) {
            entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
        }
        if (ingredientStack.func_77973_b() == ItemRegistry.bambooMug && mixer.canMix()) {
            mixer.startMixing();
            entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
            Drink craftedDrink = MixerRecipes.getDrink(mixer.ingredients);
            Drink pinaColada = Drink.pinaColada;
            if (craftedDrink == null || craftedDrink.drinkId == pinaColada.drinkId) {
                // empty if block
            }
        }
        return true;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        IBlockState ret = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        return ret.func_177226_a(FACING, (Comparable)placer.func_174811_aO());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176736_b();
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegistry.drinkMixer);
    }
}

