/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.tropicraft.core.common.block.BlockTallPlant;
import net.tropicraft.core.common.enums.TropicraftTallPlants;

public class BlockPineapple
extends BlockTallPlant
implements IGrowable,
IPlantable {
    public static final int TOTAL_GROW_TICKS = 7;
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)1, (int)7);

    public BlockPineapple() {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)TropicraftTallPlants.PINEAPPLE)).func_177226_a((IProperty)HALF, (Comparable)((Object)BlockTallPlant.PlantHalf.LOWER)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, HALF, STAGE});
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FULL_HEIGHT_AABB;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((BlockTallPlant.PlantHalf)((Object)state.func_177229_b((IProperty)HALF))).ordinal() << 3 | (Integer)state.func_177229_b((IProperty)STAGE) & 7;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        int half = meta >> 3 & 1;
        int stage = meta & 7;
        IBlockState ret = this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)BlockTallPlant.PlantHalf.values()[half]));
        if (stage > 0) {
            ret = ret.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage));
        }
        return ret;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int currentStage = (Integer)state.func_177229_b((IProperty)STAGE);
        if (currentStage < 7) {
            IBlockState growthState = state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(currentStage + 1));
            world.func_180501_a(pos, growthState, 4);
        } else {
            IBlockState above = world.func_180495_p(pos.func_177984_a());
            if (above.func_177230_c() == this) {
                return;
            }
            if ((BlockTallPlant.PlantHalf)((Object)state.func_177229_b((IProperty)HALF)) == BlockTallPlant.PlantHalf.UPPER) {
                return;
            }
            IBlockState fullGrowth = state.func_177226_a(BlockTallPlant.HALF, (Comparable)((Object)BlockTallPlant.PlantHalf.UPPER));
            world.func_180501_a(pos.func_177984_a(), fullGrowth, 3);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkFlowerChange(world, pos, state);
        if (pos.func_177956_o() > world.func_72800_K() - 2) {
            return;
        }
        int growth = (Integer)state.func_177229_b((IProperty)STAGE);
        if (state.func_177230_c() == this && growth <= 7 && world.func_175623_d(pos.func_177984_a()) && (BlockTallPlant.PlantHalf)((Object)state.func_177229_b((IProperty)HALF)) == BlockTallPlant.PlantHalf.LOWER) {
            if (growth >= 6) {
                IBlockState growthState = state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(7));
                world.func_180501_a(pos, growthState, 4);
                IBlockState fullGrowth = state.func_177226_a(BlockTallPlant.HALF, (Comparable)((Object)BlockTallPlant.PlantHalf.UPPER));
                world.func_180501_a(pos.func_177984_a(), fullGrowth, 3);
            } else {
                IBlockState growthState = state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(growth + 1));
                world.func_180501_a(pos, growthState, 4);
            }
        }
    }

    private boolean isFullyGrown(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE) == 7 || (BlockTallPlant.PlantHalf)((Object)state.func_177229_b(BlockTallPlant.HALF)) == BlockTallPlant.PlantHalf.UPPER;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    protected final boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_180671_f(worldIn, pos, state)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        return block.canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected void checkFlowerChange(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && !this.func_180671_f(world, pos, state)) {
            if (this.isFullyGrown(state)) {
                this.func_176226_b(world, pos, state, 0);
            }
            world.func_175698_g(pos);
        }
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(worldIn, pos, state);
        }
        if (state.func_177229_b((IProperty)HALF) == BlockTallPlant.PlantHalf.UPPER) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        if (iblockstate.func_177230_c() == this) {
            return super.func_180671_f(worldIn, pos, iblockstate);
        }
        return this.func_176196_c(worldIn, pos);
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }
}

