/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.tropicraft.core.registry.BlockRegistry;

public class BlockTropicsWater
extends BlockFluidClassic {
    public BlockTropicsWater(Fluid fluid, Material material) {
        super(fluid, material);
        this.field_149786_r = 0;
        this.func_149647_a(null);
        this.displacements.put(BlockRegistry.coral, false);
        this.displacements.put(BlockRegistry.bambooFence, false);
        this.displacements.put(BlockRegistry.chunkFence, false);
        this.displacements.put(BlockRegistry.mahoganyFence, false);
        this.displacements.put(BlockRegistry.palmFence, false);
        this.displacements.put(BlockRegistry.thatchFence, false);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    @SubscribeEvent
    public void onCreateFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        if (event.getState().func_177230_c() == this) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() == Material.field_151586_h) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() == Material.field_151586_h) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public int getQuantaValue(IBlockAccess world, BlockPos pos) {
        int ret = super.getQuantaValue(world, pos);
        IBlockState state = world.func_180495_p(pos);
        return Optional.ofNullable((Integer)state.func_177228_b().get((Object)BlockFluidBase.LEVEL)).map(i -> this.quantaPerBlock - i).orElse(ret);
    }

    @Nonnull
    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return motion.func_178787_e(this.getFlow((IBlockAccess)worldIn, pos, worldIn.func_180495_p(pos)));
    }

    protected Vec3d getFlow(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int i = this.getRenderedDepth(state);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
            int j = this.getRenderedDepth(worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos));
            if (j < 0) {
                if (worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_185904_a().func_76230_c() || (j = this.getRenderedDepth(worldIn.func_180495_p(blockpos$pooledmutableblockpos.func_177977_b()))) < 0) continue;
                int k = j - (i - 8);
                d0 += (double)(enumfacing.func_82601_c() * k);
                d1 += (double)(enumfacing.func_96559_d() * k);
                d2 += (double)(enumfacing.func_82599_e() * k);
                continue;
            }
            if (j < 0) continue;
            int l = j - i;
            d0 += (double)(enumfacing.func_82601_c() * l);
            d1 += (double)(enumfacing.func_96559_d() * l);
            d2 += (double)(enumfacing.func_82599_e() * l);
        }
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        if ((Integer)state.func_177229_b((IProperty)LEVEL) >= 8) {
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing1);
                if (!this.causesDownwardCurrent(worldIn, (BlockPos)blockpos$pooledmutableblockpos, enumfacing1) && !this.causesDownwardCurrent(worldIn, blockpos$pooledmutableblockpos.func_177984_a(), enumfacing1)) continue;
                vec3d = vec3d.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return vec3d.func_72432_b();
    }

    protected int getDepth(IBlockState state) {
        return state.func_185904_a() == this.field_149764_J ? (Integer)state.func_177229_b((IProperty)LEVEL) : -1;
    }

    protected int getRenderedDepth(IBlockState state) {
        int i = this.getDepth(state);
        return i >= 8 ? 0 : i;
    }

    private boolean causesDownwardCurrent(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        if (material == this.field_149764_J) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return true;
        }
        if (material == Material.field_151588_w) {
            return false;
        }
        boolean flag = BlockTropicsWater.func_193382_c((Block)block) || block instanceof BlockStairs;
        return !flag && iblockstate.func_193401_d(worldIn, pos, side) == BlockFaceShape.SOLID;
    }
}

