/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.build.BuildServerTicks;
import net.tropicraft.core.common.build.world.Build;
import net.tropicraft.core.common.build.world.BuildJob;
import net.tropicraft.core.common.capability.WorldDataInstance;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.donations.DonationData;
import net.tropicraft.core.common.donations.ThreadWorkerDonations;
import net.tropicraft.core.common.donations.TickerDonation;
import net.tropicraft.core.common.worldgen.village.TownKoaVillage;
import net.tropicraft.core.common.worldgen.village.TownKoaVillageGenHelper;

public class CommandTropicsMisc
extends CommandBase {
    public String func_71517_b() {
        return "tc_misc";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandTropicsMisc.func_71521_c((ICommandSender)commandSender);
        if (args.length > 0) {
            String subcmd = args[0].toUpperCase(Locale.ROOT);
            try {
                SubCommand cmd = SubCommand.valueOf(subcmd);
                cmd.function.accept(player, args);
            }
            catch (IllegalArgumentException e) {
                throw new CommandException("Invalid subcommand " + e.toString(), new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTropicsMisc.func_71530_a((String[])args, (String[])((String[])Arrays.stream(SubCommand.values()).map(Enum::name).map(s -> s.toLowerCase(Locale.ROOT)).toArray(String[]::new)));
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    private static enum SubCommand {
        VILLAGE_COORD((player, args) -> {
            int x = 8452;
            int z = 5921;
            int relX = x - player.func_180425_c().func_177958_n();
            int relZ = z - player.func_180425_c().func_177952_p();
            System.out.println("pos: " + relZ + ", " + 0 + ", " + relX);
        }),
        VILLAGE_NEW((player, args) -> {
            WorldDataInstance storage;
            int z;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = player.field_70170_p.func_189649_b(x, z = MathHelper.func_76128_c((double)player.field_70161_v));
            if (y < 63) {
                y = 64;
            }
            if ((storage = (WorldDataInstance)player.field_70170_p.getCapability(Tropicraft.WORLD_DATA_INSTANCE, null)) != null) {
                TownKoaVillage village = new TownKoaVillage();
                int newID = storage.getAndIncrementKoaIDVillage();
                village.initData(newID, player.field_70170_p.field_73011_w.getDimension(), new BlockPos(x, y, z));
                village.direction = 0;
                village.initFirstTime();
                village.genStructure();
                storage.addTickingLocation(village);
            }
        }),
        VILLAGE_TRY((player, args) -> {
            boolean result;
            int z;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = player.field_70170_p.func_175672_r(new BlockPos(x, 0, z = MathHelper.func_76128_c((double)player.field_70161_v))).func_177956_o();
            if (y < 63) {
                y = 64;
            }
            if (!(result = TownKoaVillageGenHelper.hookTryGenVillage(new BlockPos(x, y, z), player.field_70170_p))) {
                System.out.println("failed to gen village");
            }
        }),
        VILLAGE_CUSTOM((player, args) -> {
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            WorldDataInstance storage = (WorldDataInstance)player.field_70170_p.getCapability(Tropicraft.WORLD_DATA_INSTANCE, null);
            if (storage != null) {
                TownKoaVillage village = new TownKoaVillage();
                int newID = storage.getAndIncrementKoaIDVillage();
                village.initData(newID, player.field_70170_p.field_73011_w.getDimension(), new BlockPos(x, y, z));
                village.direction = 0;
                village.isCustomVillage = true;
                village.minEntitiesToKeepAlive = 2;
                village.initFirstTime();
                village.generateSpawnCoords();
                player.func_145747_a((ITextComponent)new TextComponentString("spawned a new custom village"));
                storage.addTickingLocation(village);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("couldnt spawn a new custom village"));
            }
        }),
        SCHEMATIC_SAVE((player, args) -> {
            try {
                String name = args[1];
                Vec3d vec = player.func_174791_d();
                int sx = MathHelper.func_76128_c((double)CommandBase.func_175770_a((double)vec.field_72450_a, (String)args[2], (boolean)false).func_179628_a());
                int sy = MathHelper.func_76128_c((double)CommandBase.func_175770_a((double)vec.field_72448_b, (String)args[3], (boolean)false).func_179628_a());
                int sz = MathHelper.func_76128_c((double)CommandBase.func_175770_a((double)vec.field_72449_c, (String)args[4], (boolean)false).func_179628_a());
                int ex = MathHelper.func_76128_c((double)CommandBase.func_175770_a((double)vec.field_72450_a, (String)args[5], (boolean)false).func_179628_a());
                int ey = MathHelper.func_76128_c((double)CommandBase.func_175770_a((double)vec.field_72448_b, (String)args[6], (boolean)false).func_179628_a());
                int ez = MathHelper.func_76128_c((double)CommandBase.func_175770_a((double)vec.field_72449_c, (String)args[7], (boolean)false).func_179628_a());
                Build clipboardData = new Build(0, 0, 0, name, true);
                clipboardData.newFormat = true;
                clipboardData.recalculateLevelSize(sx, sy, sz, ex, ey, ez, true);
                clipboardData.scanLevelToData(player.field_70170_p);
                clipboardData.writeNBT();
                player.func_145747_a((ITextComponent)new TextComponentString("schematic saved to " + name + ".schematic"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                player.func_145747_a((ITextComponent)new TextComponentString("command usage: tc_village schematic_save <filename> <start coords> <end coords>"));
                player.func_145747_a((ITextComponent)new TextComponentString("eg: tc_village schematic_save myfile 0 0 0 5 5 5"));
                player.func_145747_a((ITextComponent)new TextComponentString("start and end coords are inclusive"));
            }
        }),
        SCHEMATIC_PRINT((player, args) -> {
            try {
                Vec3d vec = player.func_174791_d();
                String name = args[1];
                CommandBase.CoordinateArg sx = CommandBase.func_175770_a((double)vec.field_72450_a, (String)args[2], (boolean)false);
                CommandBase.CoordinateArg sy = CommandBase.func_175770_a((double)vec.field_72448_b, (String)args[3], (boolean)false);
                CommandBase.CoordinateArg sz = CommandBase.func_175770_a((double)vec.field_72449_c, (String)args[4], (boolean)false);
                int x = MathHelper.func_76128_c((double)sx.func_179628_a());
                int y = MathHelper.func_76128_c((double)sy.func_179628_a());
                int z = MathHelper.func_76128_c((double)sz.func_179628_a());
                int direction = 0;
                if (((String[])args).length > 5) {
                    direction = Integer.parseInt(args[5]);
                }
                Build buildData = new Build(x, y, z, name, false);
                BuildJob bj = new BuildJob(-99, x, y, z, buildData);
                bj.build.dim = player.field_70170_p.field_73011_w.getDimension();
                bj.useFirstPass = false;
                bj.useRotationBuild = true;
                bj.build_rate = 10000;
                bj.notifyFlag = 2;
                bj.setDirection(direction);
                BuildServerTicks.buildMan.addBuild(bj);
                player.func_145747_a((ITextComponent)new TextComponentString("printing schematic"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                player.func_145747_a((ITextComponent)new TextComponentString("command usage: tc_village schematic_print <filename> <start coords>"));
                player.func_145747_a((ITextComponent)new TextComponentString("eg: tc_village schematic_print myfile 5 5 5"));
            }
        }),
        ENTITIES((player, args) -> {
            HashMap<ResourceLocation, Integer> lookupCounts = new HashMap<ResourceLocation, Integer>();
            for (Entity ent : player.field_70170_p.field_72996_f) {
                if (!(ent instanceof EntityLivingBase)) continue;
                ResourceLocation key = EntityList.func_191306_a(ent.getClass());
                lookupCounts.merge(key, 1, (a, b) -> a + b);
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Entity counts: "));
            int count = 0;
            for (Map.Entry entry : lookupCounts.entrySet()) {
                ResourceLocation name = (ResourceLocation)entry.getKey();
                player.func_145747_a((ITextComponent)new TextComponentString(name + ": " + entry.getValue()));
                count += ((Integer)entry.getValue()).intValue();
            }
            player.func_145747_a((ITextComponent)new TextComponentString("total: " + count));
        }),
        MOUNT((player, args) -> {
            float clDist = 99999.0f;
            Entity clEntity = null;
            if (((String[])args).length < 2) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "/tc_misc mount <entity id or player name> [reverse]"));
                return;
            }
            String name = args[1];
            boolean reverse = false;
            boolean playerMode = false;
            Class<EntityPlayer> clazz = EntityList.getClass((ResourceLocation)new ResourceLocation(name));
            if (clazz == null) {
                clazz = EntityPlayer.class;
                playerMode = true;
            }
            if (((String[])args).length > 2 && (reverse = args[2].equals("reverse"))) {
                playerMode = false;
            }
            if (clazz != null) {
                List listEnts = player.field_70170_p.func_72872_a(clazz, player.func_174813_aQ().func_72314_b(15.0, 15.0, 15.0));
                for (Entity ent : listEnts) {
                    float dist = player.func_70032_d(ent);
                    if (!(dist < clDist)) continue;
                    if (!playerMode) {
                        clDist = dist;
                        clEntity = ent;
                        continue;
                    }
                    if (!player.func_70005_c_().equals(name)) continue;
                    clEntity = ent;
                    break;
                }
            }
            if (clEntity != null) {
                if (reverse) {
                    clEntity.func_184220_m((Entity)player);
                } else {
                    player.func_184220_m(clEntity);
                }
            }
        }),
        DONATION((player, args) -> {
            try {
                String content = ThreadWorkerDonations.getInstance().getData_Real();
                System.out.println(content);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }),
        DONATION_RESET((player, args) -> {
            DonationData donationData = (DonationData)player.field_70170_p.func_175693_T().func_75742_a(DonationData.class, "donationData");
            if (donationData != null) {
                DonationData donationData2 = donationData;
                synchronized (donationData2) {
                    donationData.resetData();
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Resetting donation data"));
            }
        }),
        DONATION_SETID((player, args) -> {
            DonationData donationData = (DonationData)player.field_70170_p.func_175693_T().func_75742_a(DonationData.class, "donationData");
            if (donationData != null) {
                int id = Integer.valueOf(args[1]);
                DonationData donationData2 = donationData;
                synchronized (donationData2) {
                    donationData.setLastSeenDate(id);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Reset last seen donation ID to " + id));
            }
        }),
        DONATION_SIM((player, args) -> {
            String name = String.valueOf(args[1]);
            int amount = Integer.valueOf(args[2]);
            player.func_145747_a((ITextComponent)new TextComponentString("Simulating donation for name " + name + " and amount " + amount));
            TickerDonation.simulateDonation(name, amount);
        }),
        DONATION_SIM_FIREWORKS((player, args) -> TickerDonation.simulateDonation("", 0)),
        DONATION_SETUP((player, args) -> {
            int id = Integer.valueOf(args[1]);
            String token = String.valueOf(args[2]);
            player.func_145747_a((ITextComponent)new TextComponentString("Setting campaign id and token"));
            TropicsConfigs.tiltifyCampaign = id;
            TropicsConfigs.tiltifyAppToken = token;
            TropicsConfigs.getConfig().get("~lovetropics", "tiltifyCampaign", TropicsConfigs.tiltifyCampaign).set(id);
            TropicsConfigs.getConfig().get("~lovetropics", "tiltifyAppToken", TropicsConfigs.tiltifyAppToken).set(token);
            TropicsConfigs.getConfig().save();
        }),
        DONATION_RATE((player, args) -> {
            int rate = Integer.valueOf(args[1]);
            player.func_145747_a((ITextComponent)new TextComponentString("Setting campaign query rate"));
            TropicsConfigs.donationTrackerRefreshRate = rate;
            TropicsConfigs.getConfig().get("~lovetropics", "donationTrackerRefreshRate", TropicsConfigs.donationTrackerRefreshRate).set(rate);
            TropicsConfigs.getConfig().save();
        }),
        DONATION_COMMAND((player, args) -> {
            String cmd = "";
            for (int i = 1; i < ((String[])args).length; ++i) {
                cmd = cmd + String.valueOf(args[i]);
                if (i == ((String[])args).length - 1) continue;
                cmd = cmd + " ";
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Setting campaign donation command to: " + cmd));
            TropicsConfigs.tiltifyCommandRun = cmd;
            TropicsConfigs.getConfig().get("~lovetropics", "tiltifyCommandRun", TropicsConfigs.tiltifyCommandRun).set(cmd);
            TropicsConfigs.getConfig().save();
        }),
        DONATION_MONUMENT_RATE((player, args) -> {
            int rate = Integer.valueOf(args[1]);
            player.func_145747_a((ITextComponent)new TextComponentString("Setting amount donated per monument addition to " + rate));
            TropicsConfigs.donationAmountPerMonument = rate;
            TropicsConfigs.getConfig().get("~lovetropics", "donationAmountPerMonument", TropicsConfigs.donationAmountPerMonument).set(rate);
            TropicsConfigs.getConfig().save();
        });

        private final BiConsumer<EntityPlayer, String[]> function;

        private SubCommand(BiConsumer<EntityPlayer, String[]> function) {
            this.function = function;
        }
    }
}

