/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.donations;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import net.tropicraft.core.common.config.TropicsConfigs;
import net.tropicraft.core.common.donations.DonationData;
import net.tropicraft.core.common.donations.JsonDataDonation;
import net.tropicraft.core.common.donations.TickerDonation;

public class ThreadWorkerDonations
implements Runnable {
    private static ThreadWorkerDonations instance;
    private static Thread thread;
    public volatile boolean running = false;
    private DonationData donationData;

    public static ThreadWorkerDonations getInstance() {
        if (instance == null) {
            instance = new ThreadWorkerDonations();
        }
        return instance;
    }

    public void startThread(DonationData donationData) {
        this.donationData = donationData;
        this.running = true;
        if (thread == null || thread.getState() == Thread.State.TERMINATED) {
            thread = new Thread((Runnable)instance, "Donations lookup thread");
            thread.start();
        }
    }

    public void stopThread() {
        this.running = false;
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                this.checkDonations();
                Thread.sleep(TimeUnit.SECONDS.toMillis(TropicsConfigs.donationTrackerRefreshRate));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void checkDonations() {
        try {
            if (TropicsConfigs.tiltifyAppToken.isEmpty() || TropicsConfigs.tiltifyCampaign == 0) {
                this.stopThread();
                return;
            }
            String contents = this.getData_Real();
            String contentsTotal = this.getData_TotalDonations();
            JsonDataDonation json = (JsonDataDonation)TickerDonation.GSON.fromJson(contents, JsonDataDonation.class);
            JsonDataDonation jsonTotal = (JsonDataDonation)TickerDonation.GSON_TOTAL.fromJson(contentsTotal, JsonDataDonation.class);
            json.totalDonated = jsonTotal.totalDonated;
            TickerDonation.callbackDonations(json);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData_Real() {
        try {
            String inputLine;
            URL url;
            DonationData donationData = this.donationData;
            synchronized (donationData) {
                url = new URL("https://tiltify.com/api/v3/campaigns/" + TropicsConfigs.tiltifyCampaign + "/donations?count=100" + (this.donationData.getLastSeenId() == 0 ? "" : "&after=" + this.donationData.getLastSeenId()));
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", "Bearer " + TropicsConfigs.tiltifyAppToken);
            int status = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer content = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            con.disconnect();
            return content.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData_TotalDonations() {
        try {
            String inputLine;
            URL url;
            DonationData donationData = this.donationData;
            synchronized (donationData) {
                url = new URL("https://tiltify.com/api/v3/campaigns/" + TropicsConfigs.tiltifyCampaign);
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", "Bearer " + TropicsConfigs.tiltifyAppToken);
            int status = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer content = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            con.disconnect();
            return content.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }
}

