/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.passive.EntityFishHook;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicalFish;
import net.tropicraft.core.common.item.ItemRiverFish;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityAIGoneFishin
extends EntityAIBase {
    private FISHING_STATE state = FISHING_STATE.IDLE;
    private boolean debugTask = false;
    private EntityKoaBase entity;
    private Random rand;
    private BlockPos posLastWaterFound;
    private BlockPos posLastLandFound;
    private int walkingTimeoutMax = 600;
    private int fishingTimeoutMax = 600;
    private int walkingTimeout;
    private int fishingTimeout;
    private float moveSpeedAmp = 1.0f;
    private int fishCaught = 0;
    private int repathPenalty = 0;
    private int repathPenaltyMax = 60;
    private int repathAttempts = 0;
    public long timeBetweenFishing = 1200L;
    public long timeBetweenFishingRandom = 30L;
    public List<ItemStack> listFishables = new ArrayList<ItemStack>();

    public EntityAIGoneFishin(EntityKoaBase entity) {
        int i;
        this.entity = entity;
        this.func_75248_a(3);
        this.rand = new Random();
        this.walkingTimeout = this.walkingTimeoutMax;
        this.fishingTimeout = this.fishingTimeoutMax;
        this.listFishables.add(new ItemStack(Items.field_151115_aP));
        this.listFishables.add(new ItemStack(ItemRegistry.freshMarlin));
        this.listFishables.add(new ItemStack(ItemRegistry.fertilizer));
        this.listFishables.add(new ItemStack(ItemRegistry.rawRay));
        for (i = 0; i < EntityTropicalFish.NAMES.length; ++i) {
            this.listFishables.add(new ItemStack((Item)ItemRegistry.rawTropicalFish, 1, i));
        }
        for (i = 0; i < ItemRiverFish.FISH_COLORS.length; ++i) {
            this.listFishables.add(new ItemStack((Item)ItemRegistry.rawRiverFish, 1, i));
        }
    }

    public void func_75249_e() {
        this.entity.setFishingItem();
    }

    public boolean func_75250_a() {
        this.entity.lastTimeFished = 0L;
        this.debugTask = false;
        BlockPos blockpos = new BlockPos((Entity)this.entity);
        if (!this.entity.field_70170_p.func_72935_r() || this.entity.field_70170_p.func_72896_J() && this.entity.field_70170_p.func_180494_b(blockpos).func_76738_d()) {
            return false;
        }
        boolean result = false;
        if (this.entity.lastTimeFished < this.entity.field_70170_p.func_82737_E() && this.entity.field_70170_p.field_73012_v.nextInt(3) == 0) {
            BlockPos posWater = this.findWater();
            if (posWater == null) {
                posWater = Util.findBlock((EntityLiving)this.entity, 5, Util::isDeepWater);
            }
            if (posWater != null) {
                if (Util.tryMoveToXYZLongDist((EntityLiving)this.entity, posWater, this.moveSpeedAmp)) {
                    this.posLastWaterFound = posWater;
                    result = true;
                    this.entity.lastTimeFished = this.entity.field_70170_p.func_82737_E() + this.timeBetweenFishing + this.timeBetweenFishingRandom;
                    this.setState(FISHING_STATE.WALKING_TO_WATER);
                    this.debug("found water, start executing");
                } else {
                    this.debug("failed the path, skip executing");
                }
            } else {
                this.debug("couldnt find water, skip executing");
            }
        }
        return result;
    }

    public boolean func_75253_b() {
        return this.posLastWaterFound != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_75246_d() {
        super.func_75246_d();
        if (this.repathPenalty > 0) {
            --this.repathPenalty;
        }
        if (this.state == FISHING_STATE.IDLE) {
            if (this.posLastWaterFound == null) {
                this.posLastWaterFound = this.findWater();
            }
            if (this.posLastWaterFound == null) {
                if (this.rand.nextInt(150) != 0) return;
                if (!this.entity.func_70661_as().func_75500_f()) return;
                return;
            }
            if (Util.tryMoveToXYZLongDist((EntityLiving)this.entity, this.posLastWaterFound, this.moveSpeedAmp)) {
                this.setState(FISHING_STATE.WALKING_TO_WATER);
                return;
            }
            this.debug("found water but pathing failed, abort");
            this.func_75251_c();
            return;
        }
        if (this.state == FISHING_STATE.WALKING_TO_WATER) {
            if (this.posLastWaterFound == null) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            if (!this.entity.func_70090_H()) {
                if (this.walkingTimeout <= 0 || this.entity.func_70661_as().func_75500_f()) {
                    if (this.walkingTimeout <= 0) {
                        this.debug("water pathing taking too long");
                    } else if (this.entity.func_70661_as().func_75500_f()) {
                        this.debug("water pathing having no path, pf find failed?");
                    }
                    if (!Util.tryMoveToXYZLongDist((EntityLiving)this.entity, this.posLastWaterFound, this.moveSpeedAmp)) {
                        this.func_75251_c();
                        return;
                    }
                    this.debug("found new path to try");
                }
            } else {
                BlockPos posLand = this.findLand();
                if (posLand != null) {
                    this.posLastLandFound = posLand;
                    if (!Util.tryMoveToXYZLongDist((EntityLiving)this.entity, posLand, this.moveSpeedAmp)) {
                        this.func_75251_c();
                        return;
                    }
                    this.setState(FISHING_STATE.WALKING_TO_LAND);
                }
            }
            if (this.entity.func_70011_f(this.posLastWaterFound.func_177958_n(), this.posLastWaterFound.func_177956_o(), this.posLastWaterFound.func_177952_p()) < 8.0 || this.entity.func_70090_H()) {
                this.entity.func_70661_as().func_75499_g();
                this.setState(FISHING_STATE.FISHING);
                this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
                this.castLine();
            }
            if (this.walkingTimeout <= 0) return;
            --this.walkingTimeout;
            return;
        }
        if (this.state == FISHING_STATE.FISHING) {
            BlockPos posLand;
            if (this.entity.func_70090_H() && (posLand = this.findLand()) != null) {
                this.posLastLandFound = posLand;
                if (!Util.tryMoveToXYZLongDist((EntityLiving)this.entity, posLand, this.moveSpeedAmp)) {
                    this.func_75251_c();
                    return;
                }
                this.setState(FISHING_STATE.WALKING_TO_LAND);
            }
            if (this.entity.getLure() != null && (this.entity.getLure().field_70122_E || this.entity.getLure().caughtEntity != null)) {
                this.func_75251_c();
            }
            if (!this.ifCaughtFish()) {
                --this.fishingTimeout;
                return;
            }
            this.retractLine();
            ++this.fishCaught;
            this.entity.inventory.func_174894_a(this.listFishables.get(this.rand.nextInt(this.listFishables.size())));
            this.debug("caught a fish");
            if (this.getFishCount() > 4 || this.rand.nextInt(1) == 0 && this.getFishCount() >= 2) {
                if (Util.tryMoveToXYZLongDist((EntityLiving)this.entity, this.entity.func_180486_cf(), this.moveSpeedAmp)) {
                    this.setState(FISHING_STATE.RETURN_TO_BASE);
                    return;
                }
                this.func_75251_c();
                return;
            }
            if (this.rand.nextInt(2) == 0) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            if (this.posLastWaterFound == null) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
            this.castLine();
            return;
        }
        if (this.state == FISHING_STATE.RETURN_TO_BASE) {
            if (this.entity.func_70011_f(this.entity.func_180486_cf().func_177958_n(), this.entity.func_180486_cf().func_177956_o(), this.entity.func_180486_cf().func_177952_p()) < 3.0) {
                this.debug("dropping off fish, reset");
                this.fishCaught = 0;
                this.entity.tryDumpInventoryIntoHomeChest();
                this.func_75251_c();
            }
            if ((this.walkingTimeout <= 0 || this.entity.func_70661_as().func_75500_f() && this.entity.field_70170_p.func_82737_E() % 20L == 0L) && !this.retryPathOrAbort(this.entity.func_180486_cf())) {
                return;
            }
            if (this.walkingTimeout <= 0) return;
            --this.walkingTimeout;
            return;
        }
        if (this.state != FISHING_STATE.WALKING_TO_LAND) return;
        if (this.entity.func_70011_f(this.posLastLandFound.func_177958_n(), this.posLastLandFound.func_177956_o(), this.posLastLandFound.func_177952_p()) < 5.0 || this.entity.field_70122_E) {
            this.posLastLandFound = new BlockPos((Vec3i)this.entity.func_180425_c());
            this.entity.func_70661_as().func_75499_g();
            this.setState(FISHING_STATE.FISHING);
            this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
            this.castLine();
            return;
        }
        if (this.walkingTimeout <= 0 || this.entity.func_70661_as().func_75500_f()) {
            if (this.walkingTimeout <= 0) {
                this.debug("pathing taking too long");
            } else if (this.entity.func_70661_as().func_75500_f()) {
                this.debug("pathing having no path, pf find failed?");
            }
            if (this.entity.func_70011_f(this.posLastLandFound.func_177958_n(), this.posLastLandFound.func_177956_o(), this.posLastLandFound.func_177952_p()) < 64.0 ? !this.retryPathOrAbort(this.posLastLandFound) : !this.retryPathOrAbort(this.posLastWaterFound)) {
                return;
            }
        }
        if (this.walkingTimeout <= 0) return;
        --this.walkingTimeout;
    }

    private void setState(FISHING_STATE state) {
        this.debug("setting state from " + (Object)((Object)this.state) + " to " + (Object)((Object)state) + " - " + this.entity.func_180425_c());
        if (state != FISHING_STATE.FISHING) {
            this.retractLine();
        }
        this.state = state;
        if (this.state == FISHING_STATE.FISHING) {
            this.fishingTimeout = this.fishingTimeoutMax;
        } else if (this.state == FISHING_STATE.WALKING_TO_LAND || this.state == FISHING_STATE.WALKING_TO_WATER || this.state == FISHING_STATE.RETURN_TO_BASE) {
            this.walkingTimeout = this.walkingTimeoutMax;
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.debug("reset task");
        this.fishCaught = 0;
        this.posLastLandFound = null;
        this.posLastWaterFound = null;
        this.repathAttempts = 0;
        this.retractLine();
        this.state = FISHING_STATE.IDLE;
    }

    private void maintainPathToBlock(BlockPos pos) {
        if (this.repathPenalty <= 0) {
            this.walkingTimeout = this.walkingTimeoutMax;
            boolean success = Util.tryMoveToXYZLongDist((EntityLiving)this.entity, pos, this.moveSpeedAmp);
            if (!success) {
                this.debug("repathing failed - " + this.entity.func_145782_y() + " - " + (Object)((Object)this.state) + " - " + pos);
                this.repathPenalty = this.repathPenaltyMax;
            }
        }
    }

    private boolean retryPathOrAbort(BlockPos pos) {
        boolean success = Util.tryMoveToXYZLongDist((EntityLiving)this.entity, pos, this.moveSpeedAmp);
        if (!success) {
            this.debug("repathing failed, resetting - " + this.entity.func_145782_y() + " - " + (Object)((Object)this.state) + " - " + pos);
            this.func_75251_c();
        } else {
            this.debug("repathing success - " + this.entity.func_145782_y() + " - " + (Object)((Object)this.state) + " - " + pos);
            this.walkingTimeout = this.walkingTimeoutMax;
        }
        return success;
    }

    private void debug(String str) {
        if (this.debugTask) {
            System.out.println(str);
        }
    }

    private BlockPos findWater() {
        return Util.findBlock((EntityLiving)this.entity, 60, Util::isDeepWater);
    }

    private BlockPos findLand() {
        return Util.findBlock((EntityLiving)this.entity, 60, Util::isLand);
    }

    private int getFishCount() {
        return this.fishCaught;
    }

    private boolean ifCaughtFish() {
        return this.fishingTimeout <= 40;
    }

    private void castLine() {
        this.fishingTimeout = this.fishingTimeoutMax;
        this.retractLine();
        this.entity.func_184609_a(EnumHand.MAIN_HAND);
        EntityFishHook lure = new EntityFishHook(this.entity.field_70170_p, this.entity);
        this.entity.field_70170_p.func_72838_d((Entity)lure);
    }

    private void retractLine() {
        if (this.entity.getLure() != null) {
            this.entity.getLure().func_70106_y();
        }
    }

    public void faceCoord(BlockPos coord, float maxDeltaYaw, float maxDeltaPitch) {
        this.faceCoord(coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p(), maxDeltaYaw, maxDeltaPitch);
    }

    public void faceCoord(int x, int y, int z, float maxDeltaYaw, float maxDeltaPitch) {
        double d = (double)((float)x + 0.5f) - this.entity.field_70165_t;
        double d2 = (double)((float)z + 0.5f) - this.entity.field_70161_v;
        double d1 = (double)((float)y + 0.5f) - (this.entity.field_70163_u + (double)this.entity.func_70047_e());
        double d3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
        this.entity.field_70125_A = -this.updateRotation(this.entity.field_70125_A, f3, maxDeltaPitch);
        this.entity.field_70177_z = this.updateRotation(this.entity.field_70177_z, f2, maxDeltaYaw);
    }

    public float updateRotation(float curRotation, float targetRotation, float maxDeltaRotation) {
        float f3;
        for (f3 = targetRotation - curRotation; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > maxDeltaRotation) {
            f3 = maxDeltaRotation;
        }
        if (f3 < -maxDeltaRotation) {
            f3 = -maxDeltaRotation;
        }
        return curRotation + f3;
    }

    static enum FISHING_STATE {
        IDLE,
        WALKING_TO_WATER,
        FISHING,
        RETURN_TO_BASE,
        WALKING_TO_LAND;

    }
}

