/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumHand;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.passive.EntityVMonkey;
import net.tropicraft.core.common.item.ItemCocktail;

public class EntityAIMonkeyPickUpPinaColada
extends EntityAIBase {
    private EntityVMonkey entity;
    private EntityItem drinkEntity;
    private final double speedModifier;
    private final PathNavigate navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public EntityAIMonkeyPickUpPinaColada(EntityVMonkey monkey) {
        this.entity = monkey;
        this.func_75248_a(2);
        this.speedModifier = 1.0;
        this.stopDistance = 1.0f;
        this.navigation = this.entity.func_70661_as();
        this.drinkEntity = null;
        if (!(this.entity.func_70661_as() instanceof PathNavigateGround) && !(this.entity.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    private boolean selfHoldingDrink(Drink drink) {
        ItemStack heldItem = this.entity.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemCocktail) {
            return ItemCocktail.getDrink(heldItem) == drink;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70909_n() && !this.selfHoldingDrink(Drink.pinaColada) && this.drinkEntity != null;
    }

    public boolean func_75250_a() {
        return !this.entity.func_70909_n() && !this.selfHoldingDrink(Drink.pinaColada) && this.hasNearbyDrink(Drink.pinaColada) && this.drinkEntity != null;
    }

    public void func_75251_c() {
        this.navigation.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    private boolean hasNearbyDrink(Drink drink) {
        ItemStack stack = MixerRecipes.getItemStack(drink);
        List list = this.entity.field_70170_p.func_72872_a(EntityItem.class, this.entity.func_174813_aQ().func_186662_g(10.0));
        if (!list.isEmpty()) {
            for (EntityItem item : list) {
                if (item.func_82150_aj() || !item.func_92059_d().func_77969_a(stack)) continue;
                this.drinkEntity = item;
                return true;
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.drinkEntity != null && !this.entity.func_110167_bD()) {
            this.entity.func_70671_ap().func_75651_a((Entity)this.drinkEntity, 10.0f, (float)this.entity.func_70646_bf());
            if (this.entity.func_70068_e((Entity)this.drinkEntity) > (double)(this.stopDistance * this.stopDistance)) {
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = 10;
                    double d0 = this.entity.field_70165_t - this.drinkEntity.field_70165_t;
                    double d1 = this.entity.field_70163_u - this.drinkEntity.field_70163_u;
                    double d2 = this.entity.field_70161_v - this.drinkEntity.field_70161_v;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                        this.navigation.func_75497_a((Entity)this.drinkEntity, this.speedModifier);
                    } else {
                        this.navigation.func_75499_g();
                        if (d3 <= (double)this.stopDistance) {
                            double d4 = this.drinkEntity.field_70165_t - this.entity.field_70165_t;
                            double d5 = this.drinkEntity.field_70161_v - this.entity.field_70161_v;
                            this.navigation.func_75492_a(this.entity.field_70165_t - d4, this.entity.field_70163_u, this.entity.field_70161_v - d5, this.speedModifier);
                        }
                    }
                }
            } else {
                this.entity.func_184611_a(EnumHand.MAIN_HAND, this.drinkEntity.func_92059_d());
                this.drinkEntity.func_70106_y();
            }
        }
    }
}

