/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.block.BlockTropicsFlowers;
import net.tropicraft.core.common.entity.EntityLand;
import net.tropicraft.core.common.entity.ai.EntityAITropiCreeperSwell;
import net.tropicraft.core.common.enums.TropicraftFlowers;
import net.tropicraft.core.registry.BlockRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityTropiCreeper
extends EntityLand
implements IMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int droppedSkulls = 0;

    public EntityTropiCreeper(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.7f);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            int radius = 5;
            int radiusSq = radius * radius;
            BlockPos center = this.func_180425_c();
            for (int i = 0; i < 3 * radiusSq; ++i) {
                IBlockState state;
                BlockPos attempt = center.func_177982_a(this.field_70146_Z.nextInt(radius * 2 + 1) - radius, 0, this.field_70146_Z.nextInt(radius * 2 + 1) - radius);
                if (!(attempt.func_177951_i((Vec3i)center) < (double)radiusSq)) continue;
                attempt = attempt.func_177981_b(radius);
                while (this.field_70170_p.func_180495_p(attempt).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, attempt) && attempt.func_177956_o() > center.func_177956_o() - radius) {
                    attempt = attempt.func_177977_b();
                }
                if (!BlockRegistry.flowers.func_180671_f(this.field_70170_p, attempt = attempt.func_177984_a(), state = BlockRegistry.flowers.func_176223_P().func_177226_a(BlockTropicsFlowers.VARIANT, (Comparable)((Object)TropicraftFlowers.VALUES[this.field_70146_Z.nextInt(TropicraftFlowers.VALUES.length)])))) continue;
                this.field_70170_p.func_175656_a(attempt, state);
            }
        } else {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITropiCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + ((int)this.func_110143_aJ() - 1);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
                this.onDeathBySelf();
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        if (par1DamageSource.func_76346_g() instanceof EntitySkeleton) {
            this.func_145779_a(ItemRegistry.recordEasternIsles, 1);
        }
        super.func_70645_a(par1DamageSource);
    }

    protected boolean setBlockState(int x, int y, int z, IBlockState state, int flags) {
        return this.field_70170_p.func_180501_a(new BlockPos(x, y, z), state, flags);
    }

    public void onDeathBySelf() {
        this.func_70645_a(DamageSource.field_188406_j);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public boolean func_70652_k(Entity par1Entity) {
        return true;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    public void func_70619_bc() {
        super.func_70619_bc();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }
}

