/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.egg.EntitySeaTurtleEgg;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicraftWaterBase;
import net.tropicraft.core.common.entity.underdasea.atlantoku.IAmphibian;
import net.tropicraft.core.registry.BlockRegistry;

public class EntitySeaTurtle
extends EntityTropicraftWaterBase
implements IAmphibian {
    private static final long EGG_SITE_WAIT_TIME = 450L;
    private static final long EGG_INTERVAL_MINIMUM = 2000L;
    private static final int NEST_SITE_SEARCH_ODDS = 100;
    private static final int MAX_BLOCK_SCAN_RADIUS = 32;
    private static final DataParameter<Boolean> IS_MATURE = EntityDataManager.func_187226_a(EntitySeaTurtle.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean isSeekingLand = false;
    public BlockPos currentNestSite = null;
    public BlockPos targetWaterSite = null;
    public boolean isLandPathing = false;
    public boolean isSeekingWater = false;
    public long timeSinceLastEgg = 0L;
    public long eggSiteCooldown = 450L;
    public PathNavigateGround png;
    public EntitySeaTurtleEgg lastEgg = null;

    public EntitySeaTurtle(World par1World) {
        super(par1World);
        this.func_70105_a(0.9f, 0.4f);
        this.setSwimSpeeds(1.0f, 1.0f, 1.0f);
        this.setApproachesPlayers(true);
        this.png = new PathNavigateGround((EntityLiving)this, par1World);
        this.field_70138_W = 1.0f;
        this.setMaxHealth(10);
        this.field_70728_aV = 6;
    }

    public EntitySeaTurtle(World world, int age) {
        this(world);
        this.func_70105_a(0.1f, 0.1f);
        this.setMaxHealth(3);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_MATURE, (Object)false);
        this.assignRandomTexture();
    }

    @Override
    public String[] getTexturePool() {
        return new String[]{"sea_turtle", "sea_turtle2", "sea_turtle3", "sea_turtle4", "sea_turtle5", "sea_turtle6"};
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_70050_g(30);
        if (this.func_175446_cd()) {
            return;
        }
        if (this.func_70661_as() == null) {
            return;
        }
        float renderSize = 0.3f + (float)this.field_70173_aa / 4000.0f;
        if (renderSize > 1.0f) {
            renderSize = 1.0f;
        }
        if (this.field_70173_aa % 40 == 1 && !this.isMature()) {
            this.func_70105_a(renderSize, renderSize * 0.5f);
        }
        if (this.isMature()) {
            renderSize = 1.0f;
            if (this.field_70173_aa == 1) {
                this.func_70105_a(0.9f, 0.4f);
            }
        }
        if (renderSize >= 1.0f) {
            this.setMature();
            ++this.timeSinceLastEgg;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.func_70090_H() && this.field_70122_E && this.func_184207_aI()) {
            this.func_184226_ay();
        }
        if (this.field_70122_E && !this.func_70090_H()) {
            this.swimSpeedCurrent = 0.0f;
        }
        if (this.timeSinceLastEgg > 2000L && !this.isSeekingLand && this.field_70146_Z.nextInt(100) == 0 && this.getTimeOfDay() > 13000L && this.getTimeOfDay() < 23000L) {
            this.isSeekingLand = true;
            this.log("Seeking Land");
        }
        if (this.field_70122_E && !this.func_70090_H() && !this.isLandPathing) {
            this.isLandPathing = true;
            this.isSeekingWater = true;
        }
        if (!(this.field_70170_p.func_72953_d(this.func_174813_aQ()) || this.isLandPathing || this.field_70122_E || this.func_184207_aI())) {
            this.field_70181_x = -0.2f;
            this.swimPitch = -25.0f;
            this.field_70159_w = (double)0.1f * Math.sin((double)this.field_70177_z * (Math.PI / 180));
            this.field_70179_y = (double)0.1f * Math.cos((double)this.field_70177_z * (Math.PI / 180));
            this.swimSpeedCurrent = 1.0f;
            this.func_189654_d(false);
        }
        if (!this.field_70170_p.func_72953_d(this.func_174813_aQ()) && this.isLandPathing && !this.field_70122_E && this.currentNestSite == null) {
            this.isSeekingWater = true;
            this.isSeekingLand = false;
            this.func_189654_d(false);
        }
        if (this.isSeekingLand) {
            if (this.currentNestSite == null) {
                if (this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(100) == 0) {
                    this.currentNestSite = this.scanSuitableNests();
                    if (this.currentNestSite != null) {
                        this.log("Found suitable nest site.");
                    } else {
                        this.setRandomTargetHeading();
                    }
                }
            } else {
                if (this.func_70090_H()) {
                    this.func_189654_d(true);
                    this.isLandPathing = false;
                    this.setTargetHeading(this.currentNestSite.func_177958_n(), this.currentNestSite.func_177956_o() + 13, this.currentNestSite.func_177952_p(), false);
                    BlockPos above = this.func_180425_c().func_177981_b(1);
                    Vec3d angle = this.getHeading();
                    double frontDist = 1.2f;
                    Vec3d diff = new Vec3d(this.field_70165_t + angle.field_72450_a * frontDist, this.field_70163_u, this.field_70161_v + angle.field_72449_c * frontDist);
                    BlockPos ahead = new BlockPos((int)diff.field_72450_a, (int)this.field_70163_u - 1, (int)diff.field_72449_c);
                    if (!this.field_70170_p.func_180495_p(above).func_185904_a().func_76224_d() && this.field_70170_p.func_180495_p(ahead).func_185904_a().func_76220_a()) {
                        this.field_70181_x += (double)0.2f;
                        this.swimSpeedCurrent = 2.0f;
                        this.log("Climbing up");
                        if (this.field_70163_u <= this.field_70167_r) {
                            this.log("Gave up, got stuck, was " + this.func_174818_b(this.currentNestSite) + " away");
                            this.currentNestSite = null;
                            this.isSeekingWater = true;
                            this.isLandPathing = true;
                            this.timeSinceLastEgg = 0L;
                            this.isSeekingLand = false;
                            this.eggSiteCooldown = 450L;
                        }
                    }
                } else {
                    this.isLandPathing = true;
                    this.func_189654_d(false);
                    if (this.func_174818_b(this.currentNestSite.func_177981_b(1)) > 3.0) {
                        if (this.field_70173_aa % 10 == 0) {
                            this.log("Trying to path to nest site");
                            this.func_184644_a(PathNodeType.BLOCKED, -1.0f);
                            this.func_184644_a(PathNodeType.WALKABLE, 10.0f);
                            this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
                            this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
                            Util.tryMoveToXYZLongDist((EntityLiving)this, this.currentNestSite.func_177958_n(), this.currentNestSite.func_177956_o(), this.currentNestSite.func_177952_p(), 0.2f);
                            if (this.func_70661_as().func_75500_f()) {
                                this.log("Gave up, was " + this.func_174818_b(this.currentNestSite) + " away");
                                this.currentNestSite = null;
                                this.isSeekingWater = true;
                                this.isLandPathing = true;
                                this.timeSinceLastEgg = 0L;
                                this.isSeekingLand = false;
                                this.eggSiteCooldown = 450L;
                            }
                        }
                    } else {
                        if (this.eggSiteCooldown == 450L) {
                            this.log("Close enough to nest, waiting 450 ticks to lay egg");
                        }
                        --this.eggSiteCooldown;
                        if (this.eggSiteCooldown <= 0L) {
                            this.log("egg laid!");
                            EntitySeaTurtleEgg egg = new EntitySeaTurtleEgg(this.field_70170_p);
                            egg.func_70107_b((float)this.currentNestSite.func_177958_n() + 0.5f, this.currentNestSite.func_177956_o() + 1, (float)this.currentNestSite.func_177952_p() + 0.5f);
                            this.lastEgg = egg;
                            egg.parentTexRef = this.getTexture();
                            this.field_70170_p.func_72838_d((Entity)egg);
                            this.field_70159_w = 0.0;
                            this.field_70179_y = 0.0;
                            this.currentNestSite = null;
                            this.isSeekingWater = true;
                            this.isLandPathing = true;
                            this.timeSinceLastEgg = 0L;
                            this.isSeekingLand = false;
                            this.eggSiteCooldown = 450L;
                        }
                    }
                }
                if (this.currentNestSite == null) {
                    this.setRandomTargetHeadingForce(30);
                }
            }
        }
        if (this.isSeekingWater) {
            if (this.targetWaterSite == null) {
                if (this.field_70173_aa % 20 == 0) {
                    this.log("Seeking water!");
                    this.targetWaterSite = this.scanForWater();
                    if (this.targetWaterSite == null) {
                        this.log("No luck finding water :(");
                    } else if (this.lastEgg != null) {
                        this.lastEgg.parentWaterLoc = this.targetWaterSite;
                    }
                }
            } else {
                this.isLandPathing = true;
                if (this.field_70173_aa % 40 == 0) {
                    this.func_184644_a(PathNodeType.WATER, 10.0f);
                    this.func_184644_a(PathNodeType.BLOCKED, -1.0f);
                    this.func_184644_a(PathNodeType.WALKABLE, 10.0f);
                    this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
                    this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
                    this.log("Moving to water!");
                    Util.tryMoveToXYZLongDist((EntityLiving)this, this.targetWaterSite, 0.2f);
                    if (this.func_70090_H()) {
                        // empty if block
                    }
                }
                if (this.func_70090_H()) {
                    this.setRandomTargetHeadingForce(10);
                    this.swimYaw = -this.func_70079_am();
                    this.swimPitch = -15.0f;
                    this.isLandPathing = false;
                    this.isSeekingWater = false;
                }
            }
        }
        this.func_70661_as().func_188554_j();
        this.func_70661_as().func_75501_e();
        if (!this.func_70090_H()) {
            this.swimYaw = -this.field_70177_z;
        }
    }

    public boolean shouldDismountInWater(Entity ent) {
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand.equals((Object)EnumHand.MAIN_HAND) && this.func_184219_q((Entity)player) && this.isMature() && this.func_70090_H()) {
            player.func_184220_m((Entity)this);
        }
        return super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
    }

    public BlockPos scanSuitableNests() {
        long millis = System.currentTimeMillis();
        this.log("Scan for suitable nest site started");
        ArrayList<BlockPos> potentials = new ArrayList<BlockPos>();
        int scanSize = 32;
        int scanSizeY = 8;
        for (int x = 0; x < scanSize; ++x) {
            for (int y = 0; y < scanSizeY; ++y) {
                for (int z = 0; z < scanSize; ++z) {
                    BlockPos sandCheck = this.func_180425_c().func_177982_a(-(scanSize / 2) + x, -(scanSizeY / 4) + y, -(scanSize / 2) + z);
                    BlockPos airCheck = sandCheck.func_177981_b(1);
                    if (!this.field_70170_p.func_180495_p(sandCheck).func_177230_c().equals(BlockRegistry.sands) || !this.field_70170_p.func_180495_p(airCheck).func_185904_a().equals(Material.field_151579_a)) continue;
                    potentials.add(sandCheck);
                }
            }
        }
        if (potentials.size() > 0) {
            this.log("Completed a scan for nest site with results tt=" + (System.currentTimeMillis() - millis));
            return (BlockPos)potentials.get(this.field_70146_Z.nextInt(potentials.size()));
        }
        this.log("Completed a scan for nest site without results tt=" + (System.currentTimeMillis() - millis));
        return null;
    }

    public BlockPos scanForWater() {
        long millis = System.currentTimeMillis();
        this.log("Scan for water started");
        ArrayList<BlockPos> potentials = new ArrayList<BlockPos>();
        int scanSize = 32;
        int scanSizeY = 8;
        for (int x = 0; x < scanSize; ++x) {
            for (int y = 0; y < scanSizeY; ++y) {
                for (int z = 0; z < scanSize; ++z) {
                    BlockPos waterCheck = this.func_180425_c().func_177982_a(-(scanSize / 2) + x, -(scanSizeY / 2) + y, -(scanSize / 2) + z);
                    BlockPos airCheck = waterCheck.func_177981_b(1);
                    if (!this.field_70170_p.func_180495_p(waterCheck).func_185904_a().equals(Material.field_151586_h) || !this.field_70170_p.func_180495_p(waterCheck.func_177977_b()).func_185904_a().equals(Material.field_151586_h) || !this.field_70170_p.func_180495_p(airCheck).func_185904_a().equals(Material.field_151579_a)) continue;
                    potentials.add(waterCheck);
                }
            }
        }
        if (potentials.size() > 0) {
            this.log("Completed a scan for waterblocks with results tt=" + (System.currentTimeMillis() - millis));
            double closest = -1.0;
            BlockPos closestBlock = null;
            for (BlockPos b : potentials) {
                if (!(this.func_174818_b(b) < closest) && closest != -1.0 || this.field_70146_Z.nextInt(5) != 0) continue;
                closestBlock = b;
            }
            if (closestBlock != null) {
                return closestBlock;
            }
            return (BlockPos)potentials.get(this.field_70146_Z.nextInt(potentials.size()));
        }
        this.log("Completed a scan for waterblocks without results tt=" + (System.currentTimeMillis() - millis));
        return null;
    }

    public float getMoveForward() {
        return this.field_191988_bg;
    }

    @Override
    public boolean setTargetHeading(double posX, double posY, double posZ, boolean waterChecks) {
        if (this.currentNestSite != null) {
            return super.setTargetHeading(this.currentNestSite.func_177958_n(), this.currentNestSite.func_177956_o() + 1, this.currentNestSite.func_177952_p(), false);
        }
        return super.setTargetHeading(posX, posY, posZ, waterChecks);
    }

    public boolean isMature() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_MATURE);
    }

    public void setMature() {
        if (!this.isMature()) {
            this.func_184212_Q().func_187227_b(IS_MATURE, (Object)true);
            this.func_70105_a(0.9f, 0.4f);
            this.setMaxHealth(10);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound n) {
        n.func_74757_a("isMature", this.isMature());
        super.func_70014_b(n);
    }

    @Override
    public void func_70037_a(NBTTagCompound n) {
        if (n.func_74767_n("isMature")) {
            this.setMature();
        }
        super.func_70037_a(n);
    }

    @Override
    public boolean func_70058_J() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public void func_70108_f(Entity entityIn) {
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 1.0 + (double)0.8f;
    }

    public boolean func_70617_f_() {
        return this.isSeekingLand && this.func_70090_H();
    }

    @Override
    public boolean func_175446_cd() {
        return super.func_175446_cd();
    }

    public PathNavigate func_70661_as() {
        if (this.isLandPathing) {
            return this.png;
        }
        return super.func_70661_as();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            f1 += 0.1f;
            f1 += -(this.swimPitch * 0.00525f);
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            f = -0.25f - this.swimPitch * 0.00525f;
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            if (passenger instanceof EntityPlayer) {
                EntityPlayer p = (EntityPlayer)passenger;
                if (this.func_70090_H()) {
                    if (p.field_191988_bg > 0.0f) {
                        this.swimPitch = this.lerp(this.swimPitch, -(passenger.field_70125_A * 0.5f), 6.0f);
                        this.swimYaw = this.lerp(this.swimYaw, -passenger.field_70177_z, 6.0f);
                        this.targetVector = null;
                        this.targetVectorHeading = null;
                        this.swimSpeedCurrent += 0.05f;
                        if (this.swimSpeedCurrent > 4.0f) {
                            this.swimSpeedCurrent = 4.0f;
                        }
                    }
                    if (p.field_191988_bg < 0.0f) {
                        this.swimSpeedCurrent *= 0.89f;
                        if (this.swimSpeedCurrent < 0.1f) {
                            this.swimSpeedCurrent = 0.1f;
                        }
                    }
                    if (p.field_191988_bg == 0.0f) {
                        if (this.swimSpeedCurrent > 1.0f) {
                            this.swimSpeedCurrent *= 0.94f;
                            if (this.swimSpeedCurrent <= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                        if (this.swimSpeedCurrent < 1.0f) {
                            this.swimSpeedCurrent *= 1.06f;
                            if (this.swimSpeedCurrent >= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                    }
                }
            }
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    public long getTimeOfDay() {
        return this.field_70170_p.func_82737_E() % 24000L;
    }

    public void log(String s) {
    }
}

