/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea.atlantoku;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicraftWaterBase;
import net.tropicraft.core.common.entity.underdasea.atlantoku.IAtlasFish;
import net.tropicraft.core.common.entity.underdasea.atlantoku.ai.EntityAISwimSchoolFollowLeader;

public class EntitySchoolableFish
extends EntityTropicraftWaterBase {
    public boolean shouldSpawnSchool = false;
    public EntityTropicraftWaterBase leader = null;
    public int minSchoolAmount = 5;
    public int maxSchoolAmount = 8;

    public EntitySchoolableFish(World world) {
        super(world);
        this.setShouldSpawnSchool(true);
        this.setIsLeader(true);
        this.setFishable(false);
    }

    public EntitySchoolableFish setSchoolLeader(EntityTropicraftWaterBase leader) {
        this.leader = leader;
        this.setShouldSpawnSchool(false);
        this.setIsLeader(false);
        this.setFishable(true);
        do {
            double offsetX = new Random().nextDouble() * 3.0 - 1.5;
            double offsetY = new Random().nextDouble() * 1.0 + 1.0;
            double offsetZ = new Random().nextDouble() * 3.0 - 1.5;
            this.func_70012_b(leader.field_70165_t + offsetX, leader.field_70163_u + offsetY, leader.field_70161_v + offsetZ, leader.field_70177_z, leader.field_70125_A);
        } while (!this.func_70601_bi());
        return this;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimSchoolFollowLeader(2, this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try {
            this.spawnSchool();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.func_70090_H()) {
            if (!this.getIsLeader() && this.leader == null) {
                List ents = this.field_70170_p.field_72996_f;
                for (int i = 0; i < ents.size(); ++i) {
                    EntityTropicraftWaterBase f;
                    if (!(ents.get(i) instanceof EntityTropicraftWaterBase) || !((Object)((Object)(f = (EntityTropicraftWaterBase)((Object)ents.get(i))))).getClass().getName().equals(((Object)((Object)this)).getClass().getName())) continue;
                    if (f instanceof IAtlasFish && this instanceof IAtlasFish) {
                        int slot = ((IAtlasFish)((Object)f)).getAtlasSlot();
                        if (((IAtlasFish)((Object)this)).getAtlasSlot() != slot) continue;
                    }
                    if (!f.getIsLeader()) continue;
                    this.leader = f;
                }
                if (this.field_70173_aa > 200 && this.leader == null) {
                    this.markAsLeader();
                }
            }
            if (this.field_70173_aa > 200 && this.leader == null && !this.getIsLeader()) {
                this.markAsLeader();
            }
        }
    }

    public void setSchoolSizeRange(int min, int max) {
        this.minSchoolAmount = min;
        this.maxSchoolAmount = max;
    }

    public void setShouldSpawnSchool(boolean spawnStatus) {
        this.shouldSpawnSchool = spawnStatus;
    }

    public boolean getShouldSpawnSchool() {
        return this.shouldSpawnSchool;
    }

    public void spawnSchool() {
        if (this.getShouldSpawnSchool() && !this.field_70170_p.field_72995_K) {
            int maxInSchool = this.maxSchoolAmount;
            int minInSchool = this.minSchoolAmount;
            int numToSpawn = this.field_70146_Z.nextInt(1 + maxInSchool - minInSchool) + minInSchool - 1;
            for (int i = 0; i < numToSpawn; ++i) {
                EntitySchoolableFish fish = (EntitySchoolableFish)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.func_70022_Q()), (World)this.field_70170_p);
                if (fish == null) continue;
                fish.setSchoolLeader(this);
                fish.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)fish)), null);
                this.field_70170_p.func_72838_d((Entity)fish);
            }
            this.setShouldSpawnSchool(false);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound n) {
        super.func_70014_b(n);
    }

    @Override
    public void func_70037_a(NBTTagCompound n) {
        this.setShouldSpawnSchool(false);
        super.func_70037_a(n);
    }
}

