/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea.atlantoku;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntitySchoolableFish;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityTropicraftWaterBase;
import net.tropicraft.core.common.entity.underdasea.atlantoku.IAtlasFish;
import net.tropicraft.core.common.item.ItemFishBucket;
import net.tropicraft.core.registry.ItemRegistry;

public class EntityTropicalFish
extends EntitySchoolableFish
implements IAtlasFish {
    public boolean targetHook = false;
    public Entity hook;
    public boolean hasBeenPlaced;
    public boolean isCatchable;
    public static final String[] NAMES = new String[]{"Clownfish", "Queen Angelfish", "Yellow Tang", "Butterflyfish", "Geophagus Surinamensis", "Betta Fish", "Regal Tang", "Royal Gamma"};
    private static final DataParameter<Integer> TEXTURE_COLOR = EntityDataManager.func_187226_a(EntityTropicalFish.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityTropicalFish(World world) {
        super(world);
        this.leader = null;
        this.func_70105_a(0.3f, 0.4f);
        this.setExpRate(3);
        this.setIsLeader(true);
        this.setSchoolSizeRange(12, 24);
        this.isCatchable = true;
        this.setSwimSpeeds(1.0f, 1.5f, 4.0f);
        this.setMaxHealth(2);
        this.setFleesPlayers(true, 5.0);
    }

    @Override
    public EntitySchoolableFish setSchoolLeader(EntityTropicraftWaterBase leader) {
        if (leader instanceof EntityTropicalFish) {
            this.setColor(((EntityTropicalFish)leader).getColor());
        }
        return super.setSchoolLeader(leader);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURE_COLOR, (Object)0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int color = this.field_70170_p.field_73012_v.nextInt(NAMES.length);
        this.setColor(color);
        this.setDropStack(new ItemStack((Item)ItemRegistry.rawTropicalFish, 1, color), 1);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.fishingNet) {
            boolean firstHotbarSlot = false;
            int bucketSlot = -1;
            for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                ItemStack s = player.field_71071_by.func_70301_a(0 + i);
                if (!this.isFishHolder(s)) continue;
                bucketSlot = 0 + i;
                break;
            }
            if (bucketSlot == -1 && this.isFishHolder(player.func_184592_cb())) {
                bucketSlot = 36;
            }
            if (bucketSlot >= 0) {
                ItemStack fishHolder = player.field_71071_by.func_70301_a(bucketSlot);
                if (fishHolder.func_77973_b() == ItemRegistry.tropicsWaterBucket) {
                    fishHolder = new ItemStack(ItemRegistry.fishBucket);
                    player.field_71071_by.func_70299_a(bucketSlot, fishHolder);
                    player.field_71069_bz.func_75142_b();
                }
                if (ItemFishBucket.addFish(fishHolder, this)) {
                    player.func_184609_a(hand);
                    this.field_70170_p.func_184133_a(player, this.func_180425_c(), SoundEvents.field_187549_bG, SoundCategory.PLAYERS, 0.25f, 1.0f + this.field_70146_Z.nextFloat() * 0.4f);
                    this.func_130014_f_().func_72900_e((Entity)this);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isFishHolder(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == ItemRegistry.tropicsWaterBucket || stack.func_77973_b() == ItemRegistry.fishBucket);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE_COLOR);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(TEXTURE_COLOR, (Object)color);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("Placed", this.hasBeenPlaced);
        nbttagcompound.func_74768_a("Color", Integer.valueOf(this.getColor()).intValue());
        super.func_70014_b(nbttagcompound);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.hasBeenPlaced = nbttagcompound.func_74764_b("Placed") ? nbttagcompound.func_74767_n("Placed") : true;
        this.setColor(nbttagcompound.func_74762_e("Color"));
        this.setDropStack(new ItemStack((Item)ItemRegistry.rawTropicalFish, 1, this.getColor()), 1);
        super.func_70037_a(nbttagcompound);
    }

    public EntityLivingBase func_70638_az() {
        return null;
    }

    public void checkForHook() {
        List list = this.field_70170_p.func_72872_a(EntityFishHook.class, this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
        if (list.isEmpty()) {
            this.targetHook = false;
            this.hook = null;
            return;
        }
        this.hook = (EntityFishHook)list.get(0);
        this.targetHook = true;
    }

    public double func_70033_W() {
        return 0.0;
    }

    @Override
    public boolean func_70692_ba() {
        return this.hasBeenPlaced;
    }

    public void disableDespawning() {
        this.hasBeenPlaced = true;
    }

    @Override
    public int getAtlasSlot() {
        return (Integer)this.func_184212_Q().func_187225_a(TEXTURE_COLOR);
    }
}

