/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea.atlantoku;

import java.util.List;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.entity.underdasea.atlantoku.EntityHook;
import net.tropicraft.core.common.entity.underdasea.atlantoku.IAmphibian;
import net.tropicraft.core.common.entity.underdasea.atlantoku.IPredatorDiet;
import net.tropicraft.core.common.entity.underdasea.atlantoku.ai.EntityAISwimAvoidEntity;
import net.tropicraft.core.common.entity.underdasea.atlantoku.ai.EntityAISwimAvoidPredator;
import net.tropicraft.core.common.entity.underdasea.atlantoku.ai.EntityAISwimAvoidWalls;
import net.tropicraft.core.common.entity.underdasea.atlantoku.ai.EntityAISwimRandomLocation;
import net.tropicraft.core.common.entity.underdasea.atlantoku.ai.EntityAISwimTargetPrey;

public abstract class EntityTropicraftWaterBase
extends EntityWaterMob {
    private static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(EntityTropicraftWaterBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> HOOK_ID = EntityDataManager.func_187226_a(EntityTropicraftWaterBase.class, (DataSerializer)DataSerializers.field_187192_b);
    @SideOnly(value=Side.CLIENT)
    public boolean isInGui;
    public float swimPitch = 0.0f;
    public float swimYaw = 0.0f;
    public Vector2f targetVectorHeading;
    public Vec3d targetVector;
    public int outOfWaterTime = 0;
    public float outOfWaterAngle = 0.0f;
    public float fallVelocity = 0.0f;
    public float fallGravity = 0.0625f;
    public float prevSwimPitch = 0.0f;
    public float prevSwimYaw = 0.0f;
    private float swimAccelRate = 0.02f;
    private float swimDecelRate = 0.02f;
    private float swimSpeedDefault = 1.0f;
    protected float swimSpeedCurrent = 0.0f;
    private float swimSpeedPanic = 2.0f;
    private float swimSpeedTurn = 5.0f;
    public boolean isPanicking = false;
    public boolean fleeFromPlayers = false;
    public boolean approachPlayers = false;
    public double fleeDistance = 2.0;
    public boolean isAggressing = false;
    public boolean canAggress = false;
    public int eatenFishAmount = 0;
    public int maximumEatAmount = 5;
    private float swimSpeedChasing = 2.0f;
    private float swimSpeedCharging = 2.5f;
    public Entity aggressTarget = null;
    public EntityHook hookTarget = null;
    private boolean fishable = false;
    private ItemStack dropStack = ItemStack.field_190927_a;
    private int dropMaxAmt = 3;
    public float attackDamage = 1.0f;
    public boolean isMovingAwayFromWall = false;
    public boolean isLeader = false;

    public EntityTropicraftWaterBase(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.setSwimSpeeds(1.0f, 2.0f, 5.0f);
        if (this instanceof IPredatorDiet) {
            this.setHostile();
        }
        this.setMaxHealth(2);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)"");
        this.func_184212_Q().func_187214_a(HOOK_ID, (Object)-1);
        this.assignRandomTexture();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimAvoidPredator(0, this, 2.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimAvoidWalls(0, this));
        if (this.fleeFromPlayers) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimAvoidEntity(1, this, 5.0, new Class[]{EntityPlayer.class}));
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimTargetPrey(2, this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimRandomLocation(0, this));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70636_d() {
        super.func_70636_d();
        if (this instanceof IPredatorDiet && this.field_70170_p.func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL)) {
            Class[] prey;
            boolean hasPlayer = false;
            for (Class c : prey = ((IPredatorDiet)((Object)this)).getPreyClasses()) {
                if (!c.getName().equals(EntityPlayer.class.getName())) continue;
                hasPlayer = true;
                break;
            }
            if (hasPlayer) {
                this.func_70106_y();
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (!this.func_70090_H() && !this.isInGui) {
                ++this.outOfWaterTime;
                if (this.outOfWaterTime > 90) {
                    this.outOfWaterTime = 90;
                }
            } else if (this.outOfWaterTime > 0) {
                --this.outOfWaterTime;
            }
            if (!(this instanceof IAmphibian)) {
                this.field_70125_A = -this.swimPitch;
                this.field_70177_z = -this.swimYaw;
                this.field_70759_as = -this.swimYaw;
                this.field_70758_at = -this.prevSwimYaw;
                this.field_70761_aq = 0.0f;
                this.field_70726_aT = -this.swimPitch;
                this.field_70127_C = -this.prevSwimPitch;
                this.field_70126_B = -this.prevSwimYaw;
                double x = this.field_70165_t - this.field_70169_q;
                double y = this.field_70163_u - this.field_70167_r;
                double z = this.field_70161_v - this.field_70166_s;
                this.prevSwimYaw = this.swimYaw;
                this.prevSwimPitch = this.swimPitch;
                float yaw = this.field_70165_t == this.field_70169_q && this.field_70161_v == this.field_70166_s ? this.swimYaw : (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
                float pitch = this.field_70163_u == this.field_70167_r ? this.swimPitch : (float)(-(Math.atan2(y, MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
                this.swimYaw = this.lerp(this.swimYaw, (int)(-yaw), this.swimSpeedTurn * 4.0f);
                this.swimPitch = this.lerp(this.swimPitch, (int)(-pitch), this.swimSpeedTurn * 4.0f);
                this.field_70159_w *= (double)0.98f;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y *= (double)0.98f;
                if (!this.func_175446_cd()) return;
                if (!this.func_70090_H()) return;
                this.field_70181_x = 0.0;
                this.fallVelocity = 0.0f;
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.swimSpeedCurrent = 0.0f;
                return;
            }
            this.field_70125_A = -this.swimPitch;
            if (this.func_70090_H()) {
                this.field_70177_z = -this.swimYaw;
                this.field_70759_as = -this.swimYaw;
                this.field_70758_at = -this.prevSwimYaw;
                this.field_70761_aq = 0.0f;
                this.field_70126_B = -this.prevSwimYaw;
            } else {
                this.field_70759_as = this.field_70177_z;
            }
            this.field_70726_aT = -this.swimPitch;
            this.field_70127_C = -this.prevSwimPitch;
            double x = this.field_70165_t - this.field_70169_q;
            double y = this.field_70163_u - this.field_70167_r;
            double z = this.field_70161_v - this.field_70166_s;
            float yaw = this.field_70165_t == this.field_70169_q && this.field_70161_v == this.field_70166_s ? this.swimYaw : (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
            float pitch = this.field_70163_u == this.field_70167_r ? this.swimPitch : (float)(-(Math.atan2(y, MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
            if (this.field_70122_E && !this.func_70090_H()) {
                yaw = -this.field_70759_as;
            }
            this.prevSwimYaw = this.swimYaw;
            this.prevSwimPitch = this.swimPitch;
            this.swimYaw = this.lerp(this.swimYaw, (int)(-yaw), this.swimSpeedTurn * 2.0f);
            this.swimPitch = this.lerp(this.swimPitch, (int)(-pitch), this.swimSpeedTurn * 2.0f);
            return;
        }
        if (!(this instanceof IAmphibian && this.func_70090_H() || !(this instanceof IAmphibian))) {
            super.func_70636_d();
            return;
        }
        if (this.getHook() != null && (this.getHook().field_70128_L || !this.field_70170_p.field_72996_f.contains((Object)this.getHook()))) {
            this.setHook(null);
        }
        if (this.func_70090_H()) {
            EntityHook hook;
            float swimSpeedTurn = this.swimSpeedTurn;
            if (this.isMovingAwayFromWall) {
                swimSpeedTurn *= 1.8f;
            }
            if (this.isFishable() && (this.field_70173_aa + this.func_145782_y()) % 80 == 0 && this.field_70146_Z.nextInt(35) == 0) {
                List ents = this.field_70170_p.func_72872_a(EntityHook.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(16.0, 8.0, 16.0));
                for (int i = 0; i < ents.size(); ++i) {
                    EntityHook h = (EntityHook)((Object)ents.get(i));
                    if (!this.func_70685_l(h) || h.getHooked() != null || !h.func_70090_H()) continue;
                    this.hookTarget = h;
                }
            }
            if (this.hookTarget != null) {
                if (this.hookTarget.field_70128_L || !this.field_70170_p.field_72996_f.contains((Object)this.hookTarget) || this.hookTarget.getHooked() != null) {
                    this.hookTarget = null;
                    this.setRandomTargetHeadingForce(10);
                } else {
                    if (this.field_70173_aa % 20 == 0) {
                        this.setTargetHeading(this.hookTarget.field_70165_t, this.hookTarget.field_70163_u, this.hookTarget.field_70161_v, false);
                    }
                    if (this.func_70068_e(this.hookTarget) < 2.0 && this.hookTarget.getHooked() == null) {
                        this.hookTarget.setHooked((Entity)this);
                        this.hookTarget = null;
                    }
                }
            }
            if (this.getHook() != null && (hook = this.getHook()).getHooked() != null) {
                if (!hook.getHooked().equals((Object)this)) {
                    this.setHook(null);
                } else {
                    EntityPlayer angler = hook.getAngler();
                    if (angler != null) {
                        if (!((double)this.func_70032_d((Entity)angler) > 2.0)) {
                            hook.bringInHookedEntity();
                            return;
                        }
                        this.setTargetHeading(angler.field_70165_t, angler.field_70163_u, angler.field_70161_v, false);
                    } else {
                        hook.setHooked(null);
                        this.aggressTarget = null;
                        this.setRandomTargetHeadingForce(5);
                    }
                }
            }
            if (this.targetVectorHeading != null) {
                this.swimYaw = this.lerp(this.swimYaw, -this.targetVectorHeading.x, swimSpeedTurn);
                this.swimPitch = this.lerp(this.swimPitch, -this.targetVectorHeading.y, swimSpeedTurn);
            }
        }
        if (!this.func_70090_H() && !(this instanceof IAmphibian)) {
            this.setTargetHeading(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, false);
        }
        float currentSpeed = this.swimSpeedCurrent;
        float desiredSpeed = this.swimSpeedDefault;
        if (this.aggressTarget != null) {
            desiredSpeed = this.func_70068_e(this.aggressTarget) < 10.0 ? this.swimSpeedCharging : this.swimSpeedChasing;
        }
        if (this.hookTarget != null) {
            desiredSpeed = this.swimSpeedChasing;
        }
        if (this.isPanicking) {
            desiredSpeed = this.swimSpeedPanic;
        }
        if (this.field_70173_aa % 50 < 30) {
            desiredSpeed *= 0.8f;
        }
        if (this.getIsLeader()) {
            desiredSpeed *= 0.95f;
        }
        if (this.isMovingAwayFromWall) {
            desiredSpeed *= 0.6f;
            currentSpeed *= 0.8f;
        }
        if (this.swimSpeedCurrent < desiredSpeed) {
            this.swimSpeedCurrent += this.swimAccelRate;
        }
        if (this.swimSpeedCurrent > desiredSpeed) {
            this.swimSpeedCurrent -= this.swimDecelRate;
        }
        currentSpeed *= 0.1f;
        if (this.func_70090_H()) {
            this.field_70159_w = (double)currentSpeed * Math.sin((double)this.swimYaw * (Math.PI / 180));
            this.field_70179_y = (double)currentSpeed * Math.cos((double)this.swimYaw * (Math.PI / 180));
            this.field_70181_x = (double)currentSpeed * Math.sin((double)this.swimPitch * (Math.PI / 180));
            this.fallVelocity = 0.0f;
        }
        if (this.func_175446_cd() && this.func_70090_H()) {
            this.field_70181_x = 0.0;
            this.fallVelocity = 0.0f;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.swimSpeedCurrent = 0.0f;
        }
        if (!this.func_70090_H() && !(this instanceof IAmphibian)) {
            if (this.field_70122_E) {
                if (this.field_70146_Z.nextInt(6) == 0) {
                    this.field_70159_w += this.field_70146_Z.nextBoolean() ? (double)(this.field_70146_Z.nextFloat() / 8.0f) : (double)(-this.field_70146_Z.nextFloat() / 8.0f);
                    this.field_70179_y += this.field_70146_Z.nextBoolean() ? (double)(this.field_70146_Z.nextFloat() / 8.0f) : (double)(-this.field_70146_Z.nextFloat() / 8.0f);
                }
                this.field_70159_w *= 0.5;
                this.field_70179_y *= 0.5;
                if (this.field_70173_aa % 4 == 0) {
                    this.fallVelocity = -0.02f;
                }
                if (this.field_70146_Z.nextInt(20) == 0 || this.field_70737_aN > 0) {
                    this.fallVelocity = -0.03f;
                    this.swimPitch = 25.0f;
                }
            }
            if (this.swimPitch > 0.0f) {
                this.swimPitch -= 5.0f;
            }
            if (this.field_70173_aa % 20 == 0) {
                this.outOfWaterAngle = this.field_70146_Z.nextInt(360);
            }
            float turnSpeed = 5.0f;
            if (this.field_70737_aN > 0) {
                turnSpeed = 15.0f;
            }
            if (this.swimYaw > this.outOfWaterAngle) {
                this.swimYaw -= turnSpeed;
            }
            if (this.swimYaw < this.outOfWaterAngle) {
                this.swimYaw += turnSpeed;
            }
            float vel = this.fallVelocity;
            if (this.func_184188_bt().size() > 0) {
                vel *= 0.5f;
            }
            this.field_70181_x -= (double)vel;
            this.fallVelocity += this.fallGravity / 10.0f;
        }
        if (!this.func_70090_H() && this instanceof IAmphibian) {
            if (!this.field_70122_E) {
                this.field_70181_x -= (double)this.fallVelocity;
                this.fallVelocity += this.fallGravity / 10.0f;
            } else {
                this.fallVelocity = 0.0f;
            }
        }
        if (!(this.swimPitch > 45.0f)) return;
        this.swimPitch = 45.0f;
    }

    public void setMaxHealth(int h) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)h);
        this.func_70606_j(h);
    }

    public void markAsLeader() {
        this.setIsLeader(true);
    }

    public void setFleesPlayers(boolean b) {
        this.fleeFromPlayers = b;
    }

    public void setFleesPlayers(boolean b, double minDist) {
        this.setFleesPlayers(b);
        this.fleeDistance = minDist;
    }

    public void setApproachesPlayers(boolean b) {
        this.approachPlayers = b;
    }

    public void setDropStack(Item item, int max) {
        this.setDropStack(new ItemStack(item), max);
    }

    public void setDropStack(ItemStack stack, int max) {
        this.dropStack = stack.func_77946_l();
        this.dropMaxAmt = max;
    }

    public void setDropStack(Block item, int max) {
        this.setDropStack(new ItemStack(item), max);
    }

    public void setSwimSpeeds(float regular, float panic, float turnSpeed) {
        this.swimSpeedDefault = regular;
        this.swimSpeedPanic = panic;
        this.swimSpeedTurn = turnSpeed;
    }

    public void setSwimSpeeds(float r, float p, float t, float chasing, float charging) {
        this.setSwimSpeeds(r, p, t);
        this.swimSpeedChasing = chasing;
        this.swimSpeedCharging = charging;
    }

    public boolean setRandomTargetHeading() {
        EntityPlayer closest;
        boolean result = false;
        int dist = 16;
        Vec3d randBlock = new Vec3d(this.field_70165_t + (double)this.randFlip(dist), this.field_70163_u + (double)this.randFlip(dist / 2), this.field_70161_v + (double)this.randFlip(dist));
        result = this.setTargetHeading(randBlock.field_72450_a, randBlock.field_72448_b, randBlock.field_72449_c, true);
        if (this.approachPlayers && this.field_70146_Z.nextInt(50) == 0 && (closest = this.field_70170_p.func_72890_a((Entity)this, 32.0)) != null && closest.func_70090_H()) {
            result = this.setTargetHeading(closest.field_70165_t, closest.field_70163_u, closest.field_70161_v, true);
        }
        return result;
    }

    public void setRandomTargetHeadingForce(int maxTimes) {
        for (int i = 0; i < maxTimes && !this.setRandomTargetHeading(); ++i) {
        }
    }

    public int randFlip(int i) {
        return this.field_70146_Z.nextBoolean() ? this.field_70146_Z.nextInt(i) : -this.field_70146_Z.nextInt(i);
    }

    public float lerp(float x1, float x2, float t) {
        return x1 + t * 0.03f * MathHelper.func_76142_g((float)(x2 - x1));
    }

    public void setAttackDamage(float f) {
        this.attackDamage = f;
    }

    public boolean isFishable() {
        return this.fishable;
    }

    public void setFishable(boolean b) {
        this.fishable = b;
    }

    public Vec3d getHeading() {
        return new Vec3d(Math.sin((double)this.swimYaw * (Math.PI / 180)), Math.sin((double)this.swimPitch * (Math.PI / 180)), Math.cos((double)this.swimYaw * (Math.PI / 180))).func_72432_b();
    }

    public boolean setTargetHeading(double posX, double posY, double posZ, boolean waterChecks) {
        if (this.func_175446_cd()) {
            return false;
        }
        if (waterChecks) {
            BlockPos bp = new BlockPos((int)posX, (int)posY, (int)posZ);
            if (!this.field_70170_p.func_180495_p(bp).func_185904_a().func_76224_d()) {
                return false;
            }
            if (this.field_70170_p.func_180495_p(bp).func_185904_a().func_76220_a()) {
                return false;
            }
        }
        double x = (int)(posX - this.field_70165_t);
        double y = (int)(posY - this.field_70163_u);
        double z = (int)(posZ - this.field_70161_v);
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
        if (this.targetVectorHeading == null) {
            this.targetVectorHeading = new Vector2f();
        }
        this.targetVector = new Vec3d((double)((int)posX), (double)((int)posY), (double)((int)posZ));
        this.targetVectorHeading.x = yaw;
        this.targetVectorHeading.y = pitch;
        return true;
    }

    public void fleeEntity(Entity ent) {
        double x = ent.field_70165_t - this.field_70165_t;
        double y = ent.field_70163_u - this.field_70163_u;
        double z = ent.field_70161_v - this.field_70161_v;
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
        if (this.targetVectorHeading == null) {
            this.targetVectorHeading = new Vector2f();
        }
        if (this.targetVector == null) {
            this.targetVector = new Vec3d(ent.field_70165_t, ent.field_70163_u - 5.0 + (double)this.field_70146_Z.nextInt(10), ent.field_70161_v);
        }
        this.targetVectorHeading.x = yaw + 180.0f;
        this.targetVectorHeading.y = -(pitch / 2.0f);
    }

    public void setHostile() {
        this.canAggress = true;
    }

    public boolean getIsLeader() {
        return this.isLeader;
    }

    public void setIsLeader(boolean flag) {
        this.isLeader = flag;
    }

    public void setHook(EntityHook ent) {
        if (ent == null) {
            this.func_184212_Q().func_187227_b(HOOK_ID, (Object)-1);
            return;
        }
        this.func_184212_Q().func_187227_b(HOOK_ID, (Object)ent.func_145782_y());
    }

    public EntityHook getHook() {
        Entity hook = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(HOOK_ID)).intValue());
        if (hook != null && hook instanceof EntityHook) {
            return (EntityHook)hook;
        }
        return null;
    }

    public boolean isHooked() {
        return this.getHook() != null;
    }

    public void setTexture(String s) {
        if (s.length() == 0) {
            return;
        }
        this.func_184212_Q().func_187227_b(TEXTURE, (Object)s);
    }

    public void assignRandomTexture() {
        if (this.getTexturePool() != null && this.getTexturePool().length > 0) {
            this.setTexture(this.getTexturePool()[this.field_70146_Z.nextInt(this.getTexturePool().length)]);
        }
    }

    public float rangeMap(float input, float inpMin, float inpMax, float outMin, float outMax) {
        if ((double)Math.abs(inpMax - inpMin) < 1.0E-12) {
            return 0.0f;
        }
        double ratio = (outMax - outMin) / (inpMax - inpMin);
        return (float)(ratio * (double)(input - inpMin) + (double)outMin);
    }

    public String[] getTexturePool() {
        return null;
    }

    public String getTexture() {
        return (String)this.func_184212_Q().func_187225_a(TEXTURE);
    }

    public void setExpRate(int i) {
        this.field_70728_aV = i;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_175446_cd() {
        return super.func_175446_cd();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70601_bi() {
        if (this.func_180799_ab()) {
            return false;
        }
        return super.func_70601_bi();
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.setMaxHealth(2);
    }

    public boolean func_70058_J() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_71061_d_() {
    }

    public int func_70627_aG() {
        return this.func_70090_H() ? 120 : 240;
    }

    protected SoundEvent func_184639_G() {
        if (this.func_70090_H()) {
            return SoundEvents.field_187829_fQ;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    protected int func_70693_a(EntityPlayer entityplayer) {
        return this.field_70728_aV + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this instanceof IAmphibian && !this.func_70090_H()) {
            super.func_191986_a(strafe, vertical, forward);
            return;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (this.dropStack.func_190926_b()) {
            return;
        }
        if (damagesource.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            int i = this.field_70146_Z.nextInt(this.dropMaxAmt) + 1;
            this.dropStack.func_190920_e(1);
            for (int j = 0; j < i; ++j) {
                this.func_70099_a(this.dropStack, 0.0f);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && this.canAggress) {
            this.aggressTarget = source.func_76346_g();
            this.setTargetHeading(this.aggressTarget.field_70165_t, this.aggressTarget.field_70163_u + 1.0, this.aggressTarget.field_70161_v, false);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70014_b(NBTTagCompound n) {
        n.func_74778_a("texture", (String)this.func_184212_Q().func_187225_a(TEXTURE));
        n.func_74776_a("swimYaw", this.swimYaw);
        n.func_74776_a("swimPitch", this.swimPitch);
        n.func_74757_a("isLeader", this.getIsLeader());
        super.func_70014_b(n);
    }

    public void func_70037_a(NBTTagCompound n) {
        this.setTexture(n.func_74779_i("texture"));
        this.swimYaw = n.func_74760_g("swimYaw");
        this.swimPitch = n.func_74760_g("swimPitch");
        this.setIsLeader(n.func_74767_n("isLeader"));
        super.func_70037_a(n);
    }
}

