/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.enums;

import net.minecraft.util.math.AxisAlignedBB;
import net.tropicraft.core.common.enums.ITropicraftVariant;

public enum TropicraftFlowers implements ITropicraftVariant
{
    COMMELINA_DIFFUSA,
    CROCOSMIA,
    ORCHID,
    CANNA,
    ANEMONE(9),
    ORANGE_ANTHURIUM(11),
    RED_ANTHURIUM(11),
    MAGIC_MUSHROOM(11),
    PATHOS(15, 12),
    ACAI_VINE(7, 16),
    CROTON(13),
    DRACAENA(13),
    FERN(13),
    FOLIAGE(13),
    BROMELIAD(9);

    public static final TropicraftFlowers[] VALUES;
    public static final TropicraftFlowers[] OVERWORLD_FLOWERS;
    private final AxisAlignedBB bounds;

    private TropicraftFlowers() {
        this(7);
    }

    private TropicraftFlowers(int w) {
        this(w, 15);
    }

    private TropicraftFlowers(int w, int h) {
        float halfW = (float)w / 16.0f / 2.0f;
        this.bounds = new AxisAlignedBB(0.5 - (double)halfW, 0.0, 0.5 - (double)halfW, 0.5 + (double)halfW, (double)((float)h / 16.0f), 0.5 + (double)halfW);
    }

    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    @Override
    public String getTypeName() {
        return "flower";
    }

    static {
        VALUES = TropicraftFlowers.values();
        OVERWORLD_FLOWERS = new TropicraftFlowers[]{ORCHID, PATHOS, RED_ANTHURIUM, COMMELINA_DIFFUSA, ANEMONE, ORANGE_ANTHURIUM};
    }
}

