/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.enums;

import net.tropicraft.core.common.enums.ITropicraftVariant;
import net.tropicraft.core.common.enums.TropicraftSaplings;

public enum TropicraftLeaves implements ITropicraftVariant
{
    MAHOGANY(false, 0, TropicraftSaplings.MAHOGANY),
    PALM(true, 1, TropicraftSaplings.PALM),
    KAPOK(true, 2, null),
    FRUIT(false, 3, null);

    private static final TropicraftLeaves[] META_LOOKUP;
    private final boolean solid;
    private final int meta;
    private final TropicraftSaplings sapling;
    public static final TropicraftLeaves[] VALUES;

    private TropicraftLeaves(boolean solid, int meta, TropicraftSaplings sapling) {
        this.solid = solid;
        this.meta = meta;
        this.sapling = sapling;
    }

    public int getSaplingMeta() {
        if (this.sapling == null) {
            return -1;
        }
        return this.sapling.getMetadata();
    }

    public boolean isSolid() {
        return this.solid;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public static TropicraftLeaves byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    @Override
    public String getTypeName() {
        return "leaves";
    }

    static {
        META_LOOKUP = new TropicraftLeaves[TropicraftLeaves.values().length];
        VALUES = TropicraftLeaves.values();
        TropicraftLeaves[] tropicraftLeavesArray = TropicraftLeaves.values();
        int n = tropicraftLeavesArray.length;
        for (int i = 0; i < n; ++i) {
            TropicraftLeaves leaf;
            TropicraftLeaves.META_LOOKUP[leaf.getMeta()] = leaf = tropicraftLeavesArray[i];
        }
    }
}

