/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.enums;

import net.tropicraft.core.common.enums.BlockHardnessValues;
import net.tropicraft.core.common.enums.ITropicraftVariant;

public enum TropicraftLogs implements ITropicraftVariant
{
    MAHOGANY(0, BlockHardnessValues.MAHOGANY.hardness, BlockHardnessValues.MAHOGANY.resistance),
    PALM(1, BlockHardnessValues.PALM.hardness, BlockHardnessValues.PALM.resistance);

    private final float hardness;
    private final float resistance;
    private final int meta;
    private static final TropicraftLogs[] META_LOOKUP;

    private TropicraftLogs(int meta, float hardness, float resistance) {
        this.meta = meta;
        this.hardness = hardness;
        this.resistance = resistance;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    public static TropicraftLogs byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    @Override
    public String getTypeName() {
        return "log";
    }

    static {
        META_LOOKUP = new TropicraftLogs[TropicraftLogs.values().length];
        TropicraftLogs[] tropicraftLogsArray = TropicraftLogs.values();
        int n = tropicraftLogsArray.length;
        for (int i = 0; i < n; ++i) {
            TropicraftLogs log;
            TropicraftLogs.META_LOOKUP[log.getMeta()] = log = tropicraftLogsArray[i];
        }
    }
}

