/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.client.CocktailColorHandler;
import net.tropicraft.core.common.drinks.ColorMixer;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipe;
import net.tropicraft.core.common.item.ItemTropicraftColored;
import net.tropicraft.core.registry.DrinkMixerRegistry;
import net.tropicraft.core.registry.ItemRegistry;

public class ItemCocktail
extends ItemTropicraftColored {
    private static final int DEFAULT_COLOR = 15973942;

    public ItemCocktail() {
        super("cocktail");
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77642_a(ItemRegistry.bambooMug);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (stack.func_77978_p() == null) {
            return;
        }
        Drink drink = ItemCocktail.getDrink(stack);
        if (drink != null) {
            tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[0]));
        }
        NBTTagList ingredients = stack.func_77978_p().func_150295_c("Ingredients", 10);
        for (int i = 0; i < ingredients.func_74745_c(); ++i) {
            NBTTagCompound ingredient = ingredients.func_150305_b(i);
            byte id = ingredient.func_74771_c("IngredientID");
            String ingredientName = Ingredient.ingredientsList[id].getIngredient().func_82833_r();
            int ingredientColor = Ingredient.ingredientsList[id].getColor();
            tooltip.add(ingredientName);
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (MixerRecipe recipe : DrinkMixerRegistry.getRecipes()) {
            list.add((Object)ItemCocktail.makeCocktail(recipe));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public static int getCocktailColor(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            if (stack.func_77978_p().func_74764_b("Color")) {
                return stack.func_77978_p().func_74762_e("Color");
            }
            return 15973942;
        }
        return 15973942;
    }

    @Nonnull
    public static ItemStack makeCocktail(MixerRecipe recipe) {
        ItemStack stack = new ItemStack((Item)ItemRegistry.cocktail);
        NBTTagCompound nbt = new NBTTagCompound();
        Drink drink = recipe.getCraftingResult();
        nbt.func_74774_a("DrinkID", (byte)drink.drinkId);
        NBTTagList tagList = new NBTTagList();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : recipe.getIngredients()) {
            NBTTagCompound ingredientNbt = new NBTTagCompound();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.id);
            tagList.func_74742_a((NBTBase)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_74782_a("Ingredients", (NBTBase)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public static ItemStack makeCocktail(Ingredient[] ingredients) {
        ItemStack stack = new ItemStack((Item)ItemRegistry.cocktail);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("DrinkID", (byte)0);
        NBTTagList tagList = new NBTTagList();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            NBTTagCompound ingredientNbt = new NBTTagCompound();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.id);
            tagList.func_74742_a((NBTBase)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_74782_a("Ingredients", (NBTBase)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static Ingredient[] getIngredients(ItemStack stack) {
        if (stack.func_77973_b() != ItemRegistry.cocktail || !stack.func_77942_o()) {
            return new Ingredient[0];
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagList tagList = nbt.func_150295_c("Ingredients", 10);
        Ingredient[] ingredients = new Ingredient[tagList.func_74745_c()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            byte id = tagList.func_150305_b(i).func_74771_c("IngredientID");
            ingredients[i] = Ingredient.ingredientsList[id];
        }
        return ingredients;
    }

    public static Drink getDrink(ItemStack stack) {
        if (stack.func_77973_b() != ItemRegistry.cocktail || !stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return Drink.drinkList[nbt.func_74771_c("DrinkID")];
    }

    public int func_77626_a(@Nonnull ItemStack par1ItemStack) {
        return 32;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack par1ItemStack) {
        return EnumAction.DRINK;
    }

    public ItemStack onFoodEaten(ItemStack itemstack, World world, EntityPlayer player) {
        world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        for (Ingredient ingredient : ItemCocktail.getIngredients(itemstack)) {
            ingredient.onDrink(player);
        }
        Drink drink = ItemCocktail.getDrink(itemstack);
        if (drink != null) {
            drink.onDrink(player);
        }
        return new ItemStack(ItemRegistry.bambooMug);
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            this.onFoodEaten(stack, worldIn, player);
            Drink drink = ItemCocktail.getDrink(stack);
            if (!worldIn.func_175727_C(player.func_180425_c()) || drink == Drink.pinaColada) {
                // empty if block
            }
        }
        return new ItemStack(ItemRegistry.bambooMug);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Drink drink = ItemCocktail.getDrink(stack);
        if (drink == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public int getColor(ItemStack itemstack, int tintIndex) {
        Drink drink = ItemCocktail.getDrink(itemstack);
        return tintIndex == 0 || drink == null ? 0xFFFFFF : drink.color;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getColorHandler() {
        return new CocktailColorHandler();
    }

    @Override
    public String func_77667_c(ItemStack itemstack) {
        String name = this.func_77658_a();
        Drink drink = ItemCocktail.getDrink(itemstack);
        if (drink != null) {
            name = "tropicraft.drink." + drink.name;
        }
        return name;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        Drink drink = ItemCocktail.getDrink(stack);
        if (drink != null) {
            return drink.textFormatting.toString() + TextFormatting.BOLD + super.func_77653_i(stack);
        }
        return super.func_77653_i(stack);
    }
}

