/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.TeleporterTropics;
import net.tropicraft.core.common.dimension.TropicraftWorldUtils;
import net.tropicraft.core.common.item.ItemTropicraft;
import net.tropicraft.core.registry.BlockRegistry;

public class ItemPortalEnchanter
extends ItemTropicraft {
    public ItemPortalEnchanter() {
        this.field_77777_bU = 1;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack indirect = new ItemStack((Item)this);
        Util.getTagCompound(indirect).func_74757_a("DirectMode", false);
        list.add((Object)indirect);
        ItemStack direct = new ItemStack((Item)this);
        Util.getTagCompound(indirect).func_74757_a("DirectMode", true);
        list.add((Object)direct);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> list, ITooltipFlag flagIn) {
        boolean hasDirectMode = Util.getTagCompound(itemstack).func_74764_b("DirectMode");
        int mode = hasDirectMode ? (Util.getTagCompound(itemstack).func_74767_n("DirectMode") ? 1 : 0) : 0;
        list.add(I18n.func_74838_a((String)("portalenchanter.type_" + mode)));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        boolean isDirectMode = false;
        if (itemstack.func_77978_p() != null) {
            boolean bl = isDirectMode = Util.getTagCompound(itemstack).func_74764_b("DirectMode") ? Util.getTagCompound(itemstack).func_74767_n("DirectMode") : false;
        }
        if (!world.field_72995_K && (isDirectMode || entityplayer.field_71075_bZ.field_75098_d)) {
            TropicraftWorldUtils.teleportPlayer((EntityPlayerMP)entityplayer);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(world, entityplayer, false);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        if (!world.func_175660_a(entityplayer, blockpos)) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (!entityplayer.func_175151_a(blockpos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, itemstack)) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        int x = blockpos.func_177958_n();
        int y = blockpos.func_177956_o();
        int z = blockpos.func_177952_p();
        boolean found = false;
        for (int searchZ = -4; searchZ <= 4 && !found; ++searchZ) {
            for (int searchX = -4; searchX <= 4 && !found; ++searchX) {
                BlockPos pos = new BlockPos(x + searchX, y, z + searchZ);
                if (this.canGen(world, pos)) {
                    found = true;
                    entityplayer.func_184609_a(EnumHand.MAIN_HAND);
                    new TeleporterTropics(FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(entityplayer.field_71093_bK)).buildTeleporterAt(x + searchX, y, z + searchZ, (Entity)entityplayer);
                    itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
                }
                pos = null;
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public boolean canGen(World world, BlockPos pos) {
        if (pos.func_177956_o() < 9) {
            return false;
        }
        for (int offsetZ = -2; offsetZ < 3; ++offsetZ) {
            for (int offsetX = -2; offsetX < 3; ++offsetX) {
                BlockPos pos2 = new BlockPos(pos.func_177958_n() + offsetX, pos.func_177956_o(), pos.func_177952_p() + offsetZ);
                if (offsetX == -2 || offsetX == 2 || offsetZ == -2 || offsetZ == 2) {
                    Block block = world.func_180495_p(pos2).func_177230_c();
                    if (block == Blocks.field_150322_A || block == BlockRegistry.portalWall) continue;
                    return false;
                }
                if (world.func_180495_p(pos2).func_185904_a() != Material.field_151586_h) {
                    return false;
                }
                if (world.func_175623_d(pos2.func_177984_a())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }
}

