/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.common.item.scuba.ItemScubaGear;
import net.tropicraft.core.common.item.scuba.ScubaHelper;
import net.tropicraft.core.common.item.scuba.api.ScubaMaterial;

public class ItemScubaHelmet
extends ItemScubaGear {
    private final int TICKS_TO_BUBBLE = 60;
    private int ticksSinceBubbles = 60;

    public ItemScubaHelmet(ItemArmor.ArmorMaterial material, ScubaMaterial scubaMaterial, int renderIndex, EntityEquipmentSlot slot) {
        super(material, scubaMaterial, renderIndex, slot);
    }

    @Override
    public void onScubaTick(World world, EntityPlayer player, ItemStack itemStack) {
        --this.ticksSinceBubbles;
        if (world.field_72995_K && world.field_73012_v.nextBoolean() && this.ticksSinceBubbles <= 0 && ScubaHelper.isFullyUnderwater(world, player)) {
            for (int i = 0; i < world.field_73012_v.nextInt(4) + 12; ++i) {
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N, player.field_70163_u + world.field_73012_v.nextDouble() + (double)player.field_70131_O, player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N, 0.5, 0.5, 0.5, new int[0]);
            }
            this.ticksSinceBubbles = 60;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TropicraftRenderUtils.getTextureGui("snorkel"));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(0.0, (double)height, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)width, (double)height, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)width, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @Override
    protected void onRemovedFromArmorInventory(World world, EntityPlayer player, ItemStack itemstack) {
    }
}

