/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tropicraft.core.common.item.ItemTropicraft;
import net.tropicraft.core.common.item.scuba.ScubaCapabilities;
import net.tropicraft.core.common.item.scuba.api.AirTypeRegistry;
import net.tropicraft.core.common.item.scuba.api.IAirType;
import net.tropicraft.core.common.item.scuba.api.IScubaTank;

public class ItemScubaTank
extends ItemTropicraft {
    private final NumberFormat efficiencyFmt = DecimalFormat.getNumberInstance();

    public ItemScubaTank() {
        this.efficiencyFmt.setMaximumFractionDigits(2);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.field_77777_bU = 1;
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return ScubaCapabilities.getProvider(ScubaCapabilities.getTankCapability(), () -> {
            IScubaTank.ScubaTank ret = new IScubaTank.ScubaTank(){

                @Override
                public void setPressure(float pressure) {
                    super.setPressure(pressure);
                    stack.func_77982_d(this.serializeNBT());
                }

                @Override
                public void setAirType(IAirType type) {
                    super.setAirType(type);
                    stack.func_77982_d(this.serializeNBT());
                }
            };
            if (stack.func_77942_o()) {
                ret.deserializeNBT(stack.func_77978_p());
            }
            return ret;
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        IScubaTank cap = (IScubaTank)itemstack.getCapability(ScubaCapabilities.getTankCapability(), null);
        IAirType airType = cap.getAirType();
        list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tropicraft.gui.air.type", (Object[])new Object[]{TextFormatting.GRAY + airType.getDisplayName()}));
        list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tropicraft.gui.air.capacity", (Object[])new Object[]{TextFormatting.GRAY.toString() + airType.getMaxCapacity()}));
        list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tropicraft.gui.air.remaining", (Object[])new Object[]{TextFormatting.GRAY.toString() + cap.getPressure()}));
        list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tropicraft.gui.air.efficiency", (Object[])new Object[]{TextFormatting.GRAY + this.efficiencyFmt.format(airType.getUsageRate() * 20.0f)}));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack stack = new ItemStack((Item)this);
        IScubaTank tank = (IScubaTank)stack.getCapability(ScubaCapabilities.getTankCapability(), null);
        for (IAirType airType : AirTypeRegistry.INSTANCE.getTypes()) {
            tank.setPressure(0.0f);
            tank.setAirType(airType);
            list.add((Object)stack.func_77946_l());
            tank.setPressure(airType.getMaxCapacity());
            list.add((Object)stack.func_77946_l());
        }
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

