/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.worldgen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class TCNoiseGen
extends WorldGenerator {
    private final NoiseGeneratorPerlin noiseGen;
    private final int min;
    private final int max;
    private final double noiseCutoff;

    protected TCNoiseGen(Random rand, int minPerChunk, int maxPerChunk, double minNoise) {
        this.noiseGen = new NoiseGeneratorPerlin(rand, 1);
        this.min = minPerChunk;
        this.max = maxPerChunk;
        this.noiseCutoff = minNoise;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean ret = false;
        int toGenerate = rand.nextInt(this.max - this.min + 1) + this.min;
        for (int i = 0; i < toGenerate; ++i) {
            double noise;
            int x = rand.nextInt(16) + 8;
            int z = rand.nextInt(16) + 8;
            BlockPos toPlace = worldIn.func_175672_r(position.func_177982_a(x, 0, z)).func_177981_b(2);
            EnumActionResult res = EnumActionResult.PASS;
            while (res == EnumActionResult.PASS) {
                if (toPlace.func_177956_o() <= 0) {
                    res = EnumActionResult.FAIL;
                    continue;
                }
                toPlace = toPlace.func_177977_b();
                res = this.checkPlacement(worldIn, toPlace, rand);
            }
            if (res != EnumActionResult.SUCCESS || !((noise = (this.noiseGen.func_151601_a((double)toPlace.func_177958_n() + 0.5, (double)toPlace.func_177952_p() + 0.5) + 1.0) / 2.0) > this.noiseCutoff)) continue;
            IBlockState state = this.getStateFromNoise((noise - this.noiseCutoff) * (1.0 / (1.0 - this.noiseCutoff)));
            this.func_175903_a(worldIn, toPlace, state);
            ret = true;
        }
        return ret;
    }

    protected abstract EnumActionResult checkPlacement(World var1, BlockPos var2, Random var3);

    protected abstract IBlockState getStateFromNoise(double var1);
}

